/*
 * Decompiled with CFR 0.152.
 */
package javax.crypto;

import gnu.java.security.Engine;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.util.StringTokenizer;
import javax.crypto.BadPaddingException;
import javax.crypto.CipherSpi;
import javax.crypto.ExemptionMechanism;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;

public class Cipher {
    private static final String SERVICE = "Cipher";
    public static final int DECRYPT_MODE = 2;
    public static final int ENCRYPT_MODE = 1;
    public static final int PRIVATE_KEY = 2;
    public static final int PUBLIC_KEY = 1;
    public static final int SECRET_KEY = 3;
    public static final int UNWRAP_MODE = 4;
    public static final int WRAP_MODE = 3;
    private static final int INITIAL_STATE = 0;
    private CipherSpi cipherSpi;
    private Provider provider;
    private String transformation;
    private int state;

    public static final Cipher getInstance(String transformation) throws NoSuchAlgorithmException, NoSuchPaddingException {
        Provider[] providers = Security.getProviders();
        NoSuchPaddingException ex = null;
        String msg = "";
        int i = 0;
        while (i < providers.length) {
            try {
                return Cipher.getInstance(transformation, providers[i]);
            }
            catch (NoSuchAlgorithmException nsae) {
                msg = nsae.getMessage();
                ex = null;
            }
            catch (NoSuchPaddingException nspe) {
                ex = nspe;
            }
            ++i;
        }
        if (ex != null) {
            throw ex;
        }
        throw new NoSuchAlgorithmException(msg);
    }

    public static final Cipher getInstance(String transformation, String provider) throws NoSuchAlgorithmException, NoSuchProviderException, NoSuchPaddingException {
        Provider p = Security.getProvider(provider);
        if (p == null) {
            throw new NoSuchProviderException(provider);
        }
        return Cipher.getInstance(transformation, p);
    }

    public static final Cipher getInstance(String transformation, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException {
        CipherSpi result = null;
        Object key = null;
        String alg = null;
        String mode = null;
        String pad = null;
        String msg = "";
        if (transformation.indexOf(47) < 0) {
            try {
                result = (CipherSpi)Engine.getInstance(SERVICE, transformation, provider);
                return new Cipher(result, provider, transformation);
            }
            catch (Exception e) {
                msg = e.getMessage();
            }
        } else {
            StringTokenizer tok = new StringTokenizer(transformation, "/");
            if (tok.countTokens() != 3) {
                throw new NoSuchAlgorithmException("badly formed transformation");
            }
            alg = tok.nextToken();
            mode = tok.nextToken();
            pad = tok.nextToken();
            try {
                result = (CipherSpi)Engine.getInstance(SERVICE, transformation, provider);
                return new Cipher(result, provider, transformation);
            }
            catch (Exception e) {
                msg = e.getMessage();
                try {
                    result = (CipherSpi)Engine.getInstance(SERVICE, alg + '/' + mode, provider);
                    result.engineSetPadding(pad);
                    return new Cipher(result, provider, transformation);
                }
                catch (Exception e2) {
                    if (e2 instanceof NoSuchPaddingException) {
                        throw (NoSuchPaddingException)e2;
                    }
                    msg = e2.getMessage();
                    try {
                        result = (CipherSpi)Engine.getInstance(SERVICE, alg + "//" + pad, provider);
                        result.engineSetMode(mode);
                        return new Cipher(result, provider, transformation);
                    }
                    catch (Exception e3) {
                        msg = e3.getMessage();
                        try {
                            result = (CipherSpi)Engine.getInstance(SERVICE, alg, provider);
                            result.engineSetMode(mode);
                            result.engineSetPadding(pad);
                            return new Cipher(result, provider, transformation);
                        }
                        catch (Exception e4) {
                            if (e4 instanceof NoSuchPaddingException) {
                                throw (NoSuchPaddingException)e4;
                            }
                            msg = e4.getMessage();
                        }
                    }
                }
            }
        }
        throw new NoSuchAlgorithmException(transformation + ": " + msg);
    }

    public final String getAlgorithm() {
        return this.transformation;
    }

    public final int getBlockSize() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetBlockSize();
        }
        return 1;
    }

    public final ExemptionMechanism getExemptionMechanism() {
        return null;
    }

    public final byte[] getIV() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetIV();
        }
        return null;
    }

    public final AlgorithmParameters getParameters() {
        if (this.cipherSpi != null) {
            return this.cipherSpi.engineGetParameters();
        }
        return null;
    }

    public final Provider getProvider() {
        return this.provider;
    }

    public final byte[] doFinal() throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(new byte[0], 0, 0);
    }

    public final byte[] doFinal(byte[] input) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        return this.doFinal(input, 0, input.length);
    }

    public final byte[] doFinal(byte[] input, int inputOffset, int inputLength) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException {
        if (this.cipherSpi == null) {
            byte[] b = new byte[inputLength];
            System.arraycopy(input, inputOffset, b, 0, inputLength);
            return b;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        this.state = 0;
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLength);
    }

    public final int doFinal(byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.cipherSpi == null) {
            return 0;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        this.state = 0;
        return this.cipherSpi.engineDoFinal(new byte[0], 0, 0, output, outputOffset);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        if (this.cipherSpi == null) {
            if (inputLength > output.length - outputOffset) {
                throw new ShortBufferException();
            }
            System.arraycopy(input, inputOffset, output, outputOffset, inputLength);
            return inputLength;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        this.state = 0;
        return this.cipherSpi.engineDoFinal(input, inputOffset, inputLength, output, outputOffset);
    }

    public final int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output) throws IllegalStateException, IllegalBlockSizeException, BadPaddingException, ShortBufferException {
        return this.doFinal(input, inputOffset, inputLength, output, 0);
    }

    public final int getOutputSize(int inputLength) throws IllegalStateException {
        if (this.cipherSpi == null) {
            return inputLength;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("neither encrypting nor decrypting");
        }
        return this.cipherSpi.engineGetOutputSize(inputLength);
    }

    public final void init(int opmode, Certificate certificate) throws InvalidKeyException {
        this.init(opmode, certificate, new SecureRandom());
    }

    public final void init(int opmode, Key key) throws InvalidKeyException {
        this.state = opmode;
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, new SecureRandom());
        }
    }

    public final void init(int opmode, Certificate certificate, SecureRandom random) throws InvalidKeyException {
        boolean[] keyInfo;
        if (certificate instanceof X509Certificate && (keyInfo = ((X509Certificate)certificate).getKeyUsage()) != null) {
            switch (opmode) {
                case 2: {
                    if (!keyInfo[3]) {
                        throw new InvalidKeyException("the certificate's key cannot be used for transforming data");
                    }
                    if (!keyInfo[7]) break;
                    throw new InvalidKeyException("the certificate's key can only be used for encryption");
                }
                case 1: {
                    if (!keyInfo[3]) {
                        throw new InvalidKeyException("the certificate's key cannot be used for transforming data");
                    }
                    if (!keyInfo[8]) break;
                    throw new InvalidKeyException("the certificate's key can only be used for decryption");
                }
                case 4: {
                    if (keyInfo[2] && !keyInfo[7]) break;
                    throw new InvalidKeyException("the certificate's key cannot be used for key unwrapping");
                }
                case 3: {
                    if (keyInfo[2] && !keyInfo[8]) break;
                    throw new InvalidKeyException("the certificate's key cannot be used for key wrapping");
                }
            }
        }
        this.init(opmode, (Key)certificate.getPublicKey(), random);
    }

    public final void init(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        this.state = opmode;
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, random);
        }
    }

    public final void init(int opmode, Key key, AlgorithmParameters params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, params, new SecureRandom());
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.init(opmode, key, params, new SecureRandom());
    }

    public final void init(int opmode, Key key, AlgorithmParameters params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = opmode;
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, params, random);
        }
    }

    public final void init(int opmode, Key key, AlgorithmParameterSpec params, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        this.state = opmode;
        if (this.cipherSpi != null) {
            this.cipherSpi.engineInit(opmode, key, params, random);
        }
    }

    public final Key unwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws IllegalStateException, InvalidKeyException, NoSuchAlgorithmException {
        if (this.cipherSpi == null) {
            return null;
        }
        if (this.state != 4) {
            throw new IllegalStateException("instance is not for unwrapping");
        }
        return this.cipherSpi.engineUnwrap(wrappedKey, wrappedKeyAlgorithm, wrappedKeyType);
    }

    public final byte[] update(byte[] input) throws IllegalStateException {
        return this.update(input, 0, input.length);
    }

    public final byte[] update(byte[] input, int inputOffset, int inputLength) throws IllegalStateException {
        if (this.cipherSpi == null) {
            byte[] b = new byte[inputLength];
            System.arraycopy(input, inputOffset, b, 0, inputLength);
            return b;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("cipher is not for encrypting or decrypting");
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLength);
    }

    public final int update(byte[] input, int inputOffset, int inputLength, byte[] output) throws IllegalStateException, ShortBufferException {
        return this.update(input, inputOffset, inputLength, output, 0);
    }

    public final int update(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) throws IllegalStateException, ShortBufferException {
        if (this.cipherSpi == null) {
            if (inputLength > output.length - outputOffset) {
                throw new ShortBufferException();
            }
            System.arraycopy(input, inputOffset, output, outputOffset, inputLength);
            return inputLength;
        }
        if (this.state != 1 && this.state != 2) {
            throw new IllegalStateException("cipher is not for encrypting or decrypting");
        }
        return this.cipherSpi.engineUpdate(input, inputOffset, inputLength, output, outputOffset);
    }

    public final byte[] wrap(Key key) throws IllegalStateException, IllegalBlockSizeException, InvalidKeyException {
        if (this.cipherSpi == null) {
            return null;
        }
        if (this.state != 3) {
            throw new IllegalStateException("instance is not for key wrapping");
        }
        return this.cipherSpi.engineWrap(key);
    }

    protected Cipher(CipherSpi cipherSpi, Provider provider, String transformation) {
        this.cipherSpi = cipherSpi;
        this.provider = provider;
        this.transformation = transformation;
        this.state = 0;
    }
}

