/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.util.ArrayList;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.SimpleAttributeSet;

public class PlainDocument
extends AbstractDocument {
    private static final long serialVersionUID = 4758290289196893664L;
    public static final String lineLimitAttribute = "lineLimit";
    public static final String tabSizeAttribute = "tabSize";
    private AbstractDocument.BranchElement rootElement = (AbstractDocument.BranchElement)this.createDefaultRoot();
    private int tabSize = 8;

    private final void reindex() {
        Element[] lines;
        try {
            String str = this.content.getString(0, this.content.length());
            ArrayList elts = new ArrayList();
            int j = 0;
            int i = str.indexOf(10, 0);
            while (i != -1) {
                elts.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, j, i + 1));
                j = i + 1;
                i = str.indexOf(10, i + 1);
            }
            if (j < this.content.length()) {
                elts.add(this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, j, this.content.length()));
            }
            lines = new Element[elts.size()];
            i = 0;
            while (i < elts.size()) {
                lines[i] = (Element)elts.get(i);
                ++i;
            }
        }
        catch (BadLocationException e) {
            lines = new Element[]{this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, 0, 1)};
        }
        this.rootElement.replace(0, this.rootElement.getElementCount(), lines);
    }

    protected AbstractDocument.AbstractElement createDefaultRoot() {
        AbstractDocument.BranchElement root = (AbstractDocument.BranchElement)this.createBranchElement(null, SimpleAttributeSet.EMPTY);
        Element[] array = new Element[]{this.createLeafElement(root, SimpleAttributeSet.EMPTY, 0, 1)};
        root.replace(0, 0, array);
        return root;
    }

    protected void insertUpdate(AbstractDocument.DefaultDocumentEvent event, AttributeSet attributes) {
        this.reindex();
        super.insertUpdate(event, attributes);
    }

    protected void removeUpdate(AbstractDocument.DefaultDocumentEvent event) {
        super.removeUpdate(event);
        int p0 = event.getOffset();
        int len = event.getLength();
        int p1 = len + p0;
        int i1 = this.rootElement.getElementIndex(p0);
        int i2 = this.rootElement.getElementIndex(p1);
        if (i1 != i2) {
            Element el1 = this.rootElement.getElement(i1);
            Element el2 = this.rootElement.getElement(i2);
            int start = el1.getStartOffset();
            int end = el2.getEndOffset();
            Element newEl = this.createLeafElement(this.rootElement, SimpleAttributeSet.EMPTY, start, end);
            this.rootElement.replace(i1, i2 - i1 + 1, new Element[]{newEl});
        }
    }

    public Element getDefaultRootElement() {
        return this.rootElement;
    }

    public Element getParagraphElement(int pos) {
        Element root = this.getDefaultRootElement();
        return root.getElement(root.getElementIndex(pos));
    }

    public void insertString(int offs, String str, AttributeSet atts) throws BadLocationException {
        String string = str;
        if (Boolean.TRUE.equals(this.getProperty("filterNewlines"))) {
            string = str.replaceAll("\n", " ");
        }
        super.insertString(offs, string, atts);
    }

    public PlainDocument() {
        this(new GapContent());
    }

    public PlainDocument(AbstractDocument.Content content) {
        super(content);
    }
}

