/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments.perms;

import it.unimi.dsi.fastutil.ints.Int2ByteMap;
import it.unimi.dsi.fastutil.ints.Int2ByteOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.io.IOException;
import java.util.BitSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.campagnelab.goby.alignments.AlignmentReaderImpl;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.alignments.perms.PermutationWriter;
import org.campagnelab.goby.alignments.perms.QueryIndexPermutationInterface;
import org.campagnelab.goby.util.dynoptions.DynamicOptionClient;
import org.campagnelab.goby.util.dynoptions.RegisterThis;

public class QueryIndexPermutation
implements QueryIndexPermutationInterface {
    private static final Log LOG = LogFactory.getLog(QueryIndexPermutation.class);
    @RegisterThis
    public static DynamicOptionClient doc = new DynamicOptionClient(QueryIndexPermutation.class, "safe-mode:boolean, when true keeps query indices in memory even when the link appears to point backwards. This can help process some incorrect BAM files where pair-links incorrectly map the mate on the same reference, when it appears on a different chromosome  with  a position earlier than the primary read. Please note that this option can consume large amounts of  memory and should be used only for problematic BAM input files:false");
    private int smallestIndex = Integer.MAX_VALUE;
    private int biggestSmallIndex = Integer.MIN_VALUE;
    private PermutationWriter permutationWriter;
    private final String basename;
    private int globalQueryMaxOccurences = 1;
    private final Int2IntMap offlinePermutation = new Int2IntLinkedOpenHashMap();
    private static final int MAX_OFFLINE_CAPACITY = 100000;
    private boolean isSafeMode;
    private boolean closed;
    private int smallIndexCounter = 0;
    private final Int2IntMap queryIndexPermutation = new Int2IntOpenHashMap();
    private final BitSet queryIndicesAlreadySeen = new BitSet();
    private final Int2ByteMap timesRequested = new Int2ByteOpenHashMap();

    public static DynamicOptionClient doc() {
        return doc;
    }

    public void reset() {
        this.smallestIndex = Integer.MAX_VALUE;
        this.biggestSmallIndex = Integer.MIN_VALUE;
        this.smallIndexCounter = 0;
        this.queryIndexPermutation.clear();
        this.queryIndexPermutation.defaultReturnValue(-1);
        this.timesRequested.defaultReturnValue((byte)1);
        if (this.permutationWriter != null) {
            this.permutationWriter.close();
        }
        this.permutationWriter = new PermutationWriter(this.basename);
        this.isSafeMode = QueryIndexPermutation.doc().getBoolean("safe-mode");
    }

    public QueryIndexPermutation(String filename) {
        this.basename = AlignmentReaderImpl.getBasename(filename);
        this.reset();
    }

    @Override
    public Alignments.AlignmentEntry makeSmallIndices(Alignments.AlignmentEntry entry) {
        Alignments.AlignmentEntry.Builder merged = Alignments.AlignmentEntry.newBuilder(entry);
        this.makeSmallIndices(merged);
        return merged.build();
    }

    @Override
    public void makeSmallIndices(Alignments.AlignmentEntry.Builder entry) {
        int queryIndex = entry.getQueryIndex();
        int maxOccurence = this.calculateQueryIndexOccurrences(entry);
        int smallIndex = this.getSmallIndex(queryIndex, maxOccurence);
        entry.setQueryIndex(smallIndex);
        this.smallestIndex = Math.min(this.smallestIndex, smallIndex);
        this.biggestSmallIndex = Math.max(this.biggestSmallIndex, smallIndex);
        assert (smallIndex != -1) : "Query small index must never be negative. Observed for original queryIndex=" + queryIndex + " " + entry.build().toString();
    }

    private int calculateQueryIndexOccurrences(Alignments.AlignmentEntry.Builder entry) {
        if (entry.hasQueryIndexOccurrences()) {
            return entry.getQueryIndexOccurrences();
        }
        int queryIndex = entry.getQueryIndex();
        int queryIndexOccurrences = this.timesRequested.get(queryIndex) + 1;
        queryIndexOccurrences += entry.hasPairAlignmentLink() && (this.isForward(entry, entry.getPairAlignmentLink()) || this.isSafeMode) ? 1 : 0;
        queryIndexOccurrences += entry.hasSplicedForwardAlignmentLink() ? 1 : 0;
        if (entry.hasPairAlignmentLink()) {
            queryIndexOccurrences = Math.max(queryIndexOccurrences, entry.getPairAlignmentLink().getFragmentIndex() + 1);
        }
        if (entry.hasSplicedForwardAlignmentLink()) {
            queryIndexOccurrences = Math.max(queryIndexOccurrences, entry.getSplicedForwardAlignmentLink().getFragmentIndex() + 1);
        }
        return queryIndexOccurrences;
    }

    private boolean isForward(Alignments.AlignmentEntry.Builder entry, Alignments.RelatedAlignmentEntry pairAlignmentLink) {
        int targetIndex = entry.getTargetIndex();
        int position = entry.getPosition();
        int linkedTargetIndex = pairAlignmentLink.getTargetIndex();
        int linkedPosition = pairAlignmentLink.getPosition();
        if (linkedTargetIndex == targetIndex) {
            return linkedPosition >= position;
        }
        return linkedTargetIndex > targetIndex;
    }

    @Override
    public int getSmallestIndex() {
        if (this.smallestIndex == Integer.MAX_VALUE) {
            return 0;
        }
        return this.smallestIndex;
    }

    @Override
    public int getBiggestSmallIndex() {
        return this.biggestSmallIndex;
    }

    @Override
    public final void setSmallestIndex(int value) {
        this.smallestIndex = value;
    }

    @Override
    public final void setBiggestSmallIndex(int value) {
        this.biggestSmallIndex = value;
    }

    @Override
    public int permutate(int queryIndex) {
        return this.permutate(queryIndex, this.globalQueryMaxOccurences);
    }

    @Override
    public int permutate(int queryIndex, int maxQueryIndexOccurrence) {
        int smallIndex = this.getSmallIndex(queryIndex, maxQueryIndexOccurrence);
        this.smallestIndex = Math.min(this.smallestIndex, smallIndex);
        this.biggestSmallIndex = Math.max(this.biggestSmallIndex, smallIndex);
        return smallIndex;
    }

    public int internalDoPerm(int queryIndex, int maxQueryIndexOccurrence) {
        int smallIndex = this.queryIndexPermutation.get(queryIndex);
        byte timesSeen = (byte)(this.timesRequested.get(queryIndex) + 1);
        if (timesSeen >= maxQueryIndexOccurrence) {
            this.queryIndexPermutation.remove(queryIndex);
            this.pushToPreStorage(queryIndex, smallIndex);
        } else {
            this.timesRequested.put(queryIndex, timesSeen);
        }
        this.queryIndicesAlreadySeen.set(queryIndex);
        return smallIndex;
    }

    private void pushToPreStorage(int queryIndex, int smallIndex) {
        this.moveIndexToPreOffline(queryIndex, smallIndex);
        if (this.offlinePermutation.size() > 100000) {
            this.save();
        }
    }

    private int getSmallIndex(int queryIndex, int maxObservations) {
        if (!this.queryIndicesAlreadySeen.get(queryIndex)) {
            int smallIndex = this.smallIndexCounter++;
            this.queryIndicesAlreadySeen.set(queryIndex, true);
            if (maxObservations > 1) {
                this.queryIndexPermutation.put(queryIndex, smallIndex);
                this.timesRequested.put(queryIndex, (byte)1);
            } else {
                this.pushToPreStorage(queryIndex, smallIndex);
            }
            return smallIndex;
        }
        int smallIndex = this.internalDoPerm(queryIndex, maxObservations);
        return smallIndex;
    }

    private void moveIndexToPreOffline(int queryIndex, int smallIndex) {
        this.offlinePermutation.put(queryIndex, smallIndex);
    }

    @Override
    public void setPruneLimit(byte limit) {
        this.globalQueryMaxOccurences = limit;
    }

    @Override
    public void close() {
        if (!this.closed) {
            IntIterator intIterator = this.queryIndexPermutation.keySet().iterator();
            while (intIterator.hasNext()) {
                int queryIndex = (Integer)intIterator.next();
                this.moveIndexToPreOffline(queryIndex, this.queryIndexPermutation.get(queryIndex));
            }
            this.queryIndexPermutation.clear();
            this.save();
            this.permutationWriter.close();
            this.closed = true;
        }
    }

    public boolean isInMap(int queryIndex) {
        return this.queryIndexPermutation.containsKey(queryIndex);
    }

    private void save() {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)"Saving new permutation chunk ");
        }
        try {
            this.permutationWriter.append(this.offlinePermutation);
            this.offlinePermutation.clear();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to write permutation component.", e);
        }
    }

    public boolean isOnDisk(int queryIndex) {
        return !this.isInMap(queryIndex) && this.queryIndicesAlreadySeen.get(queryIndex);
    }
}

