/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Random;

public class LongNamedCounter {
    private String name;
    private int index;
    private long count;
    private static final int MAX_RANDOM = 5;
    Random randomEngine = new Random();
    private ObjectArrayList<Object> randomSample = new ObjectArrayList();

    public String getName() {
        return this.name;
    }

    public LongNamedCounter(String name) {
        this.name = name;
    }

    public void increment() {
        ++this.count;
    }

    public void increment(Object value) {
        ++this.count;
        this.randomSample(value);
    }

    public ObjectArrayList<Object> getRandomSample() {
        return this.randomSample;
    }

    public void randomSample(Object value) {
        if (this.randomSample.size() < 5) {
            this.randomSample.add(value);
        } else {
            double threshold;
            double v = this.randomEngine.nextDouble();
            if (v < (threshold = 1.0 / Math.log(this.count))) {
                double l = v / threshold;
                int index = (int)Math.round(l * ((double)this.randomSample.size() - 1.0));
                this.randomSample.set(index, value);
            }
        }
    }

    public static long[] valuesLong(LongNamedCounter[] counters) {
        long[] result = new long[counters.length];
        int i = 0;
        for (LongNamedCounter counter : counters) {
            result[i++] = counter.getCount();
        }
        return result;
    }

    public String toString() {
        return String.format("[%s: %d]%n", this.name, this.count);
    }

    public static int[] valuesInt(LongNamedCounter[] counters) {
        int[] result = new int[counters.length];
        int i = 0;
        for (LongNamedCounter counter : counters) {
            result[i++] = (int)counter.getCount();
        }
        return result;
    }

    public long getCount() {
        return this.count;
    }
}

