package chkjis;
use strict;
#---------------------------------------------------------------------
# @ˑtB^[ECu
#   JIS X 0208:1997 O̕ʕuvɕϊ
#   Copyright(C) 2002 MORIYAMA Masayuki (XR V)
#
# Ĕzzɂ
#   ̃Cu𗘗pAvP[Vꂽꍇɂ́A
#   Cû̂YtĂč\܂B
#   ł̍ĔzzɂẮAt@CύXĔzz悤ɂ
#   B
#
# ۏ
#   ̃vOgp邱Ƃɂ萶QɂẮA҂͂
#   Ȃ闝RɂĂӔC𕉂܂Bgp̐ӔCɂ
#   gB 
#
# ӓ_
#   &chkjis::filter(\$line, 'jis'); # (ISO-2022-JP)
#     E2oCgR[h񒆂 [\x80-\xFF] ̃R[hĂ
#       ƁAȍ~̕ϊ܂B
#     EϊΏۂ̕W JIS X 0208 Ɍ肳AJIS X 0213  
#       JIS X 0212 ɊւĂ͉s܂B
#     EJIS X 0208 ւ̐ؑւGXP[vV[PX ESC $ @  
#       ESC $ B  ESC & @ ESC $ B ̌ȋʂ͍sĂ܂
#       B
# 
#   &chkjis::filter(\$line, 'euc'); # (EUC-JP)
#     E񒆂 [\xA0\xFF] ̃R[hĂƂȍ~̕
#       ϊ܂B
#     EϊΏۂ̕W JIS X 0208 Ɍ肳AJIS X 0212 Ɋ
#       s܂B
# 
#   &chkjis::filter(\$line, 'sjis'); # (Shift_JIS)
#     E񒆂 
#       [\x80\xA0\xFD-\xFF]|[\x81-\x9F\xE0-\xFC][\x00-\x3F\x7F\xFD-\xFF]
#       ̃R[hĂƁAȍ~̕ϊ܂B
# 
#   - ϊł؂̓ euc  sjis ɊւĂ $euc, $sjis ̐
#     K\ύX鎖Ŋɘa鎖͉\łBjis ̓Ɋւ
#     ́AGXP[vV[PX̏ނ̂ŁA$jis ̕ύX
#     ł͂܂ȂƎv܂B
# 
#   R[hwɂ
#     chkjis.pl ł́A͍sĂ܂̂ŁAR[h
#     w肷Kv܂B
#     R[h̎w肪Ȃꍇ͕ϊ͍s܂B
# 
#   JIS X 0208:1997 `̈̃f[^̐Mɂ
#     ꉞ`FbN͂Ă܂Aۏ؂͂܂B
#     ԈႢ܂炲AB
#---------------------------------------------------------------------
# 
#   Version 0.17
#     2002/10/23 J
#   Version 0.18
#     2002/10/23 get_version() p~ (Perl5 ` our g΃pbP[
#                ̊O $chkjis::version QƂłƔ)
#---------------------------------------------------------------------

our $version = '0.18';

my $f_strict     = 0;
my $f_useG1kana  = 0;

my $geta_jis     = "\x22\x2E";
my $geta_euc     = "\xA2\xAE";
my $geta_sjis    = "\x81\xAC";

my $re_x0208     =  q{\e\$[\@B]};
my $re_x0212     =  q{\e\$\(D};
my $re_x0213     =  q{\e\$\([OP]};
my $re_asc       =  q{\e\([BJ]};
my $re_kana      =  q{\e\(I};
my $re_k7        =  q{\x21-\x5F};
my $re_k8        =  q{\xA1-\xDF};
my $re_jis_esc   = qq{$re_asc|$re_kana|$re_x0208|$re_x0212|$re_x0213};

my $esc_asc      = "\e(J";
my $esc_kana     = "\e(I";
my $SO           = "\x0E";
my $SI           = "\x0F";

# 7rbgJIS Ƀ}b`
my $jis =
	   '[\x00-\x20\x7F]'
	. '|[\x21-\x7E][\x21-\x7E]';

# 7rbgJIS  JIS X 0208:1997 `̈(P)
my $undef_j = '[\x29-\x2F\x75-\x7E][\x21-\x7E]';

# 7rbgJIS  JIS X 0208:1997 `̈()
my $undef_j_strict =
	   '[\x29-\x2F\x75-\x7E][\x21-\x7E]'
	. '|\x22[\x2F-\x39\x42-\x49\x51-\x5B\x6B-\x71\x7A-\x7D]'
	. '|\x23[\x21-\x2F\x3A-\x40\x5B-\x60\x7B-\x7E]'
	. '|\x24[\x74-\x7E]'
	. '|\x25[\x77-\x7E]'
	. '|\x26[\x39-\x40\x59-\x7E]'
	. '|\x27[\x42-\x50\x72-\x7E]'
	. '|\x28[\x41-\x7E]'
	. '|\x4F[\x54-\x7E]'
	. '|\x74[\x27-\x7E]';

# EUC-JP Ƀ}b`
my $euc =
	   '[\x00-\x7F]'
	. '|[\x8E\xA1-\xFE][\xA1-\xFE]'
	. '|\x8F[\xA1-\xFE][\xA1-\xFE]';

# EUC-JP  JIS X 0208:1997 `̈(P)
my $undef_e ='[\xA9-\xAF\xF5-\xFE][\xA1-\xFE]';

# EUC-JP  JIS X 0208:1997 `̈()
my $undef_e_strict = 
	   '[\xA9-\xAF\xF5-\xFE][\xA1-\xFE]'
	. '|\xA2[\xAF-\xB9\xC2-\xC9\xD1-\xDB\xEB-\xF1\xFA-\xFD]'
	. '|\xA3[\xA1-\xAF\xBA-\xC0\xDB-\xE0\xFB-\xFE]'
	. '|\xA4[\xF4-\xFE]'
	. '|\xA5[\xF7-\xFE]'
	. '|\xA6[\xB9-\xC0\xD9-\xFE]'
	. '|\xA7[\xC2-\xD0\xF2-\xFE]'
	. '|\xA8[\xC1-\xFE]'
	. '|\xCF[\xD4-\xFE]'
	. '|\xF4[\xA7-\xFE]';

# VtgJIS Ƀ}b`
my $sjis =
	   '[\x00-\x7F\xA1-\xDF]'
	. '|[\x81-\x9F\xE0-\xFC][\x40-\x7E\x80-\xFC]';

# VtgJIS  JIS X 0208:1997 `̈(P)
my $undef_s =
	   '[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]'
	. '|\x88[\x40-\x7E\x80-\x9E]';

# VtgJIS  JIS X 0208:1997 `̈()
my $undef_s_strict =
	   '[\x85-\x87\xEB-\xFC][\x40-\x7E\x80-\xFC]'
	. '|\x81[\xAD-\xB7\xC0-\xC7\xCF-\xD9\xE9-\xEF\xF8-\xFB]'
	. '|\x82[\x40-\x4E\x59-\x5F\x7A-\x7E\x80\x9B-\x9E\xF2-\xFC]'
	. '|\x83[\x97-\x9E\xB7-\xBE\xD7-\xFC]'
	. '|\x84[\x61-\x6F\x92-\x9E\xBF-\xFC]'
	. '|\x88[\x40-\x7E\x80-\x9E]'
	. '|\x98[\x73-\x7E\x80-\x9E]'
	. '|\xEA[\xA5-\xFC]';

sub filter {
	my ($s, $code) = @_;
	my  $m;

	if    ($code eq 'sjis') { $m = &filter_sjis($s); }
	elsif ($code eq 'euc')  { $m = &filter_euc($s);  }
	elsif ($code eq 'jis')  { $m = &filter_jis($s);  }
	$m;
}

sub filter_jis {
	my ($s) = @_;
	my ($k, $m) = (0, 0);

	if ($f_useG1kana) {
		if (index($$s, $SO) > -1) {
			$k = $$s =~ s/$SO([$re_k7]*)$SI/$esc_kana$1$esc_asc/go;
			$$s =~ s/$re_kana$re_asc//go if $k;
		}
		$k += $$s =~ s/([$re_k8]+)/$esc_kana.chr(ord($1)-0x80).$esc_asc/geo;
		$$s =~ s/$re_asc($re_x0208)/$1/go if $k;
	}
	$$s =~ s/($re_x0208)([^\e]*)/&_filter_jis($1, $2, \$m)/geo;
	$m;
}

sub _filter_jis {
	my ($esc, $t, $rm) = @_;

	if ($f_strict) {
		$$rm += $t =~ s/\G((?:$jis)*?)(?:$undef_j_strict)/$1$geta_jis/go;
	} else {
		$$rm += $t =~ s/\G((?:$jis)*?)(?:$undef_j)/$1$geta_jis/go;
	}
	$esc . $t;
}

sub _del_esc {
	my ($t) = @_;

	$t =~ s/$re_jis_esc//go;
	$t;
}

sub filter_euc {
	my ($s) = @_;
	my  $m;

	if ($f_strict) {
		$m = $$s =~ s/\G((?:$euc)*?)(?:$undef_e_strict)/$1$geta_euc/go;
	} else {
		$m = $$s =~ s/\G((?:$euc)*?)(?:$undef_e)/$1$geta_euc/go;
	}
	$m;
}

sub filter_sjis {
	my ($s) = @_;
	my  $m;

	if ($f_strict) {
		$m = $$s =~ s/\G((?:$sjis)*?)(?:$undef_s_strict)/$1$geta_sjis/go;
	} else {
		$m = $$s =~ s/\G((?:$sjis)*?)(?:$undef_s)/$1$geta_sjis/go;
	}
	$m;
}

# IvVݒ

sub ascii_esc {
	$esc_asc = shift || $esc_asc;
	$esc_asc = "\e\($esc_asc" if length($esc_asc) == 1;
}

sub strict      { $f_strict = 1;    }
sub nostrict    { $f_strict = 0;    }
sub useG1kana   { $f_useG1kana = 1; }
sub nouseG1kana { $f_useG1kana = 0; }
1;
