//Copyright (C) 2000 - 2003 Thomas Schank 
// 
//This program is free software; you can redistribute it and/or
//modify it under the terms of the GNU General Public License
//as published by the Free Software Foundation; either version 2
//of the License, or (at your option) any later version.
//
//This program is distributed in the hope that it will be useful,
//but WITHOUT ANY WARRANTY; without even the implied warranty of
//MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//GNU General Public License for more details.
//
//You should have received a copy of the GNU General Public License
//along with this program; if not, write to the Free Software
//Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA. 

#ifndef _DATATYPES_H
#define _DATATYPES_H

#include "libgpspoint_config.h"


#if HAVE_INTTYPES_H             // this should be ANSI C conformal
   #include <inttypes.h>
	namespace gpspoint2 
	{
   typedef uint8_t g_boolean;
   typedef int8_t g_char;
   typedef uint8_t g_byte;
   typedef int16_t g_int;       
   typedef uint16_t g_word;
   typedef int32_t g_long;
   typedef uint32_t g_longword;
   typedef float g_float;
   typedef double g_double; 
	}
#else

#if HAVE_ASM_TYPES_H          // nex trial, usually on any linux system
   #include <asm/types.h>
	namespace gpspoint2 
	{
   typedef __u8 g_boolean;
   typedef __s8 g_char;
   typedef __u8 g_byte;
   typedef __s16 g_int;       
   typedef __u16 g_word;
   typedef __s32 g_long;
   typedef __u32 g_longword;
   typedef __u32 g_longword;
   typedef float g_float;
   typedef double g_double; 
	}

#else                         // last resort just try standart types , good luck
	namespace gpspoint2 
	{

   // boolean, no not one bit, unsigned 8 bit
   typedef unsigned char g_boolean;
   
   // char, signed 8 bit -- OK
   typedef char g_char;
   
   // byte, unsigned 8 bit 
   typedef unsigned char   g_byte;
   
   // int, singed 16 bit  
   typedef short g_int;       // bummer 
   
   // word, unsigned 16 bit 
   typedef unsigned short g_word;
   
   // long, signed 32 bit -- OK
   typedef long g_long;
   
   // logword, unsigned 32 bit
   typedef unsigned long   g_longword;
   
   // float 32 bit IEEE
   typedef float g_float;
   
   // double 64 bit IEEE
   typedef double g_double;
	}

#endif

#endif 

#endif 
