/*
 * Decompiled with CFR 0.152.
 */
package org.itadaki.bzip2;

import java.io.IOException;
import java.util.Arrays;
import org.itadaki.bzip2.BitOutputStream;
import org.itadaki.bzip2.HuffmanAllocator;
import org.itadaki.bzip2.MoveToFront;

class BZip2HuffmanStageEncoder {
    private static final int HUFFMAN_HIGH_SYMBOL_COST = 15;
    private final BitOutputStream bitOutputStream;
    private final int[] bwtBlock;
    private int bwtLength;
    private final boolean[] bwtValuesInUse;
    private final char[] mtfBlock;
    private int mtfLength;
    private int huffmanAlphabetSize;
    private final int[] mtfSymbolFrequencies = new int[258];
    private final int[][] huffmanCodeLengths = new int[6][258];
    private final int[][] huffmanMergedCodeSymbols = new int[6][258];
    private final byte[] selectors = new byte[18002];

    private static int selectTableCount(int mtfLength) {
        if (mtfLength >= 2400) {
            return 6;
        }
        if (mtfLength >= 1200) {
            return 5;
        }
        if (mtfLength >= 600) {
            return 4;
        }
        if (mtfLength >= 200) {
            return 3;
        }
        return 2;
    }

    private void moveToFrontAndRunLengthEncode() {
        int bwtLength = this.bwtLength;
        boolean[] bwtValuesInUse = this.bwtValuesInUse;
        int[] bwtBlock = this.bwtBlock;
        char[] mtfBlock = this.mtfBlock;
        int[] mtfSymbolFrequencies = this.mtfSymbolFrequencies;
        byte[] huffmanSymbolMap = new byte[256];
        MoveToFront symbolMTF = new MoveToFront();
        int totalUniqueValues = 0;
        int i = 0;
        while (i < 256) {
            if (bwtValuesInUse[i]) {
                huffmanSymbolMap[i] = (byte)totalUniqueValues++;
            }
            ++i;
        }
        int endOfBlockSymbol = totalUniqueValues + 1;
        int mtfIndex = 0;
        int repeatCount = 0;
        int totalRunAs = 0;
        int totalRunBs = 0;
        int i2 = 0;
        while (i2 < bwtLength) {
            int mtfPosition = symbolMTF.valueToFront(huffmanSymbolMap[bwtBlock[i2] & 0xFF]);
            if (mtfPosition == 0) {
                ++repeatCount;
            } else {
                if (repeatCount > 0) {
                    --repeatCount;
                    while (true) {
                        if ((repeatCount & 1) == 0) {
                            mtfBlock[mtfIndex++] = '\u0000';
                            ++totalRunAs;
                        } else {
                            mtfBlock[mtfIndex++] = '\u0001';
                            ++totalRunBs;
                        }
                        if (repeatCount < 2) break;
                        repeatCount = repeatCount - 2 >> 1;
                    }
                    repeatCount = 0;
                }
                mtfBlock[mtfIndex++] = (char)(mtfPosition + 1);
                int n = mtfPosition + 1;
                mtfSymbolFrequencies[n] = mtfSymbolFrequencies[n] + 1;
            }
            ++i2;
        }
        if (repeatCount > 0) {
            --repeatCount;
            while (true) {
                if ((repeatCount & 1) == 0) {
                    mtfBlock[mtfIndex++] = '\u0000';
                    ++totalRunAs;
                } else {
                    mtfBlock[mtfIndex++] = '\u0001';
                    ++totalRunBs;
                }
                if (repeatCount < 2) break;
                repeatCount = repeatCount - 2 >> 1;
            }
        }
        mtfBlock[mtfIndex] = (char)endOfBlockSymbol;
        int n = endOfBlockSymbol;
        mtfSymbolFrequencies[n] = mtfSymbolFrequencies[n] + 1;
        mtfSymbolFrequencies[0] = mtfSymbolFrequencies[0] + totalRunAs;
        mtfSymbolFrequencies[1] = mtfSymbolFrequencies[1] + totalRunBs;
        this.mtfLength = mtfIndex + 1;
        this.huffmanAlphabetSize = totalUniqueValues + 2;
    }

    private void generateInitialHuffmanCodeLengths(int totalTables) {
        int[][] huffmanCodeLengths = this.huffmanCodeLengths;
        int[] mtfSymbolFrequencies = this.mtfSymbolFrequencies;
        int huffmanAlphabetSize = this.huffmanAlphabetSize;
        int remainingLength = this.mtfLength;
        int lowCostEnd = -1;
        int i = 0;
        while (i < totalTables) {
            int targetCumulativeFrequency = remainingLength / (totalTables - i);
            int lowCostStart = lowCostEnd + 1;
            int actualCumulativeFrequency = 0;
            while (actualCumulativeFrequency < targetCumulativeFrequency && lowCostEnd < huffmanAlphabetSize - 1) {
                actualCumulativeFrequency += mtfSymbolFrequencies[++lowCostEnd];
            }
            if (lowCostEnd > lowCostStart && i != 0 && i != totalTables - 1 && (totalTables - i & 1) == 0) {
                actualCumulativeFrequency -= mtfSymbolFrequencies[lowCostEnd--];
            }
            int[] tableCodeLengths = huffmanCodeLengths[i];
            int j = 0;
            while (j < huffmanAlphabetSize) {
                if (j < lowCostStart || j > lowCostEnd) {
                    tableCodeLengths[j] = 15;
                }
                ++j;
            }
            remainingLength -= actualCumulativeFrequency;
            ++i;
        }
    }

    private int optimiseSelectorsAndHuffmanTables(int totalTables) {
        int MAXIMUM_ITERATIONS = 4;
        char[] mtf = this.mtfBlock;
        byte[] selectors = this.selectors;
        int[][] huffmanCodeLengths = this.huffmanCodeLengths;
        int mtfLength = this.mtfLength;
        int huffmanAlphabetSize = this.huffmanAlphabetSize;
        int[] sortedFrequencyMap = new int[huffmanAlphabetSize];
        int[] sortedFrequencies = new int[huffmanAlphabetSize];
        int selectorIndex = 0;
        int iteration = 3;
        while (iteration >= 0) {
            int[][] tableFrequencies = new int[6][huffmanAlphabetSize];
            selectorIndex = 0;
            int groupStart = 0;
            while (groupStart < mtfLength) {
                int groupEnd = Math.min(groupStart + 50 - 1, mtfLength - 1);
                short[] cost = new short[6];
                int i = groupStart;
                while (i <= groupEnd) {
                    char value = mtf[i];
                    int j = 0;
                    while (j < totalTables) {
                        int n = j;
                        cost[n] = (short)(cost[n] + huffmanCodeLengths[j][value]);
                        ++j;
                    }
                    ++i;
                }
                int bestTable = 0;
                short bestCost = cost[0];
                int i2 = 1;
                while (i2 < totalTables) {
                    short tableCost = cost[i2];
                    if (tableCost < bestCost) {
                        bestCost = tableCost;
                        bestTable = i2;
                    }
                    ++i2;
                }
                int[] bestGroupFrequencies = tableFrequencies[bestTable];
                int i3 = groupStart;
                while (i3 <= groupEnd) {
                    char c = mtf[i3];
                    bestGroupFrequencies[c] = bestGroupFrequencies[c] + 1;
                    ++i3;
                }
                if (iteration == 0) {
                    selectors[selectorIndex++] = (byte)bestTable;
                }
                groupStart = groupEnd + 1;
            }
            int i = 0;
            while (i < totalTables) {
                int j = 0;
                while (j < huffmanAlphabetSize) {
                    sortedFrequencyMap[j] = tableFrequencies[i][j] << 9 | j;
                    ++j;
                }
                Arrays.sort(sortedFrequencyMap);
                j = 0;
                while (j < huffmanAlphabetSize) {
                    sortedFrequencies[j] = sortedFrequencyMap[j] >> 9;
                    ++j;
                }
                HuffmanAllocator.allocateHuffmanCodeLengths(sortedFrequencies, 20);
                j = 0;
                while (j < huffmanAlphabetSize) {
                    huffmanCodeLengths[i][sortedFrequencyMap[j] & 0x1FF] = sortedFrequencies[j];
                    ++j;
                }
                ++i;
            }
            --iteration;
        }
        return selectorIndex;
    }

    private void assignHuffmanCodeSymbols(int totalTables) {
        int[][] huffmanMergedCodeSymbols = this.huffmanMergedCodeSymbols;
        int[][] huffmanCodeLengths = this.huffmanCodeLengths;
        int huffmanAlphabetSize = this.huffmanAlphabetSize;
        int i = 0;
        while (i < totalTables) {
            int[] tableLengths = huffmanCodeLengths[i];
            int minimumLength = 32;
            int maximumLength = 0;
            int j = 0;
            while (j < huffmanAlphabetSize) {
                int length = tableLengths[j];
                if (length > maximumLength) {
                    maximumLength = length;
                }
                if (length < minimumLength) {
                    minimumLength = length;
                }
                ++j;
            }
            int code = 0;
            int j2 = minimumLength;
            while (j2 <= maximumLength) {
                int k = 0;
                while (k < huffmanAlphabetSize) {
                    if ((huffmanCodeLengths[i][k] & 0xFF) == j2) {
                        huffmanMergedCodeSymbols[i][k] = j2 << 24 | code;
                        ++code;
                    }
                    ++k;
                }
                code <<= 1;
                ++j2;
            }
            ++i;
        }
    }

    private void writeSymbolMap() throws IOException {
        int k;
        int j;
        BitOutputStream bitOutputStream = this.bitOutputStream;
        boolean[] bwtValuesInUse = this.bwtValuesInUse;
        boolean[] condensedInUse = new boolean[16];
        int i = 0;
        while (i < 16) {
            j = 0;
            k = i << 4;
            while (j < 16) {
                if (bwtValuesInUse[k]) {
                    condensedInUse[i] = true;
                }
                ++j;
                ++k;
            }
            ++i;
        }
        i = 0;
        while (i < 16) {
            bitOutputStream.writeBoolean(condensedInUse[i]);
            ++i;
        }
        i = 0;
        while (i < 16) {
            if (condensedInUse[i]) {
                j = 0;
                k = i * 16;
                while (j < 16) {
                    bitOutputStream.writeBoolean(bwtValuesInUse[k]);
                    ++j;
                    ++k;
                }
            }
            ++i;
        }
    }

    private void writeSelectors(int totaTables, int totalSelectors) throws IOException {
        BitOutputStream bitOutputStream = this.bitOutputStream;
        byte[] selectors = this.selectors;
        bitOutputStream.writeBits(3, totaTables);
        bitOutputStream.writeBits(15, totalSelectors);
        MoveToFront selectorMTF = new MoveToFront();
        int i = 0;
        while (i < totalSelectors) {
            bitOutputStream.writeUnary(selectorMTF.valueToFront(selectors[i]));
            ++i;
        }
    }

    private void writeHuffmanCodeLengths(int totalTables) throws IOException {
        BitOutputStream bitOutputStream = this.bitOutputStream;
        int[][] huffmanCodeLengths = this.huffmanCodeLengths;
        int huffmanAlphabetSize = this.huffmanAlphabetSize;
        int i = 0;
        while (i < totalTables) {
            int[] tableLengths = huffmanCodeLengths[i];
            int currentLength = tableLengths[0];
            bitOutputStream.writeBits(5, currentLength);
            int j = 0;
            while (j < huffmanAlphabetSize) {
                int codeLength = tableLengths[j];
                int value = currentLength < codeLength ? 2 : 3;
                int delta = Math.abs(codeLength - currentLength);
                while (delta-- > 0) {
                    bitOutputStream.writeBits(2, value);
                }
                bitOutputStream.writeBoolean(false);
                currentLength = codeLength;
                ++j;
            }
            ++i;
        }
    }

    private void writeBlockData() throws IOException {
        BitOutputStream bitOutputStream = this.bitOutputStream;
        int[][] huffmanMergedCodeSymbols = this.huffmanMergedCodeSymbols;
        byte[] selectors = this.selectors;
        char[] mtf = this.mtfBlock;
        int mtfLength = this.mtfLength;
        int selectorIndex = 0;
        int mtfIndex = 0;
        while (mtfIndex < mtfLength) {
            int groupEnd = Math.min(mtfIndex + 50 - 1, mtfLength - 1);
            int[] tableMergedCodeSymbols = huffmanMergedCodeSymbols[selectors[selectorIndex++]];
            while (mtfIndex <= groupEnd) {
                int mergedCodeSymbol = tableMergedCodeSymbols[mtf[mtfIndex++]];
                bitOutputStream.writeBits(mergedCodeSymbol >> 24, mergedCodeSymbol);
            }
        }
    }

    public void encode() throws IOException {
        this.moveToFrontAndRunLengthEncode();
        int totalTables = BZip2HuffmanStageEncoder.selectTableCount(this.mtfLength);
        this.generateInitialHuffmanCodeLengths(totalTables);
        int totalSelectors = this.optimiseSelectorsAndHuffmanTables(totalTables);
        this.assignHuffmanCodeSymbols(totalTables);
        this.writeSymbolMap();
        this.writeSelectors(totalTables, totalSelectors);
        this.writeHuffmanCodeLengths(totalTables);
        this.writeBlockData();
    }

    public BZip2HuffmanStageEncoder(BitOutputStream bitOutputStream, boolean[] bwtValuesInUse, int[] bwtBlock, int bwtLength) {
        this.bitOutputStream = bitOutputStream;
        this.mtfBlock = new char[2 * bwtBlock.length];
        this.bwtValuesInUse = bwtValuesInUse;
        this.bwtBlock = bwtBlock;
        this.bwtLength = bwtLength;
    }
}

