require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_QDUSER_H_)) {
    eval 'sub _QDUSER_H_ () {1;}' unless defined(&_QDUSER_H_);
    if(defined(&KERNEL)) {
	require '../include/qevent.ph';
    } else {
	require 'vax/qevent.ph';
    }
    eval 'sub DMADONE () {0x8000;}' unless defined(&DMADONE);
    eval 'sub SET_DONE_FIFO () {0x4000;}' unless defined(&SET_DONE_FIFO);
    eval 'sub PTOB_ENB () {0x600;}' unless defined(&PTOB_ENB);
    eval 'sub BTOP_ENB () {0x400;}' unless defined(&BTOP_ENB);
    eval 'sub DL_ENB () {0x200;}' unless defined(&DL_ENB);
    eval 'sub HALT () {0x;}' unless defined(&HALT);
    eval 'sub BYTE_DMA () {0x100;}' unless defined(&BYTE_DMA);
    eval 'sub DMA_ERR () {0x80;}' unless defined(&DMA_ERR);
    eval 'sub PARITY_ERR () {0x40;}' unless defined(&PARITY_ERR);
    eval 'sub BUS_ERR () {0x20;}' unless defined(&BUS_ERR);
    eval 'sub GLOBAL_IE () {0x4;}' unless defined(&GLOBAL_IE);
    eval 'sub DMA_IE () {0x2;}' unless defined(&DMA_IE);
    eval 'sub CURS_ENB () {0x1;}' unless defined(&CURS_ENB);
    eval 'sub UNBLANK () {0x20;}' unless defined(&UNBLANK);
    eval 'sub SYNC_ON () {0x8;}' unless defined(&SYNC_ON);
    eval 'sub CURS_MIN_X () {232;}' unless defined(&CURS_MIN_X);
    eval 'sub CURS_MIN_Y () {16;}' unless defined(&CURS_MIN_Y);
    eval 'sub TRANX {
        my($x) = @_;
	    eval q(( -((+ &CURS_MIN_X) & ~0x3) | ((($x)+ &CURS_MIN_X) & 0x3) ));
    }' unless defined(&TRANX);
    eval 'sub TRANY {
        my($y) = @_;
	    eval q(( -(($y)+ &CURS_MIN_Y) ));
    }' unless defined(&TRANY);
    eval 'sub VSE_LEFT_BUTTON () {0;}' unless defined(&VSE_LEFT_BUTTON);
    eval 'sub VSE_MIDDLE_BUTTON () {1;}' unless defined(&VSE_MIDDLE_BUTTON);
    eval 'sub VSE_RIGHT_BUTTON () {2;}' unless defined(&VSE_RIGHT_BUTTON);
    eval 'sub VSE_T_LEFT_BUTTON () {0;}' unless defined(&VSE_T_LEFT_BUTTON);
    eval 'sub VSE_T_FRONT_BUTTON () {1;}' unless defined(&VSE_T_FRONT_BUTTON);
    eval 'sub VSE_T_RIGHT_BUTTON () {2;}' unless defined(&VSE_T_RIGHT_BUTTON);
    eval 'sub VSE_T_BACK_BUTTON () {4;}' unless defined(&VSE_T_BACK_BUTTON);
    eval 'sub VSE_T_BARREL_BUTTON () { &VSE_T_LEFT_BUTTON;}' unless defined(&VSE_T_BARREL_BUTTON);
    eval 'sub VSE_T_TIP_BUTTON () { &VSE_T_FRONT_BUTTON;}' unless defined(&VSE_T_TIP_BUTTON);
    eval 'sub ISEMPTY {
        my($eq) = @_;
	    eval q((($eq)-> ($header->{head}) == ($eq)-> ($header->{tail})));
    }' unless defined(&ISEMPTY);
    eval 'sub GETBEGIN {
        my($eq) = @_;
	    eval q((($eq)-> ($header->{events[&(eq)}->{header}->{head]})));
    }' unless defined(&GETBEGIN);
    eval 'sub GET_X {
        my($event) = @_;
	    eval q((($event)-> &vse_x));
    }' unless defined(&GET_X);
    eval 'sub GET_Y {
        my($event) = @_;
	    eval q((($event)-> &vse_y));
    }' unless defined(&GET_Y);
    eval 'sub GET_TIME {
        my($event) = @_;
	    eval q((($event)-> &vse_time));
    }' unless defined(&GET_TIME);
    eval 'sub GET_TYPE {
        my($event) = @_;
	    eval q((($event)-> &vse_type));
    }' unless defined(&GET_TYPE);
    eval 'sub GET_KEY {
        my($event) = @_;
	    eval q((($event)-> &vse_key));
    }' unless defined(&GET_KEY);
    eval 'sub GET_DIR {
        my($event) = @_;
	    eval q((($event)-> &vse_direction));
    }' unless defined(&GET_DIR);
    eval 'sub GET_DEVICE {
        my($event) = @_;
	    eval q((($event)-> &vse_device));
    }' unless defined(&GET_DEVICE);
    eval 'sub GETEND {
        my($eq) = @_;
	    eval q((++($eq)-> ($header->{head}) >= ($eq)-> ($header->{size}) ? ($eq)-> ($header->{head}) = 0: 0));
    }' unless defined(&GETEND);
    eval 'sub ISFULL {
        my($eq) = @_;
	    eval q((($eq)-> ($header->{tail})+1== ($eq)-> ($header->{head}) || (($eq)-> ($header->{tail})+1== ($eq)-> ($header->{size})  && ($eq)-> ($header->{head}) == 0)));
    }' unless defined(&ISFULL);
    eval 'sub PUTBEGIN {
        my($eq) = @_;
	    eval q((($eq)-> ($header->{events[&(eq)}->{header}->{tail]})));
    }' unless defined(&PUTBEGIN);
    eval 'sub PUT_X {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_x = $value));
    }' unless defined(&PUT_X);
    eval 'sub PUT_Y {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_y = $value));
    }' unless defined(&PUT_Y);
    eval 'sub PUT_TIME {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_time = $value));
    }' unless defined(&PUT_TIME);
    eval 'sub PUT_TYPE {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_type = $value));
    }' unless defined(&PUT_TYPE);
    eval 'sub PUT_KEY {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_key = $value));
    }' unless defined(&PUT_KEY);
    eval 'sub PUT_DIR {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_direction = $value));
    }' unless defined(&PUT_DIR);
    eval 'sub PUT_DEVICE {
        my($event, $value) = @_;
	    eval q((($event)-> &vse_device = $value));
    }' unless defined(&PUT_DEVICE);
    eval 'sub PUTEND {
        my($eq) = @_;
	    eval q((++($eq)-> ($header->{tail}) >= ($eq)-> ($header->{size}) ? ($eq)-> ($header->{tail}) = 0: 0));
    }' unless defined(&PUTEND);
    eval 'sub DISPLIST () {1;}' unless defined(&DISPLIST);
    eval 'sub PTOB () {2;}' unless defined(&PTOB);
    eval 'sub BTOP () {3;}' unless defined(&BTOP);
    eval 'sub FIFO_EMPTY () {0x1;}' unless defined(&FIFO_EMPTY);
    eval 'sub COUNT_ZERO () {0x2;}' unless defined(&COUNT_ZERO);
    eval 'sub WORD_PACK () {0x4;}' unless defined(&WORD_PACK);
    eval 'sub BYTE_PACK () {0x8;}' unless defined(&BYTE_PACK);
    eval 'sub REQUEST_DONE () {0x100;}' unless defined(&REQUEST_DONE);
    eval 'sub HARD_ERROR () {0x200;}' unless defined(&HARD_ERROR);
    eval 'sub DMA_ACTIVE () {0x4;}' unless defined(&DMA_ACTIVE);
    eval 'sub DMA_ERROR () {0x80;}' unless defined(&DMA_ERROR);
    eval 'sub DMA_IGNORE () {0x2;}' unless defined(&DMA_IGNORE);
    eval 'sub DMA_SETACTIVE {
        my($header) = @_;
	    eval q((($header)-> &status |=  &DMA_ACTIVE));
    }' unless defined(&DMA_SETACTIVE);
    eval 'sub DMA_CLRACTIVE {
        my($header) = @_;
	    eval q((($header)-> &status &= ~ &DMA_ACTIVE));
    }' unless defined(&DMA_CLRACTIVE);
    eval 'sub DMA_ISACTIVE {
        my($header) = @_;
	    eval q((($header)-> &status &  &DMA_ACTIVE));
    }' unless defined(&DMA_ISACTIVE);
    eval 'sub DMA_SETERROR {
        my($header) = @_;
	    eval q((($header)-> &status |=  &DMA_ERROR));
    }' unless defined(&DMA_SETERROR);
    eval 'sub DMA_CLRERROR {
        my($header) = @_;
	    eval q((($header)-> &status &= ~ &DMA_ERROR));
    }' unless defined(&DMA_CLRERROR);
    eval 'sub DMA_ISERROR {
        my($header) = @_;
	    eval q((($header)-> &status &  &DMA_ERROR));
    }' unless defined(&DMA_ISERROR);
    eval 'sub DMA_SETIGNORE {
        my($header) = @_;
	    eval q((($header)-> &status |=  &DMA_IGNORE));
    }' unless defined(&DMA_SETIGNORE);
    eval 'sub DMA_CLRIGNORE {
        my($header) = @_;
	    eval q((($header)-> &status &= ~ &DMA_IGNORE));
    }' unless defined(&DMA_CLRIGNORE);
    eval 'sub DMA_ISIGNORE {
        my($header) = @_;
	    eval q((($header)-> &status &  &DMA_IGNORE));
    }' unless defined(&DMA_ISIGNORE);
    eval 'sub DMA_ISEMPTY {
        my($header) = @_;
	    eval q((($header)-> &used == 0));
    }' unless defined(&DMA_ISEMPTY);
    eval 'sub DMA_ISFULL {
        my($header) = @_;
	    eval q((($header)-> &used >= ($header)-> &size));
    }' unless defined(&DMA_ISFULL);
    eval 'sub DMA_PUTBEGIN {
        my($header) = @_;
	    eval q((($header)-> $DMAreq[($header)-> &newest]));
    }' unless defined(&DMA_PUTBEGIN);
    eval 'sub DMA_GETBEGIN {
        my($header) = @_;
	    eval q((($header)-> $DMAreq[($header)-> &oldest]));
    }' unless defined(&DMA_GETBEGIN);
    eval 'sub DMA_GETEND {
        my($header) = @_;
	    eval q((++($header)-> &oldest >= ($header)-> &size ? ($header)-> &oldest = 0: 0); --($header)-> &used;);
    }' unless defined(&DMA_GETEND);
    eval 'sub DMA_PUTEND {
        my($header) = @_;
	    eval q((++($header)-> &newest >= ($header)-> &size ? ($header)-> &newest = 0: 0); ++($header)-> &used;);
    }' unless defined(&DMA_PUTEND);
    eval 'sub LOAD_COLOR_MAP () {0x1;}' unless defined(&LOAD_COLOR_MAP);
    eval 'sub LOAD_REGS () {0x1;}' unless defined(&LOAD_REGS);
    eval 'sub LOAD_INDEX () {0x2;}' unless defined(&LOAD_INDEX);
    eval 'sub LK_UPDOWN () {0x86;}' unless defined(&LK_UPDOWN);
    eval 'sub LK_AUTODOWN () {0x82;}' unless defined(&LK_AUTODOWN);
    eval 'sub LK_DOWN () {0x80;}' unless defined(&LK_DOWN);
    eval 'sub LK_DEFAULTS () {0xd3;}' unless defined(&LK_DEFAULTS);
    eval 'sub LK_AR_ENABLE () {0xe3;}' unless defined(&LK_AR_ENABLE);
    eval 'sub LK_CL_ENABLE () {0x1b;}' unless defined(&LK_CL_ENABLE);
    eval 'sub LK_KBD_ENABLE () {0x8b;}' unless defined(&LK_KBD_ENABLE);
    eval 'sub LK_BELL_ENABLE () {0x23;}' unless defined(&LK_BELL_ENABLE);
    eval 'sub LK_RING_BELL () {0xa7;}' unless defined(&LK_RING_BELL);
    eval 'sub LK_LED_ENABLE () {0x13;}' unless defined(&LK_LED_ENABLE);
    eval 'sub LK_LED_DISABLE () {0x11;}' unless defined(&LK_LED_DISABLE);
    eval 'sub LED_1 () {0x81;}' unless defined(&LED_1);
    eval 'sub LED_2 () {0x82;}' unless defined(&LED_2);
    eval 'sub LED_3 () {0x84;}' unless defined(&LED_3);
    eval 'sub LED_4 () {0x88;}' unless defined(&LED_4);
    eval 'sub LED_ALL () {0x8f;}' unless defined(&LED_ALL);
    eval 'sub LK_LED_HOLD () { &LED_4;}' unless defined(&LK_LED_HOLD);
    eval 'sub LK_LED_LOCK () { &LED_3;}' unless defined(&LK_LED_LOCK);
    eval 'sub LK_LED_COMPOSE () { &LED_2;}' unless defined(&LK_LED_COMPOSE);
    eval 'sub LK_LED_WAIT () { &LED_1;}' unless defined(&LK_LED_WAIT);
    eval 'sub LK_KDOWN_ERROR () {0x3d;}' unless defined(&LK_KDOWN_ERROR);
    eval 'sub LK_POWER_ERROR () {0x3e;}' unless defined(&LK_POWER_ERROR);
    eval 'sub LK_OUTPUT_ERROR () {0xb5;}' unless defined(&LK_OUTPUT_ERROR);
    eval 'sub LK_INPUT_ERROR () {0xb6;}' unless defined(&LK_INPUT_ERROR);
    eval 'sub LK_LOWEST () {0x56;}' unless defined(&LK_LOWEST);
    eval 'sub LK_DIV6_START () {0xad;}' unless defined(&LK_DIV6_START);
    eval 'sub LK_DIV5_END () {0xb2;}' unless defined(&LK_DIV5_END);
    eval 'sub LAST_PARAM () {0x80;}' unless defined(&LAST_PARAM);
    eval 'sub SHIFT () {174;}' unless defined(&SHIFT);
    eval 'sub LOCK () {176;}' unless defined(&LOCK);
    eval 'sub REPEAT () {180;}' unless defined(&REPEAT);
    eval 'sub CNTRL () {175;}' unless defined(&CNTRL);
    eval 'sub ALLUP () {179;}' unless defined(&ALLUP);
    eval 'sub INC_STREAM_MODE () {ord(\'R\');}' unless defined(&INC_STREAM_MODE);
    eval 'sub PROMPT_MODE () {ord(\'D\');}' unless defined(&PROMPT_MODE);
    eval 'sub REQUEST_POS () {ord(\'P\');}' unless defined(&REQUEST_POS);
    eval 'sub SELF_TEST () {ord(\'T\');}' unless defined(&SELF_TEST);
    eval 'sub MOUSE_ID () {0x2;}' unless defined(&MOUSE_ID);
    eval 'sub START_FRAME () {0x80;}' unless defined(&START_FRAME);
    eval 'sub X_SIGN () {0x10;}' unless defined(&X_SIGN);
    eval 'sub Y_SIGN () {0x8;}' unless defined(&Y_SIGN);
    eval 'sub RIGHT_BUTTON () {0x1;}' unless defined(&RIGHT_BUTTON);
    eval 'sub MIDDLE_BUTTON () {0x2;}' unless defined(&MIDDLE_BUTTON);
    eval 'sub LEFT_BUTTON () {0x4;}' unless defined(&LEFT_BUTTON);
    eval 'sub T_STREAM () {ord(\'R\');}' unless defined(&T_STREAM);
    eval 'sub T_POINT () {ord(\'D\');}' unless defined(&T_POINT);
    eval 'sub T_REQUEST () {ord(\'P\');}' unless defined(&T_REQUEST);
    eval 'sub T_BAUD () {ord(\'B\');}' unless defined(&T_BAUD);
    eval 'sub T_RATE_55 () {ord(\'K\');}' unless defined(&T_RATE_55);
    eval 'sub T_RATE_72 () {ord(\'L\');}' unless defined(&T_RATE_72);
    eval 'sub T_RATE_120 () {ord(\'M\');}' unless defined(&T_RATE_120);
    eval 'sub T_TEST () { &SELF_TEST;}' unless defined(&T_TEST);
    eval 'sub TABLET_ID () {0x4;}' unless defined(&TABLET_ID);
    eval 'sub T_START_FRAME () {0x80;}' unless defined(&T_START_FRAME);
    eval 'sub T_PROXIMITY () {0x1;}' unless defined(&T_PROXIMITY);
    eval 'sub T_LEFT_BUTTON () {0x2;}' unless defined(&T_LEFT_BUTTON);
    eval 'sub T_FRONT_BUTTON () {0x4;}' unless defined(&T_FRONT_BUTTON);
    eval 'sub T_RIGHT_BUTTON () {0x8;}' unless defined(&T_RIGHT_BUTTON);
    eval 'sub T_BACK_BUTTON () {0x10;}' unless defined(&T_BACK_BUTTON);
    eval 'sub T_BARREL_BUTTON () { &T_LEFT_BUTTON;}' unless defined(&T_BARREL_BUTTON);
    eval 'sub T_TIP_BUTTON () { &T_FRONT_BUTTON;}' unless defined(&T_TIP_BUTTON);
}
1;
