/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.build;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.build.CramIO;
import htsjdk.samtools.cram.io.CountingInputStream;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.CramHeader;
import java.io.Closeable;
import java.io.InputStream;
import java.util.Iterator;

public class CramContainerIterator
implements Iterator<Container>,
Closeable {
    private CramHeader cramHeader;
    private final SAMFileHeader samFileHeader;
    private final CountingInputStream countingInputStream;
    private Container nextContainer;
    private boolean eof = false;

    public CramContainerIterator(InputStream inputStream) {
        this.countingInputStream = new CountingInputStream(inputStream);
        this.cramHeader = CramIO.readCramHeader(this.countingInputStream);
        this.samFileHeader = Container.readSAMFileHeaderContainer(this.cramHeader.getCRAMVersion(), this.countingInputStream, null);
    }

    private void readNextContainer() {
        this.nextContainer = this.containerFromStream(this.countingInputStream);
        if (this.nextContainer.isEOF()) {
            this.eof = true;
            this.nextContainer = null;
        }
    }

    protected Container containerFromStream(CountingInputStream countingStream) {
        long containerByteOffset = countingStream.getCount();
        return new Container(this.cramHeader.getCRAMVersion(), countingStream, containerByteOffset);
    }

    @Override
    public boolean hasNext() {
        if (this.eof) {
            return false;
        }
        if (this.nextContainer == null) {
            this.readNextContainer();
        }
        return !this.eof;
    }

    @Override
    public Container next() {
        Container result = this.nextContainer;
        this.nextContainer = null;
        return result;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Read only iterator.");
    }

    public CramHeader getCramHeader() {
        return this.cramHeader;
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    @Override
    public void close() {
        this.nextContainer = null;
        this.cramHeader = null;
        this.countingInputStream.close();
    }
}

