/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.java.awt.image.ImageDecoder;
import gnu.java.awt.peer.gtk.GdkGraphics2D;
import gnu.java.awt.peer.gtk.GtkGenericPeer;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;
import javax.imageio.IIOImage;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageReader;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageWriterSpi;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class GdkPixbufDecoder
extends ImageDecoder {
    static final ColorModel cm;
    static ArrayList imageFormatSpecs;
    private static GdkPixbufReaderSpi readerSpi;
    private static GdkPixbufWriterSpi writerSpi;
    private final int native_state;
    private boolean needsClose;
    Vector curr;
    static /* synthetic */ Class class$gnu$java$awt$peer$gtk$GdkPixbufDecoder;
    static /* synthetic */ Class class$javax$imageio$spi$ImageReaderSpi;
    static /* synthetic */ Class class$javax$imageio$spi$ImageWriterSpi;

    static native void initStaticState();

    native void initState();

    native void pumpBytes(byte[] var1, int var2) throws IOException;

    native void pumpDone() throws IOException;

    native void finish(boolean var1);

    static native void streamImage(int[] var0, String var1, int var2, int var3, boolean var4, DataOutput var5);

    void areaPrepared(int width, int height) {
        if (this.curr == null) {
            return;
        }
        int i = 0;
        while (i < this.curr.size()) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.setDimensions(width, height);
            ic.setColorModel(cm);
            ic.setHints(1);
            ++i;
        }
    }

    void areaUpdated(int x, int y, int width, int height, int[] pixels, int scansize) {
        if (this.curr == null) {
            return;
        }
        int i = 0;
        while (i < this.curr.size()) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.setPixels(x, y, width, height, cm, pixels, 0, scansize);
            ++i;
        }
    }

    public void produce(Vector v, InputStream is) throws IOException {
        this.curr = v;
        byte[] bytes = new byte[4096];
        int len = 0;
        this.initState();
        this.needsClose = true;
        while ((len = is.read(bytes)) != -1) {
            this.pumpBytes(bytes, len);
        }
        this.pumpDone();
        this.needsClose = false;
        int i = 0;
        while (i < this.curr.size()) {
            ImageConsumer ic = (ImageConsumer)this.curr.elementAt(i);
            ic.imageComplete(3);
            ++i;
        }
        this.curr = null;
    }

    public void finalize() {
        this.finish(this.needsClose);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static ImageFormatSpec registerFormat(String name, boolean writable) {
        ImageFormatSpec ifs = new ImageFormatSpec(name, writable);
        Class clazz = class$gnu$java$awt$peer$gtk$GdkPixbufDecoder;
        if (clazz == null) {
            clazz = class$gnu$java$awt$peer$gtk$GdkPixbufDecoder = GdkPixbufDecoder.class("[Lgnu.java.awt.peer.gtk.GdkPixbufDecoder;", false);
        }
        Class clazz2 = clazz;
        synchronized (clazz) {
            if (imageFormatSpecs == null) {
                imageFormatSpecs = new ArrayList();
            }
            imageFormatSpecs.add(ifs);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ifs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] getFormatNames(boolean writable) {
        names = new ArrayList();
        var2_2 = GdkPixbufDecoder.imageFormatSpecs;
        synchronized (var2_2) {
            i = GdkPixbufDecoder.imageFormatSpecs.iterator();
            while (true) {
                if (!i.hasNext()) {
                    break;
                }
                ifs = (ImageFormatSpec)i.next();
                if (writable && !ifs.writable) continue;
                names.add(ifs.name);
                j = ifs.extensions.iterator();
                while (true) {
                    if (!j.hasNext()) ** break;
                    names.add((String)j.next());
                }
                break;
            }
        }
        objs = names.toArray();
        strings = new String[objs.length];
        i = 0;
        while (i < objs.length) {
            strings[i] = (String)objs[i];
            ++i;
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] getFormatExtensions(boolean writable) {
        extensions = new ArrayList();
        var2_2 = GdkPixbufDecoder.imageFormatSpecs;
        synchronized (var2_2) {
            i = GdkPixbufDecoder.imageFormatSpecs.iterator();
            while (true) {
                if (!i.hasNext()) {
                    break;
                }
                ifs = (ImageFormatSpec)i.next();
                if (writable && !ifs.writable) continue;
                j = ifs.extensions.iterator();
                while (true) {
                    if (!j.hasNext()) ** break;
                    extensions.add((String)j.next());
                }
                break;
            }
        }
        objs = extensions.toArray();
        strings = new String[objs.length];
        i = 0;
        while (i < objs.length) {
            strings[i] = (String)objs[i];
            ++i;
        }
        return strings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String[] getFormatMimeTypes(boolean writable) {
        mimeTypes = new ArrayList();
        var2_2 = GdkPixbufDecoder.imageFormatSpecs;
        synchronized (var2_2) {
            i = GdkPixbufDecoder.imageFormatSpecs.iterator();
            while (true) {
                if (!i.hasNext()) {
                    break;
                }
                ifs = (ImageFormatSpec)i.next();
                if (writable && !ifs.writable) continue;
                j = ifs.mimeTypes.iterator();
                while (true) {
                    if (!j.hasNext()) ** break;
                    mimeTypes.add((String)j.next());
                }
                break;
            }
        }
        objs = mimeTypes.toArray();
        strings = new String[objs.length];
        i = 0;
        while (i < objs.length) {
            strings[i] = (String)objs[i];
            ++i;
        }
        return strings;
    }

    static String findFormatName(Object ext, boolean needWritable) {
        if (ext == null) {
            return null;
        }
        if (!(ext instanceof String)) {
            throw new IllegalArgumentException("extension is not a string");
        }
        String str = (String)ext;
        Iterator i = imageFormatSpecs.iterator();
        while (i.hasNext()) {
            ImageFormatSpec ifs = (ImageFormatSpec)i.next();
            if (needWritable && !ifs.writable) continue;
            if (ifs.name.equals(str)) {
                return str;
            }
            Iterator j = ifs.extensions.iterator();
            while (j.hasNext()) {
                String extension = (String)j.next();
                if (!extension.equals(str)) continue;
                return ifs.name;
            }
            j = ifs.mimeTypes.iterator();
            while (j.hasNext()) {
                String mimeType = (String)j.next();
                if (!mimeType.equals(str)) continue;
                return ifs.name;
            }
        }
        throw new IllegalArgumentException("unknown extension '" + str + '\'');
    }

    public static synchronized GdkPixbufReaderSpi getReaderSpi() {
        if (readerSpi == null) {
            readerSpi = new GdkPixbufReaderSpi();
        }
        return readerSpi;
    }

    public static synchronized GdkPixbufWriterSpi getWriterSpi() {
        if (writerSpi == null) {
            writerSpi = new GdkPixbufWriterSpi();
        }
        return writerSpi;
    }

    public static void registerSpis(IIORegistry reg) {
        GdkPixbufReaderSpi gdkPixbufReaderSpi = GdkPixbufDecoder.getReaderSpi();
        Class clazz = class$javax$imageio$spi$ImageReaderSpi;
        if (clazz == null) {
            clazz = class$javax$imageio$spi$ImageReaderSpi = GdkPixbufDecoder.class("[Ljavax.imageio.spi.ImageReaderSpi;", false);
        }
        reg.registerServiceProvider(gdkPixbufReaderSpi, clazz);
        GdkPixbufWriterSpi gdkPixbufWriterSpi = GdkPixbufDecoder.getWriterSpi();
        Class clazz2 = class$javax$imageio$spi$ImageWriterSpi;
        if (clazz2 == null) {
            clazz2 = class$javax$imageio$spi$ImageWriterSpi = GdkPixbufDecoder.class("[Ljavax.imageio.spi.ImageWriterSpi;", false);
        }
        reg.registerServiceProvider(gdkPixbufWriterSpi, clazz2);
    }

    public static BufferedImage createBufferedImage(String filename) {
        GdkPixbufReader r = new GdkPixbufReader(GdkPixbufDecoder.getReaderSpi(), "png", new GdkPixbufDecoder(filename));
        return r.getBufferedImage();
    }

    public static BufferedImage createBufferedImage(URL u) {
        GdkPixbufReader r = new GdkPixbufReader(GdkPixbufDecoder.getReaderSpi(), "png", new GdkPixbufDecoder(u));
        return r.getBufferedImage();
    }

    public static BufferedImage createBufferedImage(byte[] imagedata, int imageoffset, int imagelength) {
        GdkPixbufReader r = new GdkPixbufReader(GdkPixbufDecoder.getReaderSpi(), "png", new GdkPixbufDecoder(imagedata, imageoffset, imagelength));
        return r.getBufferedImage();
    }

    public static BufferedImage createBufferedImage(ImageProducer producer) {
        GdkPixbufReader r = new GdkPixbufReader(GdkPixbufDecoder.getReaderSpi(), "png", null);
        producer.startProduction(r);
        return r.getBufferedImage();
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    private final /* synthetic */ void this() {
        this.native_state = GtkGenericPeer.getUniqueInteger();
        this.needsClose = false;
    }

    public GdkPixbufDecoder(InputStream in) {
        super(in);
        this.this();
    }

    public GdkPixbufDecoder(String filename) {
        super(filename);
        this.this();
    }

    public GdkPixbufDecoder(URL url) {
        super(url);
        this.this();
    }

    public GdkPixbufDecoder(byte[] imagedata, int imageoffset, int imagelength) {
        super(imagedata, imageoffset, imagelength);
        this.this();
    }

    static {
        System.loadLibrary("gtkpeer");
        GdkPixbufDecoder.initStaticState();
        cm = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class ImageFormatSpec {
        public String name;
        public boolean writable;
        public ArrayList mimeTypes;
        public ArrayList extensions;

        public synchronized void addMimeType(String m) {
            this.mimeTypes.add(m);
        }

        public synchronized void addExtension(String e) {
            this.extensions.add(e);
        }

        private final /* synthetic */ void this() {
            this.writable = false;
            this.mimeTypes = new ArrayList();
            this.extensions = new ArrayList();
        }

        public ImageFormatSpec(String name, boolean writable) {
            this.this();
            this.name = name;
            this.writable = writable;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class GdkPixbufReaderSpi
    extends ImageReaderSpi {
        static /* synthetic */ Class class$javax$imageio$stream$ImageInputStream;

        public boolean canDecodeInput(Object obj) {
            return true;
        }

        public ImageReader createReaderInstance(Object ext) {
            return new GdkPixbufReader(this, ext);
        }

        public String getDescription(Locale loc) {
            return "GdkPixbuf Reader SPI";
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        public GdkPixbufReaderSpi() {
            String[] stringArray = GdkPixbufDecoder.getFormatNames(false);
            String[] stringArray2 = GdkPixbufDecoder.getFormatExtensions(false);
            String[] stringArray3 = GdkPixbufDecoder.getFormatMimeTypes(false);
            Class[] classArray = new Class[1];
            Class clazz = class$javax$imageio$stream$ImageInputStream;
            if (clazz == null) {
                clazz = class$javax$imageio$stream$ImageInputStream = GdkPixbufReaderSpi.class("[Ljavax.imageio.stream.ImageInputStream;", false);
            }
            classArray[0] = clazz;
            super("GdkPixbuf", "2.x", stringArray, stringArray2, stringArray3, "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReader", classArray, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriterSpi"}, false, null, null, null, null, false, null, null, null, null);
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    public static class GdkPixbufWriterSpi
    extends ImageWriterSpi {
        static /* synthetic */ Class class$javax$imageio$stream$ImageOutputStream;

        public boolean canEncodeImage(ImageTypeSpecifier ts) {
            return true;
        }

        public ImageWriter createWriterInstance(Object ext) {
            return new GdkPixbufWriter(this, ext);
        }

        public String getDescription(Locale loc) {
            return "GdkPixbuf Writer SPI";
        }

        static /* synthetic */ Class class(String string, boolean bl) {
            try {
                Class clazz = Class.forName(string);
                if (!bl) {
                    clazz = clazz.getComponentType();
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError().initCause(classNotFoundException);
            }
        }

        public GdkPixbufWriterSpi() {
            String[] stringArray = GdkPixbufDecoder.getFormatNames(true);
            String[] stringArray2 = GdkPixbufDecoder.getFormatExtensions(true);
            String[] stringArray3 = GdkPixbufDecoder.getFormatMimeTypes(true);
            Class[] classArray = new Class[1];
            Class clazz = class$javax$imageio$stream$ImageOutputStream;
            if (clazz == null) {
                clazz = class$javax$imageio$stream$ImageOutputStream = GdkPixbufWriterSpi.class("[Ljavax.imageio.stream.ImageOutputStream;", false);
            }
            classArray[0] = clazz;
            super("GdkPixbuf", "2.x", stringArray, stringArray2, stringArray3, "gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufWriter", classArray, new String[]{"gnu.java.awt.peer.gtk.GdkPixbufDecoder$GdkPixbufReaderSpi"}, false, null, null, null, null, false, null, null, null, null);
        }
    }

    private static class GdkPixbufReader
    extends ImageReader
    implements ImageConsumer {
        GdkPixbufDecoder dec;
        BufferedImage bufferedImage;
        ColorModel defaultModel;
        int width;
        int height;
        String ext;

        public void setDimensions(int w, int h) {
            this.processImageStarted(1);
            this.width = w;
            this.height = h;
        }

        public void setProperties(Hashtable props) {
        }

        public void setColorModel(ColorModel model) {
            this.defaultModel = model;
        }

        public void setHints(int flags) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, byte[] pixels, int offset, int scansize) {
        }

        public void setPixels(int x, int y, int w, int h, ColorModel model, int[] pixels, int offset, int scansize) {
            int[] pixels2;
            if (model == null) {
                model = this.defaultModel;
            }
            if (this.bufferedImage == null) {
                int n = 0;
                if (model != null && model.hasAlpha()) {
                    n = 1;
                }
                this.bufferedImage = new BufferedImage(this.width, this.height, n + 1);
            }
            if (model != null) {
                pixels2 = new int[pixels.length];
                int yy = 0;
                while (yy < h) {
                    int xx = 0;
                    while (xx < w) {
                        int i = yy * scansize + xx;
                        pixels2[i] = model.getRGB(pixels[i]);
                        ++xx;
                    }
                    ++yy;
                }
            } else {
                pixels2 = pixels;
            }
            this.bufferedImage.setRGB(x, y, w, h, pixels2, offset, scansize);
            int n = 1;
            if (this.height != 0) {
                n = this.height;
            }
            this.processImageProgress(y / n);
        }

        public void imageComplete(int status) {
            this.processImageComplete();
        }

        public BufferedImage getBufferedImage() {
            if (this.bufferedImage == null && this.dec != null) {
                this.dec.startProduction(this);
            }
            return this.bufferedImage;
        }

        public int getNumImages(boolean allowSearch) throws IOException {
            return 1;
        }

        public IIOMetadata getImageMetadata(int i) {
            return null;
        }

        public IIOMetadata getStreamMetadata() throws IOException {
            return null;
        }

        public Iterator getImageTypes(int imageIndex) throws IOException {
            BufferedImage img = this.getBufferedImage();
            Vector vec = new Vector();
            vec.add(new ImageTypeSpecifier(img));
            return vec.iterator();
        }

        public int getHeight(int imageIndex) throws IOException {
            return this.getBufferedImage().getHeight();
        }

        public int getWidth(int imageIndex) throws IOException {
            return this.getBufferedImage().getWidth();
        }

        public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
            super.setInput(input, seekForwardOnly, ignoreMetadata);
            this.dec = new GdkPixbufDecoder((InputStream)this.getInput());
        }

        public BufferedImage read(int imageIndex, ImageReadParam param) throws IOException {
            return this.getBufferedImage();
        }

        public GdkPixbufReader(GdkPixbufReaderSpi ownerSpi, Object ext) {
            super(ownerSpi);
            this.ext = GdkPixbufDecoder.findFormatName(ext, false);
        }

        public GdkPixbufReader(GdkPixbufReaderSpi ownerSpi, Object ext, GdkPixbufDecoder d) {
            this(ownerSpi, ext);
            this.dec = d;
        }
    }

    private static class GdkPixbufWriter
    extends ImageWriter {
        String ext;

        public IIOMetadata convertImageMetadata(IIOMetadata inData, ImageTypeSpecifier imageType, ImageWriteParam param) {
            return null;
        }

        public IIOMetadata convertStreamMetadata(IIOMetadata inData, ImageWriteParam param) {
            return null;
        }

        public IIOMetadata getDefaultImageMetadata(ImageTypeSpecifier imageType, ImageWriteParam param) {
            return null;
        }

        public IIOMetadata getDefaultStreamMetadata(ImageWriteParam param) {
            return null;
        }

        public void write(IIOMetadata streamMetadata, IIOImage i, ImageWriteParam param) throws IOException {
            RenderedImage image = i.getRenderedImage();
            Raster ras = image.getData();
            int width = ras.getWidth();
            int height = ras.getHeight();
            ColorModel model = image.getColorModel();
            int[] pixels = GdkGraphics2D.findSimpleIntegerArray(image.getColorModel(), ras);
            if (pixels == null) {
                int n = 0;
                if (model != null && model.hasAlpha()) {
                    n = 1;
                }
                BufferedImage img = new BufferedImage(width, height, n + 1);
                int[] pix = new int[4];
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        img.setRGB(x, y, model.getRGB(ras.getPixel(x, y, pix)));
                        ++x;
                    }
                    ++y;
                }
                pixels = GdkGraphics2D.findSimpleIntegerArray(img.getColorModel(), img.getRaster());
                model = img.getColorModel();
            }
            this.processImageStarted(1);
            GdkPixbufDecoder.streamImage(pixels, this.ext, width, height, model.hasAlpha(), (DataOutput)this.getOutput());
            this.processImageComplete();
        }

        public GdkPixbufWriter(GdkPixbufWriterSpi ownerSpi, Object ext) {
            super(ownerSpi);
            this.ext = GdkPixbufDecoder.findFormatName(ext, true);
        }
    }
}

