/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.readers.vcf;

import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import org.campagnelab.goby.readers.vcf.ColumnField;

public class ColumnFields
extends ObjectArraySet<ColumnField> {
    private static final long serialVersionUID = -6258574769357583135L;
    final Object2ObjectOpenHashMap<CharSequence, ColumnField> map = new Object2ObjectOpenHashMap();
    final Int2ObjectOpenHashMap<ColumnField> indexMap = new Int2ObjectOpenHashMap();
    private int previousSize = -1;
    final ObjectArrayList<ColumnField> list = new ObjectArrayList();

    public boolean hasFieldName(CharSequence id) {
        this.rebuildMap();
        return this.map.containsKey((Object)id);
    }

    private void rebuildMap() {
        int setSize = this.size();
        if (this.map.size() != setSize) {
            this.map.clear();
            this.indexMap.clear();
            ObjectIterator<ColumnField> objectIterator = this.iterator();
            while (objectIterator.hasNext()) {
                ColumnField field = (ColumnField)objectIterator.next();
                this.map.put((Object)field.id, (Object)field);
                this.indexMap.put(field.globalFieldIndex, (Object)field);
            }
            this.previousSize = this.map.size();
        }
    }

    public ColumnField find(CharSequence id) {
        this.rebuildMap();
        return (ColumnField)this.map.get((Object)id);
    }

    public ColumnField find(int fieldIndex) {
        this.rebuildMap();
        return (ColumnField)this.indexMap.get(fieldIndex);
    }

    public final ColumnField get(int index) {
        return (ColumnField)this.list.get(index);
    }

    public final ObjectIterator<ColumnField> iterator() {
        this.rebuildList();
        return this.list.listIterator();
    }

    public final void rebuildList() {
        int setSize = this.size();
        if (this.previousSize != setSize) {
            this.list.clear();
            ObjectIterator it = super.iterator();
            while (it.hasNext()) {
                ColumnField next = (ColumnField)it.next();
                this.list.add((Object)next);
            }
            this.previousSize = setSize;
        }
    }
}

