(* Parsing -- runtime library for parsers generated by mosmlyac            *)
(* Based on the runtime library for camlyacc; copyright 1993 INRIA, France *)

local open Vector Obj Lexing in

val symbolStart : unit -> int
val symbolEnd   : unit -> int
val itemStart   : int -> int
val itemEnd     : int -> int
val clearParser : unit -> unit

(* For internal use in generated parsers: *)

type parseTables =
    (* actions *)    (unit -> obj) vector  *
    (* transl *)     int vector *
    (* lhs *)        string *
    (* len *)        string *
    (* defred *)     string *
    (* dgoto *)      string *
    (* sindex *)     string *
    (* rindex *)     string *
    (* gindex *)     string *
    (* tablesize *)  int *
    (* table *)      string *
    (* check *)      string

exception yyexit of obj
exception ParseError of (obj -> bool)

val yyparse : parseTables -> int -> (lexbuf -> 'a) -> lexbuf -> 'b
val peekVal : int -> 'a

end

(*
   These functions are for use in mosmlyac-generated parsers.  For
   further information, see the Moscow ML Owner's Manual.  For
   examples, see mosml/examples/lexyacc and mosml/examples/calc.

   A grammar definition (input to mosmlyac) consists of fragments of
   this form

       nonterm :
          grsyms1   { action1 }
        | grsyms2   { action2 }
        | grsyms3   { action3 }
        | ...

   where the grsyms are sequences of grammar symbols, matching some
   string of characters, and the actions are corresponding semantic
   actions, written in ML.  The following functions can be used in the
   semantic actions:

   [symbolStart ()] returns the start position of the string that
   matches the sequence of grammar symbols.  The first character in
   the input stream has position 0.  May be called in a semantic
   action only.

   [symbolEnd ()] returns the end position, plus one, of the string
   that matches the sequence of grammar symbols.  The first character
   in the input stream has position 0.  May be called in a semantic
   action only.

   [itemStart i] returns the start position of the string that matches
   the i'th grammar symbol in the sequence.  The first grammar symbol
   has number 1.  The first character in the input stream has position
   0.  May be called in a semantic action only.

   [itemEnd i] returns the end position, plus one, of the string that
   matches the i'th grammar symbol in the sequence.  The first grammar
   symbols has number 1.  The first character in the input stream has
   position 0.  May be called in a semantic action only.

   [clearParser ()] clears the parser stack.  It may be called after a
   parsing function has returned, to remove all pointers from the
   parser stack to structures that were built by semantic actions
   during parsing.  This is not strict necessary, but reduces the
   memory requirements of the program.
*)
