/*
 * Decompiled with CFR 0.152.
 */
package java.awt.datatransfer;

import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.FlavorEvent;
import java.awt.datatransfer.FlavorListener;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Clipboard {
    protected Transferable contents;
    protected ClipboardOwner owner;
    private final String name;
    private final ArrayList listeners;

    public String getName() {
        return this.name;
    }

    public synchronized Transferable getContents(Object requestor) {
        return this.contents;
    }

    public synchronized void setContents(Transferable contents, ClipboardOwner owner) {
        FlavorListener[] fs;
        Transferable oldContents = this.getContents(null);
        this.contents = contents;
        if (this.owner != owner) {
            ClipboardOwner oldOwner = this.owner;
            this.owner = owner;
            if (oldOwner != null) {
                oldOwner.lostOwnership(this, oldContents);
            }
        }
        if ((fs = this.getFlavorListeners()).length > 0) {
            boolean newFlavors;
            boolean bl = false;
            if (contents != null && oldContents == null || contents == null && oldContents != null) {
                bl = true;
            }
            if (!(newFlavors = bl) && contents != null && oldContents != null) {
                DataFlavor[] df1 = contents.getTransferDataFlavors();
                DataFlavor[] df2 = oldContents.getTransferDataFlavors();
                boolean bl2 = false;
                if (df1.length != df2.length) {
                    bl2 = true;
                }
                newFlavors = bl2;
                int i = 0;
                while (!newFlavors && i < df1.length) {
                    newFlavors = df1[i].equals(df2[i]) ^ true;
                    ++i;
                }
            }
            if (newFlavors) {
                FlavorEvent e = new FlavorEvent(this);
                int i = 0;
                while (i < fs.length) {
                    fs[i].flavorsChanged(e);
                    ++i;
                }
            }
        }
    }

    public DataFlavor[] getAvailableDataFlavors() {
        Transferable c = this.getContents(null);
        if (c == null) {
            return new DataFlavor[0];
        }
        return c.getTransferDataFlavors();
    }

    public boolean isDataFlavorAvailable(DataFlavor flavor) {
        DataFlavor[] fs = this.getAvailableDataFlavors();
        int i = 0;
        while (i < fs.length) {
            if (flavor.equals(fs[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object getData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        Transferable c = this.getContents(null);
        if (c == null) {
            throw new UnsupportedFlavorException(flavor);
        }
        return c.getTransferData(flavor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addFlavorListener(FlavorListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeFlavorListener(FlavorListener listener) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(listener);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public FlavorListener[] getFlavorListeners() {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            return (FlavorListener[])this.listeners.toArray(new FlavorListener[this.listeners.size()]);
        }
    }

    private final /* synthetic */ void this() {
        this.listeners = new ArrayList(3);
    }

    public Clipboard(String name) {
        this.this();
        this.name = name;
    }
}

