// -*- c++ -*-
//
// Software License for MTL
// 
// Copyright (c) 2001-2005 The Trustees of Indiana University. All rights reserved.
// Copyright (c) 1998-2001 University of Notre Dame. All rights reserved.
// Authors: Andrew Lumsdaine, Jeremy G. Siek, Lie-Quan Lee
// 
// This file is part of the Matrix Template Library
// 
// See also license.mtl.txt in the distribution.


#include "mtl/mtl2lapack.h"
#include "mtl/dense1D.h"
#include "mtl/utils.h"


/*
  Sample Output

3x3
[
[1,2,2],
[2,1,2],
[2,2,1]
]
s:
[5,1,1,]
A:
3x3
[
[-3,3.77124,0.414214],
[0.5,-1.66667,8.2562e-17],
[0.5,0.414214,-1]
]
u:
3x3
[
[-0.57735,-7.40149e-17,0.816497],
[-0.57735,-0.707107,-0.408248],
[-0.57735,0.707107,-0.408248]
]
vt:
3x3
[
[-0.57735,-0.57735,-0.57735],
[-0,0.707107,-0.707107],
[-0.816497,0.408248,0.408248]
]
 */
int
main()
{
  const int M = 3;
  const int N = 3;
  using namespace mtl;
  //begin
  double da[] = { 1, 2, 2, 2, 1, 2, 2, 2, 1};
  mtl2lapack::lapack_matrix<double, external>::type A(da, M, N);

  double du[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0};
  mtl2lapack::lapack_matrix<double, external>::type u(du, M, N);

  double dvt[] = { 0, 0, 0, 0, 0, 0, 0, 0, 0};
  mtl2lapack::lapack_matrix<double, external>::type vt(dvt, M, N);

  dense1D<double> s(MTL_MAX(M,N), 0);
  //end
  print_all_matrix(A);
  //begin
  int info = mtl2lapack::gesvd('A', 'A', A, s, u, vt);

  if (info == 0) {
    std::cout << "s:" << std::endl;
    print_vector(s);
    std::cout << "A:" << std::endl;
    print_all_matrix(A);
    std::cout << "u:" << std::endl;
    print_all_matrix(u);
    std::cout << "vt:" << std::endl;
    print_all_matrix(vt);
  } else {
    std::cerr << "error INFO = " << info << std::endl;
  }
  //end  
  return 0;
}
