require File.dirname(__FILE__) + '/helper.rb'

class TestVersion < Test::Unit::TestCase

  def test_version
    assert_kind_of(String, Color::RGB::JP::VERSION::STRING)
    assert_kind_of(Integer, Color::RGB::JP::VERSION::MAJOR)
    assert_kind_of(Integer, Color::RGB::JP::VERSION::MINOR)
    assert_kind_of(Integer, Color::RGB::JP::VERSION::TINY)

    assert_match(/\d+\.\d+\.\d+/, Color::RGB::JP::VERSION::STRING)
    assert_equal(Color::RGB::JP::VERSION::STRING, [
      Color::RGB::JP::VERSION::MAJOR,
      Color::RGB::JP::VERSION::MINOR,
      Color::RGB::JP::VERSION::TINY,
    ].join('.'))
  end

end
