package TDS::Cache::Display;
# $Id: Display.pm,v 1.10.2.1 2001/02/13 00:48:11 tom Exp $
################################################################

use strict;
use vars qw(@ISA $AUTOLOAD);

use TDS;
use TDS::Cache::Diary;
use TDS::DirInfo;

@ISA = qw(TDS::Cache::Diary);

attributes qw();

################################################################
# auto loading

use AutoLoader;
#no strict;

sub AUTOLOAD {
    $AutoLoader::AUTOLOAD = $AUTOLOAD;
    goto &AutoLoader::AUTOLOAD;
}

package TDS::Cache::Display;
1;

__END__

sub IsFresh($)
{
    my $self = shift;

    # *.tdf
    my $cache_lm = $self->GetCacheLastModified;
    return 0 if $TDS::Status->lmo->lm > $cache_lm;

    return $self->SUPER::IsFresh;
}    

################################################################
sub WriteCache($$)
{
    my ($self, $html) = @_;
    $self->has_secret($TDS::Status->has_secret);
    $self->SUPER::WriteCache($html);
}

sub NewerThanDatafile($)
{
    my $self = shift;

    # others
    my $dir = GetStyleDir();
    my $data_dir = GetDataDir();

    return 0 if $self->newer_than_cache("$dir/skelton.html");
    return 0 if $self->newer_than_cache("$data_dir/captured_antenna.dat");
    return 0 if $self->newer_than_cache("$data_dir/information.dat");
    require TDS::AccessLog::DirInfo;
    return 0 if $self->newer_than_cache(TDS::AccessLog::DirInfo::GetLogDir() . "/comment.dat");
    # do not call super class because of this class do NOT have GetDataFilename
#    return $self->SUPER::NewerThanDatafile;
    return 1;
}
sub GetDataFilename($)
{
    my $self = shift;
    my $class = ref $self;

    die "${class}::GetDataFilename() must NOT be called";
}
1;




