/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.reads;

import com.google.protobuf.ByteString;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Properties;
import org.campagnelab.goby.compression.MessageChunksWriter;
import org.campagnelab.goby.reads.ReadCodec;
import org.campagnelab.goby.reads.ReadProtobuffCollectionHandler;
import org.campagnelab.goby.reads.Reads;
import org.campagnelab.goby.reads.ReadsWriter;

public class ReadsWriterImpl
implements ReadsWriter {
    private final Reads.ReadCollection.Builder collectionBuilder;
    private CharSequence sequence;
    private CharSequence description;
    private CharSequence identifier;
    private byte[] qualityScores;
    private int readIndex;
    private int previousReadLength;
    private long sequenceBasesWritten;
    private final MessageChunksWriter messageChunkWriter;
    private byte[] byteBuffer = new byte[100];
    private int barcodeIndex = -1;
    private CharSequence pairSequence;
    private byte[] qualityScoresPair;
    private ReadCodec codec;
    boolean firstRead = true;
    Properties keyValuePairs = new Properties();

    public ReadsWriterImpl(OutputStream output) {
        this.collectionBuilder = Reads.ReadCollection.newBuilder();
        this.messageChunkWriter = new MessageChunksWriter(output);
        this.messageChunkWriter.setParser(new ReadProtobuffCollectionHandler());
        this.readIndex = 0;
    }

    @Override
    public synchronized void setQualityScores(byte[] qualityScores) {
        this.qualityScores = qualityScores;
    }

    @Override
    public synchronized void setDescription(CharSequence description) {
        this.description = description;
    }

    @Override
    public synchronized void setSequence(CharSequence sequence) {
        this.sequence = sequence;
    }

    @Override
    public synchronized void setPairSequence(CharSequence sequence) {
        this.pairSequence = sequence;
    }

    @Override
    public synchronized void appendEntry(CharSequence description, CharSequence sequence, byte[] qualityScores) throws IOException {
        this.description = description;
        this.sequence = sequence;
        this.qualityScores = qualityScores;
        this.appendEntry();
    }

    @Override
    public synchronized void appendEntry(CharSequence description, CharSequence sequence) throws IOException {
        this.description = description;
        this.sequence = sequence;
        this.appendEntry();
    }

    @Override
    public synchronized void appendEntry(CharSequence sequence) throws IOException {
        this.sequence = sequence;
        this.appendEntry();
    }

    @Override
    public synchronized void appendEntry(Reads.ReadEntry.Builder entryBuilder) throws IOException {
        this.collectionBuilder.addReads(entryBuilder.build());
        this.messageChunkWriter.writeAsNeeded(this.collectionBuilder);
        this.barcodeIndex = -1;
    }

    @Override
    public void close() throws IOException {
        this.messageChunkWriter.close(this.collectionBuilder);
    }

    @Override
    public synchronized void appendEntry() throws IOException {
        this.appendEntry(this.readIndex);
        ++this.readIndex;
    }

    @Override
    public synchronized void appendEntry(int readIndex) throws IOException {
        Reads.ReadEntry.Builder entryBuilder = Reads.ReadEntry.newBuilder();
        entryBuilder.setReadIndex(readIndex);
        this.readIndex = readIndex;
        if (this.barcodeIndex != -1) {
            entryBuilder.setBarcodeIndex(this.barcodeIndex);
        }
        if (this.description != null) {
            entryBuilder.setDescription(this.description.toString());
            this.description = null;
        }
        if (this.identifier != null) {
            entryBuilder.setReadIdentifier(this.identifier.toString());
            this.identifier = null;
        }
        if (this.sequence != null) {
            entryBuilder.setSequence(this.encodeSequence(this.sequence));
            this.sequence = null;
        }
        entryBuilder.setReadLength(this.previousReadLength);
        if (this.pairSequence != null) {
            entryBuilder.setSequencePair(this.encodeSequence(this.pairSequence));
            this.pairSequence = null;
            entryBuilder.setReadLengthPair(this.previousReadLength);
        }
        if (this.qualityScores != null) {
            entryBuilder.setQualityScores(ByteString.copyFrom((byte[])this.qualityScores));
            this.qualityScores = null;
        }
        if (this.qualityScoresPair != null) {
            entryBuilder.setQualityScoresPair(ByteString.copyFrom((byte[])this.qualityScoresPair));
            this.qualityScoresPair = null;
        }
        if (this.firstRead && this.keyValuePairs != null) {
            for (Object keyObject : this.keyValuePairs.keySet()) {
                String key = keyObject.toString();
                String value = this.keyValuePairs.get(key).toString();
                entryBuilder.addMetaData(Reads.MetaData.newBuilder().setKey(key).setValue(value));
            }
            this.firstRead = false;
        }
        if (this.codec != null) {
            Reads.ReadEntry.Builder result;
            if (this.collectionBuilder.getReadsCount() == 0) {
                this.codec.newChunk();
            }
            if ((result = this.codec.encode(entryBuilder)) != null) {
                entryBuilder = result;
            }
        }
        this.collectionBuilder.addReads(entryBuilder.build());
        this.messageChunkWriter.writeAsNeeded(this.collectionBuilder);
        this.barcodeIndex = -1;
    }

    public static ByteString encodeSequence(CharSequence sequence, byte[] byteBuffer) {
        int length = sequence.length();
        if (length > byteBuffer.length) {
            byteBuffer = new byte[length];
        }
        byte[] bytes = byteBuffer;
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)sequence.charAt(i);
        }
        return ByteString.copyFrom((byte[])bytes, (int)0, (int)length);
    }

    private synchronized ByteString encodeSequence(CharSequence sequence) {
        int length = sequence.length();
        if (length > this.byteBuffer.length) {
            this.byteBuffer = new byte[length];
        }
        byte[] bytes = this.byteBuffer;
        for (int i = 0; i < length; ++i) {
            bytes[i] = (byte)sequence.charAt(i);
            ++this.sequenceBasesWritten;
        }
        this.previousReadLength = length;
        return ByteString.copyFrom((byte[])bytes, (int)0, (int)length);
    }

    @Override
    public void setNumEntriesPerChunk(int numEntriesPerChunk) {
        this.messageChunkWriter.setNumEntriesPerChunk(numEntriesPerChunk);
    }

    @Override
    public synchronized void setIdentifier(CharSequence identifier) {
        this.identifier = identifier;
    }

    @Override
    public synchronized long getSequenceBasesWritten() {
        return this.sequenceBasesWritten;
    }

    @Override
    public synchronized void printStats(PrintStream out) {
        this.messageChunkWriter.printStats(out);
        out.println("Number of bits/base " + (float)this.messageChunkWriter.getTotalBytesWritten() * 8.0f / (float)this.sequenceBasesWritten);
    }

    @Override
    public void setBarcodeIndex(int barcodeIndex) {
        this.barcodeIndex = barcodeIndex;
    }

    @Override
    public void setQualityScoresPair(byte[] qualityScores) {
        this.qualityScoresPair = qualityScores;
    }

    @Override
    public void appendMetaData(String key, String value) {
        this.keyValuePairs.put(key, value);
    }

    @Override
    public void setMetaData(Properties keyValuePairs) {
        this.keyValuePairs = keyValuePairs;
    }

    @Override
    public void setCodec(ReadCodec codec) {
        this.codec = codec;
    }
}

