/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

public final class Integer
extends Number
implements Comparable {
    private static final long serialVersionUID = 1360826667806852920L;
    public static final int MIN_VALUE = -2147483648;
    public static final int MAX_VALUE = 0x7FFFFFFF;
    public static final Class TYPE = VMClassLoader.getPrimitiveClass('I');
    public static final int SIZE = 32;
    private static final int MIN_CACHE = -128;
    private static final int MAX_CACHE = 127;
    private static Integer[] intCache = new Integer[256];
    private final int value;

    public static final String toString(int num, int radix) {
        if (radix < 2 || radix > 36) {
            radix = 10;
        }
        char[] buffer = new char[33];
        int i = 33;
        boolean isNeg = false;
        if (num < 0) {
            isNeg = true;
            if ((num = -num) < 0) {
                buffer[--i] = digits[-(num + radix) % radix];
                num = -(num / radix);
            }
        }
        do {
            buffer[--i] = digits[num % radix];
        } while ((num /= radix) > 0);
        if (isNeg) {
            buffer[--i] = 45;
        }
        return new String(buffer, i, 33 - i, true);
    }

    public static final String toHexString(int i) {
        return Integer.toUnsignedString(i, 4);
    }

    public static final String toOctalString(int i) {
        return Integer.toUnsignedString(i, 3);
    }

    public static final String toBinaryString(int i) {
        return Integer.toUnsignedString(i, 1);
    }

    public static final String toString(int i) {
        return String.valueOf(i);
    }

    public static final int parseInt(String str, int radix) {
        return Integer.parseInt(str, radix, false);
    }

    public static final int parseInt(String s) {
        return Integer.parseInt(s, 10, false);
    }

    public static final Integer valueOf(String s, int radix) {
        return new Integer(Integer.parseInt(s, radix, false));
    }

    public static final Integer valueOf(String s) {
        return new Integer(Integer.parseInt(s, 10, false));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final Integer valueOf(int val) {
        if (val < -128 || val > 127) {
            return new Integer(val);
        }
        Integer[] integerArray = intCache;
        synchronized (intCache) {
            if (intCache[val - -128] == null) {
                Integer.intCache[val - -128] = new Integer(val);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return intCache[val - -128];
        }
    }

    public final byte byteValue() {
        return (byte)this.value;
    }

    public final short shortValue() {
        return (short)this.value;
    }

    public final int intValue() {
        return this.value;
    }

    public final long longValue() {
        return this.value;
    }

    public final float floatValue() {
        return this.value;
    }

    public final double doubleValue() {
        return this.value;
    }

    public final String toString() {
        return String.valueOf(this.value);
    }

    public final int hashCode() {
        return this.value;
    }

    public final boolean equals(Object obj) {
        boolean bl = false;
        if (obj instanceof Integer && this.value == ((Integer)obj).value) {
            bl = true;
        }
        return bl;
    }

    public static final Integer getInteger(String nm) {
        return Integer.getInteger(nm, null);
    }

    public static final Integer getInteger(String nm, int val) {
        Integer result = Integer.getInteger(nm, null);
        return result == null ? new Integer(val) : result;
    }

    public static final Integer getInteger(String nm, Integer def) {
        if (nm == null || "".equals(nm)) {
            return def;
        }
        if ((nm = System.getProperty(nm)) == null) {
            return def;
        }
        try {
            return Integer.decode(nm);
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static final Integer decode(String str) {
        return new Integer(Integer.parseInt(str, 10, true));
    }

    public final int compareTo(Integer i) {
        if (this.value == i.value) {
            return 0;
        }
        return this.value > i.value ? 1 : -1;
    }

    public final int compareTo(Object o) {
        return this.compareTo((Integer)o);
    }

    public static final int bitCount(int x) {
        x = (x >> 1 & 0x55555555) + (x & 0x55555555);
        x = (x >> 2 & 0x33333333) + (x & 0x33333333);
        x = (x >> 4 & 0xF0F0F0F) + (x & 0xF0F0F0F);
        x = (x >> 8 & 0xFF00FF) + (x & 0xFF00FF);
        return (x >> 16 & (char)-1) + (x & (char)-1);
    }

    public static final int rotateLeft(int x, int distance) {
        return x << distance | x >>> -distance;
    }

    public static final int rotateRight(int x, int distance) {
        return x << -distance | x >>> distance;
    }

    public static final int highestOneBit(int value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        return value ^ value >>> 1;
    }

    public static final int numberOfLeadingZeros(int value) {
        value |= value >>> 1;
        value |= value >>> 2;
        value |= value >>> 4;
        value |= value >>> 8;
        value |= value >>> 16;
        return Integer.bitCount(~value);
    }

    public static final int lowestOneBit(int value) {
        return value & -value;
    }

    public static final int numberOfTrailingZeros(int value) {
        return Integer.bitCount((value & -value) - 1);
    }

    public static final int signum(int x) {
        int n;
        if (x < 0) {
            n = -1;
        } else {
            n = 0;
            if (x > 0) {
                n = 1;
            }
        }
        return n;
    }

    public static final int reverseBytes(int val) {
        return val >> 24 & 0xFF | val >> 8 & 0xFF00 | val << 8 & 0xFF0000 | val << 24 & 0xFF000000;
    }

    public static final int reverse(int val) {
        val = (val >> 1 & 0x55555555) + (val << 1 & 0xAAAAAAAA);
        val = (val >> 2 & 0x33333333) + (val << 2 & 0xCCCCCCCC);
        val = (val >> 4 & 0xF0F0F0F) + (val << 4 & 0xF0F0F0F0);
        val = (val >> 8 & 0xFF00FF) + (val << 8 & 0xFF00FF00);
        return (val >> 16 & (char)-1) + (val << 16 & 0xFFFF0000);
    }

    static final String toUnsignedString(int num, int exp) {
        int mask = (1 << exp) - 1;
        char[] buffer = new char[32];
        int i = 32;
        do {
            buffer[--i] = digits[num & mask];
        } while ((num >>>= exp) != 0);
        return new String(buffer, i, 32 - i, true);
    }

    static final int parseInt(String str, int radix, boolean decode) {
        if (!decode && str == null) {
            throw new NumberFormatException();
        }
        int index = 0;
        int len = str.length();
        boolean isNeg = false;
        if (len == 0) {
            throw new NumberFormatException("string length is null");
        }
        int ch = str.charAt(index);
        if (ch == 45) {
            if (len == 1) {
                throw new NumberFormatException("pure '-'");
            }
            isNeg = true;
            ch = str.charAt(++index);
        }
        if (decode) {
            if (ch == 48) {
                if (++index == len) {
                    return 0;
                }
                if ((str.charAt(index) & 0xFFFFFFDF) == 88) {
                    radix = 16;
                    ++index;
                } else {
                    radix = 8;
                }
            } else if (ch == 35) {
                radix = 16;
                ++index;
            }
        }
        if (index == len) {
            throw new NumberFormatException("non terminated number: " + str);
        }
        int max = Integer.MAX_VALUE / radix;
        if (isNeg && Integer.MAX_VALUE % radix == radix - 1) {
            ++max;
        }
        int val = 0;
        while (index < len) {
            if (val < 0 || val > max) {
                throw new NumberFormatException("number overflow (pos=" + index + ") : " + str);
            }
            ch = Character.digit(str.charAt(index++), radix);
            val = val * radix + ch;
            if (ch >= 0 && (val >= 0 || isNeg && val == Integer.MIN_VALUE)) continue;
            throw new NumberFormatException("invalid character at position " + index + " in " + str);
        }
        return isNeg ? -val : val;
    }

    public Integer(int value) {
        this.value = value;
    }

    public Integer(String s) {
        this.value = Integer.parseInt(s, 10, false);
    }
}

