/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.qt;

import gnu.java.awt.peer.qt.QMatrix;
import gnu.java.awt.peer.qt.QPainterPath;
import gnu.java.awt.peer.qt.QPen;
import gnu.java.awt.peer.qt.QtFontMetrics;
import gnu.java.awt.peer.qt.QtFontPeer;
import gnu.java.awt.peer.qt.QtImage;
import gnu.java.awt.peer.qt.QtVolatileImage;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

public abstract class QtGraphics
extends Graphics2D {
    private static final AffineTransform identity = new AffineTransform();
    protected long nativeObject;
    protected Font font;
    protected Color color;
    protected Color bgcolor;
    protected Shape clip;
    protected Shape initialClip;
    protected AffineTransform xform;
    protected Stroke currentStroke;
    protected boolean nativeStroking;
    protected Composite composite;
    protected double currentAlpha;
    protected Paint currentPaint;
    protected RenderingHints renderingHints;
    Graphics parent;

    protected void setup() {
        this.font = new Font("Dialog", 0, 12);
        this.setTransform(identity);
        this.setStroke(new BasicStroke());
        this.renderingHints = new RenderingHints(null);
    }

    public synchronized native void delete();

    public void dispose() {
    }

    private final void resetClip() {
        AffineTransform current = this.getTransform();
        this.setTransform(identity);
        this.setClip(this.initialClip);
        this.setTransform(current);
    }

    protected native void initImage(QtImage var1);

    protected native void initVolatileImage(QtVolatileImage var1);

    private final native void cloneNativeContext(QtGraphics var1);

    private final native void setColor(int var1, int var2, int var3, int var4);

    private final native void drawNative(QPainterPath var1);

    private final native void fillNative(QPainterPath var1);

    private final native void setClipNative(QPainterPath var1);

    private final native void setClipRectNative(int var1, int var2, int var3, int var4);

    private final native void intersectClipNative(QPainterPath var1);

    private final native void intersectClipRectNative(int var1, int var2, int var3, int var4);

    private final native void setQtTransform(QMatrix var1);

    private final native void setNativeStroke(QPen var1);

    private final native void setNativeComposite(int var1);

    private final native void drawStringNative(String var1, double var2, double var4);

    private final native void setLinearGradient(int var1, int var2, int var3, int var4, int var5, int var6, double var7, double var9, double var11, double var13, boolean var15);

    private final native void setAlphaNative(double var1);

    private final native void setFontNative(QtFontPeer var1);

    private final native QPainterPath getClipNative();

    void setAlpha(double alpha) {
        this.currentAlpha = alpha;
        this.setAlphaNative(this.currentAlpha);
    }

    public abstract Graphics create();

    public abstract void copyArea(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract GraphicsConfiguration getDeviceConfiguration();

    public Color getColor() {
        return new Color(this.color.getRed(), this.color.getGreen(), this.color.getBlue());
    }

    public void setColor(Color c) {
        if (c == null) {
            c = Color.white;
        }
        this.color = c;
        int alpha = (int)((double)c.getAlpha() * this.currentAlpha);
        this.setColor(c.getRed(), c.getGreen(), c.getBlue(), alpha);
    }

    public void setBackground(Color color) {
        this.bgcolor = new Color(color.getRed(), color.getGreen(), color.getBlue());
    }

    public Color getBackground() {
        return new Color(this.bgcolor.getRed(), this.bgcolor.getGreen(), this.bgcolor.getBlue());
    }

    public void setPaintMode() {
    }

    public void setXORMode(Color color) {
    }

    public boolean hit(Rectangle rect, Shape s, boolean onStroke) {
        if (onStroke) {
            Shape stroked = this.currentStroke.createStrokedShape(s);
            return stroked.intersects(rect.x, rect.y, rect.width, rect.height);
        }
        return s.intersects(rect.x, rect.y, rect.width, rect.height);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            return;
        }
        this.font = font;
        if (font.getPeer() != null && font.getPeer() instanceof QtFontPeer) {
            this.setFontNative((QtFontPeer)font.getPeer());
        }
    }

    public FontMetrics getFontMetrics(Font font) {
        return new QtFontMetrics(font, (Graphics)this);
    }

    public void clip(Shape s) {
        this.intersectClipNative(new QPainterPath(s));
    }

    public void clipRect(int x, int y, int width, int height) {
        this.intersectClipRectNative(x, y, width, height);
    }

    public void setClip(int x, int y, int width, int height) {
        this.setClipRectNative(x, y, width, height);
    }

    public Shape getClip() {
        return this.getClipNative().getPath();
    }

    public native Rectangle getClipBounds();

    public void setClip(Shape clip) {
        if (clip == null) {
            this.resetClip();
        } else {
            this.setClipNative(new QPainterPath(clip));
        }
    }

    public void draw(Shape s) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(s));
        } else {
            this.fillNative(new QPainterPath(this.currentStroke.createStrokedShape(s)));
        }
    }

    public void fill(Shape s) {
        this.fillNative(new QPainterPath(s));
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(x1, y1, x2, y2, true));
        } else {
            this.draw(new Line2D.Double(x1, y1, x2, y2));
        }
    }

    public void drawRect(int x, int y, int width, int height) {
        if (this.nativeStroking) {
            this.drawNative(new QPainterPath(x, y, width, height));
        } else {
            this.fillNative(new QPainterPath(this.currentStroke.createStrokedShape(new Rectangle2D.Double(x, y, width, height))));
        }
    }

    public void fillRect(int x, int y, int width, int height) {
        this.fillNative(new QPainterPath(x, y, width, height));
    }

    public void clearRect(int x, int y, int width, int height) {
        Color c = this.color;
        this.setColor(this.bgcolor);
        this.fillRect(x, y, width, height);
        this.setColor(c);
    }

    public void drawRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.draw(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void fillRoundRect(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        this.fill(new RoundRectangle2D.Double(x, y, width, height, arcWidth, arcHeight));
    }

    public void drawOval(int x, int y, int width, int height) {
        this.draw(new Ellipse2D.Double(x, y, width, height));
    }

    public void fillOval(int x, int y, int width, int height) {
        this.fill(new Ellipse2D.Double(x, y, width, height));
    }

    public void drawArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
        this.draw(new Arc2D.Double(x, y, width, height, arcStart, arcAngle, 0));
    }

    public void fillArc(int x, int y, int width, int height, int arcStart, int arcAngle) {
        this.fill(new Arc2D.Double(x, y, width, height, arcStart, arcAngle, 1));
    }

    public void drawPolyline(int[] xPoints, int[] yPoints, int npoints) {
        int i = 0;
        while (i < npoints - 1) {
            this.drawLine(xPoints[i], yPoints[i], xPoints[i + 1], yPoints[i + 1]);
            ++i;
        }
    }

    public void drawPolygon(int[] xPoints, int[] yPoints, int npoints) {
        this.draw(new Polygon(xPoints, yPoints, npoints));
    }

    public void fillPolygon(int[] xPoints, int[] yPoints, int npoints) {
        this.fill(new Polygon(xPoints, yPoints, npoints));
    }

    public native void fill3DRect(int var1, int var2, int var3, int var4, boolean var5);

    public native void draw3DRect(int var1, int var2, int var3, int var4, boolean var5);

    public void drawString(String string, int x, int y) {
        this.drawStringNative(string, x, y);
    }

    public void drawString(String string, float x, float y) {
        this.drawStringNative(string, x, y);
    }

    public void drawString(AttributedCharacterIterator ci, int x, int y) {
        String s = "";
        char c = ci.first();
        while (c != (char)-1) {
            s = s + c;
            c = ci.next();
        }
        this.drawString(s, x, y);
    }

    public void drawString(AttributedCharacterIterator ci, float x, float y) {
        String s = "";
        char c = ci.first();
        while (c != (char)-1) {
            s = s + c;
            c = ci.next();
        }
        this.drawString(s, x, y);
    }

    public void drawGlyphVector(GlyphVector v, float x, float y) {
        throw new RuntimeException("Not implemented");
    }

    public boolean drawImage(Image image, AffineTransform Tx, ImageObserver obs) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, new QMatrix(Tx), obs);
        }
        return new QtImage(image.getSource()).drawImage(this, new QMatrix(Tx), obs);
    }

    public boolean drawImage(Image image, int x, int y, Color bgcolor, ImageObserver observer) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, x, y, bgcolor, observer);
        }
        return new QtImage(image.getSource()).drawImage(this, x, y, bgcolor, observer);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, Color bgcolor, ImageObserver observer) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
        }
        return new QtImage(image.getSource()).drawImage(this, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, bgcolor, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, Color bgcolor, ImageObserver observer) {
        if (image instanceof QtImage) {
            return ((QtImage)image).drawImage(this, x, y, width, height, bgcolor, observer);
        }
        return new QtImage(image.getSource()).drawImage(this, x, y, width, height, bgcolor, observer);
    }

    public boolean drawImage(Image image, int x, int y, int width, int height, ImageObserver observer) {
        return this.drawImage(image, x, y, width, height, null, observer);
    }

    public boolean drawImage(Image image, int x, int y, ImageObserver observer) {
        return this.drawImage(image, x, y, null, observer);
    }

    public boolean drawImage(Image image, int dx1, int dy1, int dx2, int dy2, int sx1, int sy1, int sx2, int sy2, ImageObserver observer) {
        return this.drawImage(image, dx1, dy1, dx2, dy2, sx1, sy1, sx2, sy2, null, observer);
    }

    public AffineTransform getTransform() {
        return new AffineTransform(this.xform);
    }

    public void setTransform(AffineTransform Tx) {
        this.xform = new AffineTransform(Tx);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void rotate(double theta) {
        this.xform.rotate(theta);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void rotate(double theta, double x, double y) {
        this.xform.rotate(theta, x, y);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void scale(double sx, double sy) {
        this.xform.scale(sx, sy);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void shear(double shx, double shy) {
        this.xform.shear(shx, shy);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void transform(AffineTransform Tx) {
        this.xform.concatenate(Tx);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void translate(double tx, double ty) {
        this.xform.translate(tx, ty);
        this.setQtTransform(new QMatrix(this.xform));
    }

    public void translate(int x, int y) {
        this.translate((double)x, (double)y);
    }

    public void setStroke(Stroke s) {
        try {
            QPen pen = new QPen(s);
            this.nativeStroking = true;
            this.setNativeStroke(pen);
            this.setColor(this.color);
        }
        catch (IllegalArgumentException e) {
            this.nativeStroking = false;
        }
        this.currentStroke = s;
    }

    public Stroke getStroke() {
        return this.currentStroke;
    }

    public void setComposite(Composite comp) {
        if (comp == null) {
            this.setNativeComposite(3);
            return;
        }
        if (comp instanceof AlphaComposite) {
            if (((AlphaComposite)comp).getRule() != 12) {
                this.setAlpha(((AlphaComposite)comp).getAlpha());
            }
        } else {
            throw new UnsupportedOperationException("We don't support custom composites yet.");
        }
        this.setNativeComposite(((AlphaComposite)comp).getRule());
        this.composite = comp;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public void setPaint(Paint p) {
        if (p == null) {
            return;
        }
        this.currentPaint = p;
        if (p instanceof GradientPaint) {
            GradientPaint lg = (GradientPaint)p;
            this.setLinearGradient(lg.getColor1().getRed(), lg.getColor1().getGreen(), lg.getColor1().getBlue(), lg.getColor2().getRed(), lg.getColor2().getGreen(), lg.getColor2().getBlue(), lg.getPoint1().getX(), lg.getPoint1().getY(), lg.getPoint2().getX(), lg.getPoint2().getY(), lg.isCyclic());
            return;
        }
        if (p instanceof Color) {
            this.setColor((Color)p);
            return;
        }
        throw new UnsupportedOperationException("We don't support custom paints yet.");
    }

    public Paint getPaint() {
        return this.currentPaint;
    }

    public void addRenderingHints(Map hints) {
        this.renderingHints.putAll(hints);
    }

    public Object getRenderingHint(RenderingHints.Key hintKey) {
        return this.renderingHints.get(hintKey);
    }

    public RenderingHints getRenderingHints() {
        return new RenderingHints(this.renderingHints);
    }

    public void setRenderingHints(Map hints) {
        this.renderingHints = new RenderingHints(hints);
        this.updateRenderingHints();
    }

    public void setRenderingHint(RenderingHints.Key hintKey, Object hintValue) {
        this.renderingHints.put(hintKey, hintValue);
        this.updateRenderingHints();
    }

    private final void updateRenderingHints() {
    }

    public FontRenderContext getFontRenderContext() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void drawRenderableImage(RenderableImage image, AffineTransform xform) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void drawRenderedImage(RenderedImage image, AffineTransform xform) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    public void drawImage(BufferedImage image, BufferedImageOp op, int x, int y) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    QtGraphics() {
    }

    QtGraphics(QtGraphics parent) {
        this.cloneNativeContext(parent);
        this.setFont(parent.getFont());
        this.setAlpha(parent.currentAlpha);
        this.setBackground(parent.getBackground());
        this.setColor(parent.getColor());
        this.initialClip = parent.getClip();
        this.setClip(this.initialClip);
        this.setTransform(parent.getTransform());
        this.setStroke(parent.getStroke());
        this.setComposite(parent.getComposite());
        this.setPaint(parent.getPaint());
        this.setRenderingHints(parent.getRenderingHints());
    }
}

