#############################################################################
##
#W  smgideal.gd              GAP library                     Robert Arthur
##
#H  @(#)$Id: smgideal.gd,v 4.11 2002/04/15 10:05:22 sal Exp $
##
#Y  Copyright (C)  1996,  Lehrstuhl D fuer Mathematik,  RWTH Aachen,  Germany
#Y  (C) 1998 School Math and Comp. Sci., University of St.  Andrews, Scotland
#Y  Copyright (C) 2002 The GAP Group
##
##  This file contains declarations relating to semigroup ideals.
##
Revision.smgideal_gd :=
    "@(#)$Id: smgideal.gd,v 4.11 2002/04/15 10:05:22 sal Exp $";




#############################################################################
##
#R  IsSemigroupIdealEnumRep( <R> )
##
##  Representation for semigroup ideal enumerators.
##  Note: this *does not* imply that the UnderlyingDomain of the enumerator
##  is a semigroup ideal, only that the object being enumerated is
##  being enumerated as a semigroup ideal. In particular, semigroups
##  are generally enumerated as a right or left ideal of themselves.
##
##  currentlist : the list of elements calculated so far
##  gens : the list of acting generators (generators of the acting domain)
##  nextelm : the index in currentlist of the next element whose
##    images under the action of the generators has not yet been computed.
##  orderedlist : currentlist AsSSortedList - to speed decision of whether
##    an element has already been computed.
##
DeclareRepresentation("IsSemigroupIdealEnumRep",
  IsDomainEnumerator and IsAttributeStoringRep,
  ["currentlist", "gens", "nextelm", "orderedlist"]);

#############################################################################
##
#O  SemigroupIdealByGenerators(<S>, <gens>)
##
##  <S> is a semigroup, <gens> is a list of elements of <S>.
##  Returns the two-sided ideal of <S> generated by <gens>.
##
DeclareSynonym("SemigroupIdealByGenerators", MagmaIdealByGenerators );

#############################################################################
##
#P  IsLeftSemigroupIdeal(<I>)
#P  IsRightSemigroupIdeal(<I>)
#P  IsSemigroupIdeal(<I>)
##  
##  Categories of semigroup ideals.
##
DeclareProperty("IsLeftSemigroupIdeal", IsLeftMagmaIdeal );
DeclareProperty("IsRightSemigroupIdeal", IsRightMagmaIdeal );
DeclareProperty("IsSemigroupIdeal", IsMagmaIdeal );

#############################################################################
##
#C  IsRightSemigroupIdealEnumerator( <obj> )
#C  IsLeftSemigroupIdealEnumerator( <obj> )
#C  IsSemigroupIdealEnumerator( <obj> )
##
##  Categories for generic *semigroup ideal enumerators*. 
##  Note: this *does not* imply that the UnderlyingDomain of the enumerator
##  is a semigroup ideal, only that the object being enumerated is
##  being enumerated as a semigroup ideal. In particular, semigroups
##  are generally enumerated as a right or left ideal of themselves.
##
DeclareCategory("IsRightSemigroupIdealEnumerator", IsDomainEnumerator);
DeclareCategory("IsLeftSemigroupIdealEnumerator", IsDomainEnumerator);
DeclareCategory("IsSemigroupIdealEnumerator", IsDomainEnumerator);



#############################################################################
##
#A  ReesCongruenceOfSemigroupIdeal( <I> )
##
##  A two sided ideal <I> of a semigroup <S>  defines a congruence on 
##  <S> given by $\Delta \cup I \times I$.
##
DeclareAttribute("ReesCongruenceOfSemigroupIdeal", IsMagmaIdeal);



#############################################################################
##
#E  smgideal.gd . . . . . . . . . . . . . . . . . . . . . . . . . . ends here
##
