$NetBSD: patch-CMakeLists__Dependencies.cmake,v 1.2 2022/09/29 00:17:01 markd Exp $

* Find Qt5
* CMAKE_MODULE_PATH is not a single value, it can be a list.

--- CMakeLists_Dependencies.cmake.orig	2022-01-23 16:16:42.000000000 +0000
+++ CMakeLists_Dependencies.cmake
@@ -10,31 +10,31 @@ if (NOT WANT_QT6)
 	message(STATUS "Qt5 Requested")
 	set(QT_MIN_VERSION "5.14.0")
 	add_compile_definitions(QT_DISABLE_DEPRECATED_BEFORE=0x050E00)
-	find_package(Qt5Core ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS Core REQUIRED)
 	if(NOT Qt5Core_FOUND)
 		message(FATAL_ERROR "ERROR: No QT 5 found")
 	endif()
-	find_package(Qt5Widgets ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS Widgets REQUIRED)
 	if(NOT Qt5Widgets_FOUND)
 		message(FATAL_ERROR "ERROR: No QT Widgets found")
 	endif()
-	find_package(Qt5Gui ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS Gui REQUIRED)
 	if(NOT Qt5Gui_FOUND)
 		message(FATAL_ERROR "ERROR: No Qt5Gui found")
 	endif()
-	find_package(Qt5Xml ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS Xml REQUIRED)
 	if(NOT Qt5Xml_FOUND)
 		message(FATAL_ERROR "ERROR: No QT 5 XML found")
 	endif()
-	find_package(Qt5Network ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS Network REQUIRED)
 	if(NOT Qt5Network_FOUND)
 		message(FATAL_ERROR "ERROR: No Qt5Network found")
 	endif()
-	find_package(Qt5OpenGL ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS OpenGL REQUIRED)
 	if(NOT Qt5OpenGL_FOUND)
 		message(FATAL_ERROR "ERROR: No Qt5OpenGL found")
 	endif()
-	find_package(Qt5LinguistTools ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS LinguistTools REQUIRED)
 	if(NOT Qt5LinguistTools_FOUND)
 		message(FATAL_ERROR "ERROR: No Qt5LinguistTools found")
 	endif()
@@ -44,7 +44,7 @@ if (NOT WANT_QT6)
 	#else()
 	#    message(FATAL_ERROR "ERROR: No Qt5Quick found")
 	#endif()
-	find_package(Qt5PrintSupport ${QT_MIN_VERSION} REQUIRED)
+	find_package(Qt5 COMPONENTS PrintSupport REQUIRED)
 	if(NOT Qt5PrintSupport_FOUND)
 		message(FATAL_ERROR "ERROR: No Qt5PrintSupport found")
 	endif()
@@ -108,8 +108,8 @@ if (WIN32)
 	# On win32 we can use Qt's zlib and libpng, so we use some
 	# custom cmake includes. This permits us to honour the
 	# USE_QT_ZLIB_PNGLIB flag if passed.
-	set(PNG_DIR ${CMAKE_MODULE_PATH})
-	set(ZLIB_DIR ${CMAKE_MODULE_PATH})
+	set(PNG_DIR "${CMAKE_SOURCE_DIR}/cmake/modules")
+	set(ZLIB_DIR "${CMAKE_SOURCE_DIR}/cmake/modules")
 endif()
 find_package(ZLIB REQUIRED)
 if (ZLIB_FOUND)
@@ -193,6 +193,7 @@ endif()
 #>> FreeType2
 
 set(cairo_DIR ${CMAKE_MODULE_PATH})
+set(cairo_DIR "${CMAKE_SOURCE_DIR}/cmake/modules")
 find_package(cairo REQUIRED)
 if(cairo_FOUND)
 	set(HAVE_CAIRO ON)
@@ -224,7 +225,7 @@ endif()
 #>>LibXML2
 
 #<<LittleCMS
-set(LCMS_DIR ${CMAKE_MODULE_PATH})
+set(LCMS_DIR "${CMAKE_SOURCE_DIR}/cmake/modules")
 find_package(LCMS2 REQUIRED)
 if(LCMS2_FOUND)
 	set(HAVE_LCMS2 ON)
@@ -285,7 +286,7 @@ endif()
 
 #<< GraphicsMagick for image import
 if (WANT_GRAPHICSMAGICK)
-	set(GMAGICK_DIR ${CMAKE_MODULE_PATH})
+	set(GMAGICK_DIR "${CMAKE_SOURCE_DIR}/cmake/modules")
 	pkg_check_modules(GMAGICK GraphicsMagick)
 	# find_package(GMAGICK)
 	if(GMAGICK_FOUND)
