$NetBSD: patch-messages_make_message_src.sh,v 1.1 2023/02/13 13:51:57 manu Exp $

Use all ICU generated object files to avoit a missing symbol crash on amd64

--- messages/make_message_src.sh.orig	2019-03-15 05:24:46.000000000 +0100
+++ messages/make_message_src.sh	2022-03-22 17:16:40.802122202 +0100
@@ -77,19 +77,22 @@
 			;;
 		NetBSD)
 			# generate libtool archive for later linking
 			mv lib${BASENAME}.a ../../lib${BASENAME}_dat.a
-			OBJFILE=${BASENAME}_dat.o
-			LTFILE=${BASENAME}_dat.lo
 			mkdir -p .libs ../../.libs
-			mv ${OBJFILE} .libs
+			LTFILES=""
 			LTVERS=`libtool --version | 
 			    sed -e 's/^\([^ ]*\) (GNU \(.*\)) \(.*\)$$/\1 - GNU \2 \3/' -e q` 
-			echo "# ${OBJFILE} - a libtool object file" > ${LTFILE}
-			echo "# Generated by ${LTVERS}" >> ${LTFILE}
-			echo "pic_object='.libs/${OBJFILE}'" >> ${LTFILE}
-			echo "non_pic_object=none" >> ${LTFILE}
-			libtool --mode=link --tag=CC cc -o ../../lib${BASENAME}_dat.la ${LTFILE}
+			for OBJFILE in *.o ; do 
+				LTFILE=${OBJFILE%.o}.lo
+				mv ${OBJFILE} .libs
+				echo "# ${OBJFILE} - a libtool object file" > ${LTFILE}
+				echo "# Generated by ${LTVERS}" >> ${LTFILE}
+				echo "pic_object='.libs/${OBJFILE}'" >> ${LTFILE}
+				echo "non_pic_object=none" >> ${LTFILE}
+				LTFILES="${LTFILES} ${LTFILE}"
+			done
+			libtool --mode=link --tag=CC cc -o ../../lib${BASENAME}_dat.la ${LTFILES}
 			;;
 		*)
 			mv ${BASENAME}_dat.o ../../lib${BASENAME}_dat.a
 			;;
