/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.ssl;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.net.Socket;
import java.util.Properties;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.core.Logger;
import org.postgresql.core.PGStream;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class MakeSSL {
    public static void convert(PGStream stream, Properties info, Logger logger) throws IOException, PSQLException {
        SSLSocketFactory factory;
        logger.debug("converting regular socket connection to ssl");
        String classname = info.getProperty("sslfactory");
        if (classname == null) {
            factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        } else {
            Object[] args = new Object[]{info.getProperty("sslfactoryarg")};
            try {
                Constructor<?> ctor;
                Class<?> factoryClass = Class.forName(classname);
                try {
                    ctor = factoryClass.getConstructor(String.class);
                }
                catch (NoSuchMethodException nsme) {
                    ctor = factoryClass.getConstructor(null);
                    args = null;
                }
                factory = (SSLSocketFactory)ctor.newInstance(args);
            }
            catch (Exception e) {
                throw new PSQLException(GT.tr("The SSLSocketFactory class provided {0} could not be instantiated.", classname), PSQLState.CONNECTION_FAILURE, (Throwable)e);
            }
        }
        Socket newConnection = factory.createSocket(stream.getSocket(), stream.getHost(), stream.getPort(), true);
        stream.changeSocket(newConnection);
    }
}

