""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from csv import CSV
from dbhandler import DbHandler
from log import *

class CSVDB(CSV,DbHandler):
	def __init__(self, DBNAME, DBHOST, DBPORT, DBUSER, DBPWD, file, log = LOG(), separator = '|', name = 'CSVDB', debug = None):
		CSV.__init__(self, file, log, separator)
		DbHandler.__init__(self, DBNAME, DBUSER, DBPWD, DBHOST, DBPORT, log, name, debug)

	def load(self, preSQL = 'begin transaction', postSQL = 'end transaction'):
		if (preSQL != ''): self.query(preSQL)
		CSV.load(self)
	 	if (postSQL != ''): self.query(postSQL)

	def chargeCSV(self, preSQL = 'begin transaction', postSQL = 'end transaction'): # here for backward compatibility (deprecated)
		self.load(preSQL,postSQL)
		
	def load_line(self, line): # need to be overloaded
		self.chargeLigne(line) # here for backward compatibility
		
	def chargeLigne(self, ligne): # here for backward compatibility (deprecated)
		print 'CSVDB ?? ',line
