#!/usr/bin/env python

""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""

from common import *
from pgtmlgraph import *
from pgmlgraph import *
from string import *
import getopt
import sys
from urllib import *

def main():
	"""
	pgtml2zope.py output sql schema

	usage: pgtml2zope.py -s <pgml schema file> -f <pgtml view file> [-h] 
	-h : this help
	-s : pgml schema file
	-f : pgtml file
	-o : sql output

	"""
	
	try:
		opts, args = getopt.getopt(sys.argv[1:], 's:o:f:h')
	except getopt.error, msg:
		usage(msg)

	pgmlFilename=''
	pgtmlFilename=''
	sqlFilename=''

	for o, a in opts:
		if o == '-f': pgtmlFilename = a
		if o == '-s': pgmlFilename = a
		if o == '-h': usage(main.__doc__)
		if o == '-o': sqlFilename = a

	if not pgmlFilename: usage(main.__doc__,'error : missing database pgml file')
	if not pgtmlFilename: usage(main.__doc__,'error : missing ptgml file')

	b = PgmlGraph()
	b.read(pgmlFilename)
	b.simplify()

	g = PgtmlGraph(b)
	g.read(pgtmlFilename)
	
	output = stdout
	if sqlFilename:
		output = open(sqlFilename,'w')
		
	output.write("manage_addProduct/Pgt/add_pgt?my_id=%s" % g.name)
	select = g.get_select()
	output.write("&select_query=%s" % quote_plus(select[0]))
	
	insert = g.get_insert()
	output.write("&insert_args=%s" % quote_plus(joinfields(insert[3], ' ')))
	output.write("&insert_query=SELECT+%s(%s)" % (quote_plus(insert[1]), quote_plus(joinfields(map(lambda f:"'<dtml-var %s>'"%f, insert[3]),','))))

	update = g.get_update()
	output.write("&update_args=%s" % quote_plus(joinfields(update[3], ' ')))
	output.write("&update_query=SELECT+%s(%s)" % (quote_plus(update[1]), quote_plus(joinfields(map(lambda f:"'<dtml-var %s>'"%f, update[3]),','))))

if __name__ == '__main__':
	main()

