#! /bin/bash

case $DEBUG in
  1) set -x
     ;;
  *)
     ;;
esac

error() { # juste pour usage
		echo $1 1>&2
}

usage() {
		error "usage : create-user.sh [-h] -H <host> -u <new user> -p <new password> -U <admin user> -P <admin password> -l <log file> [ -a ] [ -d ]"
		error "example : create-user.sh -H bonnie -u pimentech -p \"\" -U postgres -P pass -l create-user.log"
}

createdb="-D"
createuser="-A"

while true
do
  case $1 in
	-H) host="$2"
		shift 2
		;;
    -U)	user="$2"
        shift 2
        ;;
    -P) password="$2"
        shift 2
        ;;
    -u)	newuser="$2"
        shift 2
        ;;
    -p) newpassword="$2"
        shift 2
        ;;
	-d) createdb="-d"
		shift 1
		;;
	-a) createuser="-a"
		shift 1
		;;
	-l) logfile="$2"
		shift 2
		;;
    -h) usage
		exit 0
		;;
     *)
		break
		;;
  esac
done

if [ -z "$host" -o -z "$user" -o -z "$logfile" ] 
then
		usage
		exit 1
fi

date=`date '+%d-%m-%Y'`
error() {
		echo "ERROR:create-user.sh:$date: $1" 1>&2
		echo "ERROR:create-user.sh:$date: $1" >> $logfile
}

expect -- <<EOC

#	exp_internal -f $logfile 0

 	log_user 0

	spawn -noecho createuser $createuser $createdb -h $host $newuser -U $user -W -P

	expect {
		"Enter password for user \"$newuser\": " { send -- "$newpassword\r" }
		timeout { send_error -- "timeout detected\n" }
	}

	expect {
		"Enter it again: " { send -- "$newpassword\r" }
		timeout { send_error -- "timeout detected\n" }
	}

	expect {
		"Password: " { send -- "$password\r" }
		timeout { send_error -- "timeout detected on login\n" }
	}

	expect {
		"\nCREATE USER" { send_user -- "CREATE USER\n" }
		-re "\n(ERROR.*)\r" { send_error -- "\$expect_out(1,string)\n" }
		-re "\n(psql: Password authentication failed for user.*)\r" { send_error -- "\$expect_out(1,string)\n" }
	}

    exit [ lindex [ wait ] 3 ]

EOC

err=$?

if [ $err -ne 0 ]
then
	error "cannot create $newuser@$host"
fi

exit $err
