--
-- PostgreSQL database dump
--

SET search_path = public, pg_catalog;

--
-- TOC entry 8 (OID 22995)
-- Name: customer; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE customer (
    id integer DEFAULT nextval('customer_id_seq'::text) NOT NULL,
    name text,
    street text,
    post_code text,
    town text,
    country text,
    telephone text,
    e_mail text
);


--
-- TOC entry 9 (OID 23001)
-- Name: product; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE product (
    id integer DEFAULT nextval('product_id_seq'::text) NOT NULL,
    name text,
    description text,
    nr_in_stock integer,
    price numeric(8,2)
);


--
-- TOC entry 10 (OID 23007)
-- Name: order; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE "order" (
    invoice integer,
    product integer,
    nr integer
);


--
-- TOC entry 11 (OID 23009)
-- Name: invoice; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE invoice (
    id integer DEFAULT nextval('invoice_id_seq'::text) NOT NULL,
    customer integer,
    date date
);


--
-- TOC entry 12 (OID 23012)
-- Name: pfm_attribute; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_attribute (
    attribute text,
    typeofattrib text,
    typeofget text,
    sqlselect text,
    nr integer,
    form text,
    valuelist text
);


--
-- TOC entry 13 (OID 23017)
-- Name: pfm_form; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_form (
    name text NOT NULL,
    tablename text,
    showform boolean DEFAULT 't',
    "view" boolean DEFAULT 'f',
    sqlselect text,
    sqlfrom text,
    groupby_having text,
    help text
);


--
-- TOC entry 14 (OID 23024)
-- Name: pfm_link; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_link (
    linkname text,
    sqlwhere text,
    orderby text,
    displayattrib text,
    fromform text,
    toform text
);


--
-- TOC entry 15 (OID 23029)
-- Name: pfm_report; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_report (
    name text NOT NULL,
    description text,
    table_or_view text,
    sqlwhere text,
    orderby text
);


--
-- TOC entry 16 (OID 23034)
-- Name: pfm_section; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_section (
    report text,
    "level" integer,
    fieldlist text,
    layout text
);


--
-- TOC entry 17 (OID 23039)
-- Name: pfm_value; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_value (
    value text,
    description text,
    valuelist text
);


--
-- TOC entry 18 (OID 23044)
-- Name: pfm_value_list; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE pfm_value_list (
    name text NOT NULL
);


--
-- TOC entry 19 (OID 23051)
-- Name: pfm_table; Type: VIEW; Schema: public; Owner: wim
--

CREATE VIEW pfm_table AS
    SELECT n.nspname AS "Schema", c.relname AS "Name", CASE WHEN (c.relkind = 'r'::"char") THEN 'table'::text WHEN (c.relkind = 'v'::"char") THEN 'view'::text WHEN (c.relkind = 'i'::"char") THEN 'index'::text WHEN (c.relkind = 'S'::"char") THEN 'sequence'::text WHEN (c.relkind = 's'::"char") THEN 'special'::text ELSE NULL::text END AS "Type", u.usename AS "Owner" FROM ((pg_class c LEFT JOIN pg_user u ON ((u.usesysid = c.relowner))) LEFT JOIN pg_namespace n ON ((n.oid = c.relnamespace))) WHERE ((((((c.relkind = 'r'::"char") OR (c.relkind = 'v'::"char")) OR (c.relkind = 'S'::"char")) OR (c.relkind = ''::"char")) AND ((n.nspname <> 'pg_catalog'::name) AND (n.nspname <> 'pg_toast'::name))) AND pg_table_is_visible(c.oid)) ORDER BY n.nspname, c.relname;


--
-- TOC entry 20 (OID 23055)
-- Name: pfm_table_def; Type: VIEW; Schema: public; Owner: wim
--

CREATE VIEW pfm_table_def AS
    SELECT c.relname AS "Tablename", a.attname AS "Attribute", format_type(a.atttypid, a.atttypmod) AS "Type" FROM pg_class c, pg_attribute a WHERE ((c.oid = a.attrelid) AND (a.attnum > 0)) ORDER BY c.relname;


--
-- TOC entry 21 (OID 23058)
-- Name: pfm_table_report; Type: VIEW; Schema: public; Owner: wim
--

CREATE VIEW pfm_table_report AS
    SELECT t."Schema", t."Name", t."Type" AS "RelTyp", t."Owner", d."Attribute", d."Type" FROM pfm_table t, pfm_table_def d WHERE (t."Name" = d."Tablename") ORDER BY t."Schema", t."Name";


--
-- TOC entry 2 (OID 23059)
-- Name: customer_id_seq; Type: SEQUENCE; Schema: public; Owner: wim
--

CREATE SEQUENCE customer_id_seq
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 22 (OID 23063)
-- Name: test; Type: TABLE; Schema: public; Owner: wim
--

CREATE TABLE test (
    id serial NOT NULL,
    rest text
);


--
-- TOC entry 4 (OID 23069)
-- Name: invoice_id_seq; Type: SEQUENCE; Schema: public; Owner: wim
--

CREATE SEQUENCE invoice_id_seq
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 6 (OID 23071)
-- Name: product_id_seq; Type: SEQUENCE; Schema: public; Owner: wim
--

CREATE SEQUENCE product_id_seq
    START 1
    INCREMENT 1
    MAXVALUE 9223372036854775807
    MINVALUE 1
    CACHE 1;


--
-- TOC entry 23 (OID 23075)
-- Name: invoice_report; Type: VIEW; Schema: public; Owner: wim
--

CREATE VIEW invoice_report AS
    SELECT c.id AS cust_id, c.name AS customer, c.street, c.post_code, c.town, c.country, c.telephone, c.e_mail, i.id AS invoice, i.date, o.nr, o.product AS prod_nr, p.name AS product, p.price, (((o.nr)::numeric * p.price))::numeric(9,2) AS total FROM customer c, invoice i, "order" o, product p WHERE (((c.id = i.customer) AND (i.id = o.invoice)) AND (o.product = p.id)) ORDER BY c.id, i.id;


--
-- TOC entry 24 (OID 23078)
-- Name: report_view; Type: VIEW; Schema: public; Owner: wim
--

CREATE VIEW report_view AS
    SELECT r.name, r.description, r.table_or_view, r.sqlwhere, r.orderby, s."level", s.fieldlist, s.layout FROM pfm_report r, pfm_section s WHERE (r.name = s.report);


--
-- Data for TOC entry 35 (OID 22995)
-- Name: customer; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY customer (id, name, street, post_code, town, country, telephone, e_mail) FROM stdin;
6	Nancy Van Cauwenberghe	Azalealaan 23	9520	Lokeren	Belgi	09 223 45 67	n.vcb@pi.be
3	Frans Van Langenacker	Transvaalstraat 34	2030	Antwerpen	Belgi	03 326 25 60	fvla@vt4.be
2	Nelly Peeters	Grote Markt 24	7023	Sint-Niklaas	Belgi	03 911 22 45	n.peeters@pandora.be
9	Staf De Wilde	Lange Lepelstraat 45	2000	Antwerpen	Belgi	03 233 62 60	
5	Jacky Verelst	Kesselsebaan 45	2520	Emblem	Belgi	03 234 56 32	jacky.verelst@skynet.be
10	Dirk Versmissen	Draaiboom 4	2260	Wommelgem	Belgi	03 465 32 67	dirkv@vt4.be
8	Nestor Stassyns	Calle Salinas 343	2000	Buenos Aires	Argentina		nestor.stassicin@argentel.ag
\.


--
-- Data for TOC entry 36 (OID 23001)
-- Name: product; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY product (id, name, description, nr_in_stock, price) FROM stdin;
1	SuSE 8.2 personal	Linux distribution	20	23.20
2	SuSE 8.2 professional	Linux distribution	12	81.50
3	Windows XP - new PC	Microsoft windows XP for new PC	12	99.50
4	Windows XP upgrade	Microsoft windows not bound to a particular PC	3	399.00
5	Tcl/Tk	Tool Command Language and Toolkit	12	12.30
6	postgreSQL	Relational database server	23	15.60
7	Open Office	CD met Office pakekt voor Windows en Linux	12	10.00
\.


--
-- Data for TOC entry 37 (OID 23007)
-- Name: order; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY "order" (invoice, product, nr) FROM stdin;
6	6	2
6	5	2
11	5	12
11	1	12
1	5	3
12	2	1
11	6	5
15	7	3
15	6	2
15	3	4
11	3	3
1	7	2
16	5	2
1	1	1
1	6	4
\.


--
-- Data for TOC entry 38 (OID 23009)
-- Name: invoice; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY invoice (id, customer, date) FROM stdin;
11	8	2003-12-17
12	8	2003-12-18
1	6	2003-11-11
6	6	2003-12-10
15	8	2004-01-13
16	10	2004-01-14
\.


--
-- Data for TOC entry 39 (OID 23012)
-- Name: pfm_attribute; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_attribute (attribute, typeofattrib, typeofget, sqlselect, nr, form, valuelist) FROM stdin;
layout	taQuoted	tgList		3	pfm_section	layout
linkname	taQuoted	tgDirect		1	pfm_link	none
value	taQuoted	tgDirect	\N	2	pfm_value	none
sqlwhere	taQuoted	tgDirect		4	pfm_link	none
orderby	taQuoted	tgDirect		5	pfm_link	none
displayattrib	taQuoted	tgDirect		6	pfm_link	none
description	taQuoted	tgDirect		3	pfm_value	none
name	taQuoted	tgDirect		1	pfm_report	none
description	taQuoted	tgDirect		2	pfm_report	none
sqlwhere	taQuoted	tgDirect		4	pfm_report	none
report	taQuoted	tgLink	select name, description from pfm_report order by name	1	pfm_section	none
level	taNotQuoted	tgDirect		2	pfm_section	none
fieldlist	taQuoted	tgDirect		4	pfm_section	none
table_or_view	taQuoted	tgLink	SELECT "Name" FROM pfm_table ORDER BY "Name"	3	pfm_report	none
Schema	taQuoted	tgDirect		1	pfm_table	none
Name	taQuoted	tgDirect		2	pfm_table	none
Type	taQuoted	tgDirect		3	pfm_table	none
Owner	taQuoted	tgDirect		4	pfm_table	none
Attribute	taQuoted	tgDirect		2	pfm_table_def	none
Type	taQuoted	tgDirect		3	pfm_table_def	none
Tablename	taQuoted	tgLink	SELECT "Name" FROM pfm_table ORDER BY "Name"	1	pfm_table_def	none
name	taQuoted	tgDirect		1	pfm_form	none
tablename	taQuoted	tgLink	SELECT "Name" FROM pfm_table ORDER BY "Name"	2	pfm_form	none
form	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	1	pfm_attribute	none
fromform	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	2	pfm_link	none
toform	taQuoted	tgLink	SELECT name FROM pfm_form ORDER BY name	3	pfm_link	none
valuelist	taQuoted	tgLink	SELECT name FROM pfm_value_list ORDER BY name	1	pfm_value	none
name	taQuoted	tgDirect		1	pfm_value_list	none
id	taNotQuoted	tgDirect		1	customer	none
name	taQuoted	tgDirect		2	customer	none
street	taQuoted	tgDirect		3	customer	none
post_code	taQuoted	tgDirect		4	customer	none
town	taQuoted	tgDirect		5	customer	none
country	taQuoted	tgDirect		6	customer	none
telephone	taQuoted	tgDirect		7	customer	none
e_mail	taQuoted	tgDirect		8	customer	none
id	taNotQuoted	tgDirect		1	invoice	none
customer	taNotQuoted	tgLink	SELECT id, name FROM customer ORDER BY name	2	invoice	none
date	taQuoted	tgDirect		3	invoice	none
invoice	taNotQuoted	tgLink	SELECT i.id, i."date", c.name FROM invoice i, customer c WHERE (c.id = i.customer) ORDER BY i."date"	1	order	none
id	taNotQuoted	tgDirect		1	product	none
name	taQuoted	tgDirect		2	product	none
description	taQuoted	tgDirect		3	product	none
nr_in_stock	taNotQuoted	tgDirect		4	product	none
price	taNotQuoted	tgDirect		5	product	none
orderby	taQuoted	tgDirect		5	pfm_report	none
sqlselect	taQuoted	tgDirect		3	pfm_form	none
sqlfrom	taQuoted	tgDirect		4	pfm_form	none
attribute	taQuoted	tgDirect		6	pfm_attribute	none
typeofattrib	taQuoted	tgList		7	pfm_attribute	typeofattribute
typeofget	taQuoted	tgList	\N	8	pfm_attribute	typeofget
sqlselect	taQuoted	tgDirect		9	pfm_attribute	none
valuelist	taQuoted	tgLink	SELECT name FROM pfm_value_list ORDER BY name	10	pfm_attribute	none
nr	taNotQuoted	tgDirect		11	pfm_attribute	none
cust_name	taQuoted	tgReadOnly		4	invoice	none
product	taNotQuoted	tgLink	SELECT id, name FROM product ORDER BY name	4	order	none
prod_name	taNotQuoted	tgReadOnly		5	order	none
nr	taNotQuoted	tgDirect		6	order	none
date	taNotQuoted	tgReadOnly		2	order	none
customer	taNotQuoted	tgReadOnly		3	order	none
unit_price	taNotQuoted	tgReadOnly		7	order	none
total_price	taNotQuoted	tgReadOnly		8	order	none
invoice_total	taNotQuoted	tgReadOnly		5	invoice	none
groupby_having	taQuoted	tgDirect		5	pfm_form	none
showform	taQuoted	tgList		6	pfm_form	boolean
view	taQuoted	tgList		7	pfm_form	boolean
help	taQuoted	tgDirect		8	pfm_form	none
\.


--
-- Data for TOC entry 40 (OID 23017)
-- Name: pfm_form; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_form (name, tablename, showform, "view", sqlselect, sqlfrom, groupby_having, help) FROM stdin;
product	product	t	f	oid, id, name, description, nr_in_stock, price	product	\N	\N
pfm_link	pfm_link	f	f	oid, linkname, sqlwhere, orderby, displayattrib, fromform, toform	pfm_link	\N	The table "pfm_link" defines all the links between forms.\n\nIt has the following attributes:\n\n    - fromform : the name of the form from which the link\n      originates;\n\n    - toform : the name of the form to which the link leads;\n\n    - sqlwhere : the "WHERE"-clause of the SQL SELECT statement in\n      which the value of an attribute of the "from"-form may be\n      represented by $(attrib-x), where 'attrib-x' is the name of the\n      attribute;\n\n    - orderby : an 'order by' clause which determines the order of the\n      records in the 'toform';\n\n    - displayattrib : a space separated list of\n      attributes of the 'fromform', the value of which is displayed on\n      the 'toform' to remind the user from which record the link\n      originated.
pfm_value	pfm_value	f	f	oid, value, description, valuelist	pfm_value	\N	The table "pfm_value" contains all the values of the lists defined in\npfm_value_list.\n\nIt has the following attributes:\n\n    - valuelist : the name of the valuelist to which this value belongs\n\n    - value : a character string;\n\n    - description : a description of the value.
pfm_section	pfm_section	f	f	oid, report, level, fieldlist, layout	pfm_section	\N	The table pfm_section contains all the sections of the reports defined\nin pfm_report. A report must have one section at least.\n\nThe table pfm_section has the following attributes:\n\n    - report: the name of the report to which the section belongs\n\n    - level: a number 1, 2, 3, 4, ... which uniquely identifies a\n      section within a report and which also defines an order of the\n      sections.\n\n    - layout: can be "row", "column" or "table".\n\n    - fieldlist: a list of field specifiers, one for each field to be\n      printed in this section of the report (see below for details).\n\nThe fieldlist must be formatted as follows:\n\n{attribute_1 label_1 alignment_1}{attribute_2 label_2 alignment_2}...\n                                        {attribute_N label_N alignment_N}\n\nwhere :\n\n    - attribute_i is the name of the view attribute that has to be\n      printed in the i-th field of this section;\n\n    - label_i is a string which has to be used as label for printing\n      the i-th field of this section; if it consists of more than 1\n      word, it must be delimited by double quotes (" .... ");\n\n    - alignment_i is optional; if present, it is either l or r,\n      indicating whether this field should be left or right aligned.\n\n      Notes :\n\n          o The alignment is optional. If it is left out, left\n            alignment is assumed by default.\n\n          o The alignment only influences the table layout. Column and\n            row layouts are unaffected by the alignment indicator.\n\n          o Multi-line fields, i.e. fields containing more than one\n            line of text are only formatted properly in a column layout.\n\nAll sections of a report, except the last one (i.e. the one with the\nhighest level), are "group level sections".\n\nWhen the report is being generated, first the records resulting from\n"SELECT * FROM table_or_view WHERE sqlwhere ORDER BY orderby" are\nstored internally.\n\nThen the data of the first record are printed, first the fields of the\nlevel 1 section, then the fields of the level 2 section, etc. up to\nthe fields of the last section.\n\nWhen the next records are being printed, the "group level sections"\nare only printed when at least one of the fields belonging to that\nsection has a value different from the corresponding field of the\npreviously printed section of the same level.\n\nOnly the highest level section (which is not a "group level section")\nis printed for all records.\n\nFor every section, the layout can be defined as:\n\n    - row: the section's field labels and field values are\n      printed in one row in a format: label_1 : value_1; label_2 :\n      value_2; ... etc.\n\n    - column: the section's field labels are printed in a first\n      column, the section's field values are printed in a second column.\n\n    - table: the section's values are printed in a table with a\n      column per field and a row per record, the section's
pfm_value_list	pfm_value_list	f	f	oid, name	pfm_value_list	\N	The table "pfm_value_list" contains all the value lists of all the forms.\n\nIts only attribute is\n\n    - name : a name uniquely identifying the value list.
pfm_report	pfm_report	f	f	oid, name, description, table_or_view, sqlwhere, orderby	pfm_report	\N	The table pfm_report defines all the reports for the current data\nbase.\n\npfm_report has the following attributes:\n\n    - name: the name of the report. This is the name that\n      appears in the selection list.\n\n    - description: free text describing the purpose of the\n      report in more detail.\n\n    - table_or_view: the table or view from which the report is\n      derived\n\n    - sqlwhere: an optional "WHERE"-clause (without the word\n      "WHERE") that can be included in the SELECT ... FROM\n      table_or_view. See below for details.\n\n    - orderby : an optional "ORDER BY"-clause (without the words\n      "ORDER BY") that can be included in the SELECT ... FROM\n      table_or_view\n\nThe sqlwhere may contain one or more parameters for which a value is\nrequested at "Run report" time. A parameter in the sqlwhere must be\nformatted as $(parameter_name).\n\nExample:\n\nsqlwhere: (customer='$(customer_name)') AND ("date" >= '$(begin_date)')\n\nWhen the report is run, the user is prompted to enter values for the\nparameters "customer_name" and "begin_date". Then the report data are\nselected from the table_or_view by applying a where clause which is\nobtained from the sqlwhere in which $(customer_name) and $(begin_date)\nare replaced with the values entered by the user.
pfm_table	pfm_table	f	t	"Schema", "Name", "Type", "Owner"	pfm_table	\N	pfm_table is a view which contains a record for every table, view or\nsequence in the database.\n\nIt has the following attributes:\n\n    - Name: the name of a relation (table or view) in the current data\n      base;\n\n    - Schema: the name of the "schema" to which the table, view or\n      sequence belongs;\n\n    - Type: "table", "view" or "sequence"\n\n    - Owner: the owner of the table, view or sequence\n\nThe user can browse the data in pfm_table by opening the form with the\nsame name, but since it is a "view", it is not possible to modify the\ndata directly.
pfm_table_def	pfm_table_def	f	t	"Tablename", "Attribute", "Type"	pfm_table_def	\N	pfm_table def is a view which contains a record for every attribute in\nthe data base.\n\nIt has the following attributes:\n\n    - Tablename: the name of the table to which the attribute belongs;\n\n    - Attribute: the name of the attribute\n\n    - Type: the data type of the attribute\n\nThe user can browse the data in pfm_table by following the\n"Attributes" link from the pfm_table form.
pfm_attribute	pfm_attribute	f	f	oid, attribute, typeofattrib, typeofget, sqlselect, nr, form, valuelist	pfm_attribute	\N	The table "pfm_attribute" defines all the properties of form attributes.\n\nIt has the following attributes:\n\n    - nr: a number which determines the order in which attributes are\n      displayed on the form;\n\n    - form : the "name" of the form to which the attribute\n      belongs;\n\n    - attribute : the name of the attribute; this must be equal to the\n      name of the corresponding attribute of the form's SQL SELECT\n      statement;\n\n    - typeofattrib : the type of attribute:\n\n        o taQuoted: the value provided by the user is put\n             between single quotes when it is transferred to SQL\n             UPDATE or INSERT statements;\n            \n        o taNotQuoted: the value provided by the user is not\n             quoted when it is transferred to SQL UPDATE or INSERT\n             statements.\n\n          Hint: In general, all attribute values must be quoted, exept\n                the values or expressions for numeric attributes.\n\n    - typeofget: defines how the user provides a value for the\n      attribute; possible values are:\n\n          o tgDirect: the user types the value directly;\n\n          o tgExpression: the user types an expression which is first\n            evaluated before it is passed to SQL UPDATE or INSERT;\n\n            Note: Even with tgDirect it is possible to enter an\n                  expression as new value for an attribute, but then\n                  the expression is evaluated by postgres whereas with\n                  tgExpression, the expression is first evaluated by\n                  Tcl before the SQL statement is sent to postgres.\n\n          o tgList: the user selects a value by means of a list box\n            containing a list of values defined in table "pfm_value";\n\n          o tgLink: the user selects a value by means of a list box\n            containing a list of values which is the result from a\n            query on another table.\n\n          o tgReadOnly: this attribute cannot be modified by\n            the user.\n\n            Note: All calculated attributes and all attributes from\n                  tables other than the form's main table should be\n                  declared 'read-only'. If this rule is not observed,\n                  the Add and Update operations on this form will fail.\n\n    - valuelist : the "name" of the value list defined in table\n      "pfm_value_list" (only meaningful if typeofget = tgList);\n\n    - sqlselect: the SQL SELECT statement which is used to fill the\n      list box with possible values for the attribute (only meaningful\n      if typeofget = tgLink).\n\n      Note :\n\n         o The sqlselect may return more than 1 attribute. If so, all\n           the attributes are displayed in the list-box, but only the\n           first one is used for updating the attribute.
pfm_form	pfm_form	f	f	oid, name, tablename, sqlselect, sqlfrom, groupby_having, showform, "view", help	pfm_form	\N	The table "pfm_form" has the following attributes:\n\n    - name : the name of the form (usually equal to the name of\n      the form's table);\n\n    - tablename : the name of the form's main table;\n\n    - sqlselect : the expression list of the form's SQL SELECT\n      statement, not including the word 'SELECT';\n\n    - sqlfrom : the FROM clause of the form's SQL SELECT\n      statement, not including the word 'FROM';\n\n    - groupby_having : an optional 'GROUP BY' clause, not\n      including the words 'GROUP BY', followed by an optional 'HAVING'\n      clause;\n\n    - view : a boolean indicating whether or not the\n      "tablename" is a view;\n\n    - showform : a boolean indicating whether the form is shown\n      in "normal mode" (showform = 'true') or in "design mode"\n      (showform = 'false'). Typically, showform is set 'true' for user\n      defined forms and 'false' for the predefined pfm_* forms.\n\n    - help: a text which is displayed when the user of the form presses\n      the [Help] button on the form.\n\nThe form's main table is defined by tablename. Only the data of\nthat table can be administered by the form.\n\nAll the data generated by the form's SQL SELECT statement can be\ndisplayed on the form. The SQL SELECT statement is defined by:\n\n    - the sqlselect, sqlfrom and groupby_having\n      attributes of pfm_form; and\n\n    - the optional WHERE and ORDER BY clauses provided by the user\n      when opening the form.\n\nThe following rules should be observed when filling out sqlselect and\nsqlfrom:\n\n    1. The form's main table must appear in 'sqlfrom', and must not be\n       aliased. Similarly, the main table's attributes appearing in\n       'sqlselect' must not be aliased. The other tables appearing in\n       the 'sqlfrom' may be aliased.\n\n    2. The fields appearing in 'sqlselect' must have a unique, simple\n       name without the need to precede them with a tablename. So,\n       calculated fields must be given a name by aliasing and\n       attributes of tables other than the main table may need to be\n       aliased in order to have a unique, simple name.\n\n    3. If the form's main table is not a view, the 'sqlselect' must\n       contain the 'oid' of the main table. If the form's main table\n       is a view, the 'sqlselect' must not contain the 'oid' of the\n       main table.\n\n       Note: The 'oid' is the 'object identifier'. It uniquely\n             identifies a row in a table. All tables (not views)\n             implicitly have an oid in postgreSQL. Postgres Forms\n             needs it for identifying a row when issuing an SQL UPDATE\n             or DELETE FROM command. There is no need to display this\n             attribute on the form, i.e. it is not necessary to define\n             it as an attribute in pfm_attribute.\n\n    4. The 'sqlfrom' is either just the name of the form's main table,\n       or it is a JOIN clause in which 1 of the tables is the form's\n       main table. Several join clauses can be nested in order to\n       involve more than 2 tables. See examples below.\n\n\nExample 1: the SQL SELECT for the product form of the sample database\n\n\ntablename:\n    product\n\nsqlselect:\n    oid, id, name, description, nr_in_stock, price\n\nsqlfrom:\n    product\n\ngroupby_having:\n    -\n\n\nExample 2: the SQL SELECT for the invoice form of the sample database\n\n\ntablename:\n    invoice\n\nsqlselect:\n    invoice.oid, invoice.id, invoice.customer, invoice."date",\n    customer.name AS cust_name, SUM(p.price * o.nr) AS invoice_total\n\nsqlfrom:\n    (   (invoice LEFT OUTER JOIN customer ON (invoice.customer = customer.id)\n        ) LEFT OUTER JOIN "order" o ON (invoice.id = o.invoice)\n    ) LEFT OUTER JOIN product p ON (o.product = p.id)\n\ngroupby_having:\n    invoice.oid, invoice.id, invoice.customer, invoice."date",\n    customer.name
order	order	t	f	"order".oid, "order".invoice, "order".product, p.name AS prod_name, "order".nr, p.price AS unit_price, ("order".nr * p.price) AS total_price, i."date", c.name AS customer	\n(    ("order" LEFT OUTER JOIN invoice i ON ("order".invoice = i.id)\n     ) LEFT OUTER JOIN customer c ON (i.customer = c.id)\n) LEFT OUTER JOIN product p ON ("order".product = p.id)	\N	The attributes that can be modified are:\n\n    - invoice: the id of the invoice to which the order belongs.\n      You can select one from the list of invoices.\n\n    - product: you can select one from the list of products\n      in the data base.\n\n    - nr: the number of products identified by 'product' that the\n      customer orders for this invoice.
customer	customer	t	f	oid, id, name, street, post_code, town, country, telephone, e_mail	customer	\N	When adding a new customer, just type "=" for the id. PostgreSQL then\ngenerates a new, unique id.
invoice	invoice	t	f	invoice.oid, invoice.id, invoice.customer, invoice."date", customer.name AS cust_name, SUM(p.price * o.nr) AS invoice_total	\n(   (invoice LEFT OUTER JOIN customer ON (invoice.customer = customer.id)\n    ) LEFT OUTER JOIN "order" o ON (invoice.id = o.invoice)\n) LEFT OUTER JOIN product p ON (o.product = p.id)	invoice.oid, invoice.id, invoice.customer, invoice."date", customer.name	The attributes of the form "invoice" are:\n\n    - id : an integer that uniquely identifies the invoice. Normally,\n      it is not necessary to modify it. When adding a new invoice,\n      just type "=" to let postgreSQL automaticaly generate a new\n      value for id.\n\n    - customer: the id of the invoice's customer. You can select one\n      from the list of customers in the database.\n\n    - date: the invoice's date in the form: yyyy-mm-dd.\n\n    - cust_name: the name of the invoice's customer. You cannot modify\n      it directly. If the attribute 'customer' is modified, the attribute\n      'cust_name' is update accordingly.\n\n    - invoice_total: the sum of the price of the invoice's orders. 
\.


--
-- Data for TOC entry 41 (OID 23024)
-- Name: pfm_link; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_link (linkname, sqlwhere, orderby, displayattrib, fromform, toform) FROM stdin;
Report	name='$(report)'		level	pfm_section	pfm_report
Sections	report='$(name)'	level	name	pfm_report	pfm_section
Attributes	"Tablename"='$(Name)'		"Name"	pfm_table	pfm_table_def
Table	"Name"='$(Tablename)'		Attribute	pfm_table_def	pfm_table
Attributes	form='$(name)'	nr	name	pfm_form	pfm_attribute
incoming links	toform='$(name)'	fromform	name	pfm_form	pfm_link
outgoing links	fromform='$(name)'	toform	name	pfm_form	pfm_link
Where used?	valuelist='$(name)'		name	pfm_value_list	pfm_attribute
Values	valuelist='$(name)'	value	name	pfm_value_list	pfm_value
Value list	name='$(valuelist)'		attribute	pfm_attribute	pfm_value_list
from Form	name='$(fromform)'		linkname	pfm_link	pfm_form
to Form	name='$(toform)'		linkname	pfm_link	pfm_form
Valuelist	name='$(valuelist)'		value	pfm_value	pfm_value_list
table attributes	"Tablename"='$(tablename)'		tablename	pfm_form	pfm_table_def
Invoices	customer=$(id)	"date"	name	customer	invoice
Customer	id=$(customer)		date	invoice	customer
Orders	invoice=$(id)		id	invoice	order
Product	id=$(product)		invoice	order	product
Orders	product=$(id)	invoice	name	product	order
Invoice	invoice.id=$(invoice)			order	invoice
Form	name='$(form)'		attribute	pfm_attribute	pfm_form
\.


--
-- Data for TOC entry 42 (OID 23029)
-- Name: pfm_report; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_report (name, description, table_or_view, sqlwhere, orderby) FROM stdin;
OneTable	Show attributes of one table or view	pfm_table_report	"Name"='$(tablename)'	\N
TableDef	Show attributes of tables and views	pfm_table_report		\N
TableList	Show tables and views defined in this data base	pfm_table		\N
Invoices	Show invoices for a particular customer since a certain date	invoice_report	(customer='$(customer_name)') AND ("date" >= '$(begin_date)')	
Reports	Show all report definitions	report_view		name, "level"
\.


--
-- Data for TOC entry 43 (OID 23034)
-- Name: pfm_section; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_section (report, "level", fieldlist, layout) FROM stdin;
TableDef	2	{Attribute "Attribute" l} {Type "Type" l}	table
TableDef	1	{Schema "Schema"} {Name "Name"} {RelTyp "RelTyp"} {Owner "Owner"}	row
TableList	1	{Name "Name" l} {Schema "Schema" l} {Type "Type" l} {Owner "Owner" l}	table
OneTable	1	{Schema "Schema"} {Name "Name"} {RelTyp "RelTyp"} {Owner "Owner"}	row
OneTable	2	{Attribute "Attribute" l} {Type "Type" l}	table
Invoices	2	{invoice "Invoice nr." r} {date "Date" l} 	row
Invoices	3	{nr "nr. of units" r} {prod_nr "Prod. nr" r} {product "Product" l} {price "unit price" r} {total "Total price" r}	table
Invoices	1	{cust_id "Customer Id"} {customer Name} {street Address} {post_code ZIP} {town Town} {country Country} {telephone Tel.} {e_mail E-mail}	column
Reports	1	{name Name} {description Description} {table_or_view "Table/View"}\n{sqlwhere "SQL WHERE"} {orderby "ORDER BY"}	column
Reports	2	{level Level r} {layout Layout l} {fieldlist FieldList l}	column
\.


--
-- Data for TOC entry 44 (OID 23039)
-- Name: pfm_value; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_value (value, description, valuelist) FROM stdin;
taQuoted	Value must be enclosed in ' ' for SQL.	typeofattribute
taNotQuoted	Value must not be enclosed in ' ' for SQL.	typeofattribute
tgDirect	Value directly typed by user.	typeofget
tgExpression	Value may be given as an expression.	typeofget
tgList	Value comes from a valuelist.	typeofget
tgLink	Value comes from 'sqlselect'.	typeofget
t	TRUE	boolean
f	FALSE	boolean
column	A column for the labels, a second column for the corresponding values	layout
table	A table with the labels as table header	layout
row	Labels and values on 1 row	layout
tgReadOnly	Value never to be entered by the user	typeofget
\.


--
-- Data for TOC entry 45 (OID 23044)
-- Name: pfm_value_list; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY pfm_value_list (name) FROM stdin;
typeofattribute
typeofget
boolean
layout
none
\.


--
-- Data for TOC entry 46 (OID 23063)
-- Name: test; Type: TABLE DATA; Schema: public; Owner: wim
--

COPY test (id, rest) FROM stdin;
\.


--
-- TOC entry 26 (OID 23246)
-- Name: customer_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY customer
    ADD CONSTRAINT customer_pkey PRIMARY KEY (id);


--
-- TOC entry 27 (OID 23248)
-- Name: product_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY product
    ADD CONSTRAINT product_pkey PRIMARY KEY (id);


--
-- TOC entry 28 (OID 23250)
-- Name: invoice_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT invoice_pkey PRIMARY KEY (id);


--
-- TOC entry 30 (OID 23252)
-- Name: pfm_report_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_report
    ADD CONSTRAINT pfm_report_pkey PRIMARY KEY (name);


--
-- TOC entry 54 (OID 23254)
-- Name: ref_sections; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_section
    ADD CONSTRAINT ref_sections FOREIGN KEY (report) REFERENCES pfm_report(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 31 (OID 23258)
-- Name: pfm_value_list_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value_list
    ADD CONSTRAINT pfm_value_list_pkey PRIMARY KEY (name);


--
-- TOC entry 55 (OID 23260)
-- Name: ref_list; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_value
    ADD CONSTRAINT ref_list FOREIGN KEY (valuelist) REFERENCES pfm_value_list(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 29 (OID 23264)
-- Name: pfm_form_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_form
    ADD CONSTRAINT pfm_form_pkey PRIMARY KEY (name);


--
-- TOC entry 50 (OID 23266)
-- Name: ref_form; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT ref_form FOREIGN KEY (form) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 51 (OID 23270)
-- Name: ref_value_list; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_attribute
    ADD CONSTRAINT ref_value_list FOREIGN KEY (valuelist) REFERENCES pfm_value_list(name) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 52 (OID 23274)
-- Name: ref_fromform; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT ref_fromform FOREIGN KEY (fromform) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 53 (OID 23278)
-- Name: ref_toform; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY pfm_link
    ADD CONSTRAINT ref_toform FOREIGN KEY (toform) REFERENCES pfm_form(name) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 32 (OID 23282)
-- Name: test_pkey; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY test
    ADD CONSTRAINT test_pkey PRIMARY KEY (id);


--
-- TOC entry 49 (OID 23284)
-- Name: ref_customer; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY invoice
    ADD CONSTRAINT ref_customer FOREIGN KEY (customer) REFERENCES customer(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 47 (OID 23288)
-- Name: ref_invoice; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT ref_invoice FOREIGN KEY (invoice) REFERENCES invoice(id) ON UPDATE CASCADE ON DELETE CASCADE;


--
-- TOC entry 48 (OID 23292)
-- Name: ref_product; Type: CONSTRAINT; Schema: public; Owner: wim
--

ALTER TABLE ONLY "order"
    ADD CONSTRAINT ref_product FOREIGN KEY (product) REFERENCES product(id) ON UPDATE CASCADE ON DELETE RESTRICT;


--
-- TOC entry 3 (OID 23059)
-- Name: customer_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT pg_catalog.setval ('customer_id_seq', 15, true);


--
-- TOC entry 25 (OID 23061)
-- Name: test_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT pg_catalog.setval ('test_id_seq', 1, false);


--
-- TOC entry 5 (OID 23069)
-- Name: invoice_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT pg_catalog.setval ('invoice_id_seq', 16, true);


--
-- TOC entry 7 (OID 23071)
-- Name: product_id_seq; Type: SEQUENCE SET; Schema: public; Owner: wim
--

SELECT pg_catalog.setval ('product_id_seq', 7, true);


