/*
 * Decompiled with CFR 0.152.
 */
package components.group;

import components.group.UsersPanel;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pgclibrary.objects.Group;
import pgclibrary.utilities.SUtilities;

public class GroupPanel
extends JTabbedPane {
    Group group_object = null;
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    UsersPanel user_panel = new UsersPanel();
    JTextArea sql = new JTextArea();

    public GroupPanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setGroup(Group _group_object) {
        this.group_object = _group_object;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
        this.addTab("Users", this.user_panel);
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                GroupPanel.this.refreshProperties();
            }
        });
    }

    public void refreshProperties() {
        switch (this.getSelectedIndex()) {
            case 0: {
                this.refreshDefaultPanel();
                break;
            }
            case 1: {
                this.user_panel.refresh(this.group_object);
            }
        }
    }

    private void insertDefaultTab() {
        this.oid.setEditable(false);
        this.name.setEditable(false);
        JSplitPane panel = new JSplitPane(0);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        this.sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(this.sql));
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, 1));
        general_panel.add(SUtilities.getHorPanel("Group ID :", this.oid));
        general_panel.add(SUtilities.getHorPanel("Group Name :", this.name));
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        this.addTab("General", panel);
    }

    private void refreshDefaultPanel() {
        this.oid.setText(String.valueOf(this.group_object.getOID()));
        this.name.setText(this.group_object.getName());
        this.sql.setText(this.group_object.getInsertSQL());
        this.repaint();
    }
}

