/*
 * Decompiled with CFR 0.152.
 */
package components.user;

import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import pgclibrary.objects.User;
import pgclibrary.utilities.SUtilities;
import pgclibrary.utilities.Utilities;

public class UserPanel
extends JTabbedPane {
    User user_object = null;
    JTextField oid = new JTextField(20);
    JTextField name = new JTextField(20);
    JTextField validlimit = new JTextField(20);
    JTextField dbcreator = new JTextField(20);
    JTextField superuser = new JTextField(20);
    JTextField traceuser = new JTextField(20);
    JTextArea sql = new JTextArea();

    public UserPanel() {
        this.initPanel();
        this.setPreferredSize(this.getMinimumSize());
    }

    public void setUser(User _user_object) {
        this.user_object = _user_object;
        this.refreshProperties();
    }

    private void initPanel() {
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.insertDefaultTab();
    }

    public void refreshProperties() {
        this.refreshDefaultPanel();
    }

    private void insertDefaultTab() {
        this.oid.setEditable(false);
        this.name.setEditable(false);
        this.validlimit.setEditable(false);
        this.dbcreator.setEditable(false);
        this.superuser.setEditable(false);
        this.traceuser.setEditable(false);
        JSplitPane panel = new JSplitPane(0);
        panel.setOneTouchExpandable(true);
        panel.setResizeWeight(0.5);
        this.sql.setEditable(false);
        panel.setBottomComponent(new JScrollPane(this.sql));
        JPanel general_panel = new JPanel();
        general_panel.setLayout(new BoxLayout(general_panel, 1));
        general_panel.add(SUtilities.getHorPanel("User ID :", this.oid));
        general_panel.add(SUtilities.getHorPanel("User Name :", this.name));
        general_panel.add(SUtilities.getHorPanel("Valid Until :", this.validlimit));
        general_panel.add(SUtilities.getHorPanel("Is DB Creator :", this.dbcreator));
        general_panel.add(SUtilities.getHorPanel("Is Super User :", this.superuser));
        general_panel.add(SUtilities.getHorPanel("Is Trace User :", this.traceuser));
        panel.setTopComponent(SUtilities.centerComponent(general_panel));
        this.addTab("General", panel);
    }

    private void refreshDefaultPanel() {
        this.oid.setText(String.valueOf(this.user_object.getOID()));
        this.name.setText(this.user_object.getName());
        this.sql.setText(this.user_object.getInsertSQL());
        this.validlimit.setText(Utilities.formatDate(this.user_object.getValidLimit(), "MM/dd/yyyy HH:mm:ss"));
        this.dbcreator.setText(Utilities.formatBoolean(this.user_object.isDBCreateor()));
        this.superuser.setText(Utilities.formatBoolean(this.user_object.isSuperUser()));
        this.traceuser.setText(Utilities.formatBoolean(this.user_object.isTraceUser()));
        this.repaint();
    }
}

