/*
 * SwingUtilities.java
 *
 * Created on 1 de agosto de 2002, 09:19
 */

package pgclibrary.utilities;
import javax.swing.*;
import java.awt.*;
/**
 *
 * @author  nestor
 */
public class SUtilities {
    
    /** Creates a new instance of SwingUtilities */
    private SUtilities() {
    }

    public static JPanel centerComponent(JComponent _panel){
        JPanel tmp_panel = new JPanel();
        tmp_panel.setLayout(new BoxLayout(tmp_panel, BoxLayout.Y_AXIS));
        tmp_panel.add(Box.createVerticalGlue());
        
        JPanel tmp_panel1 = new JPanel();
        tmp_panel1.setLayout(new BoxLayout(tmp_panel1, BoxLayout.X_AXIS));
        tmp_panel1.add(Box.createHorizontalGlue());
        tmp_panel1.add(_panel);
        tmp_panel1.add(Box.createHorizontalGlue());
        tmp_panel.add(tmp_panel1);
        tmp_panel.add(Box.createVerticalGlue());
        return tmp_panel;
    }
    
    public static JComponent resizeComponent(JComponent _component){
        int h = (int) _component.getPreferredSize().getHeight();
        int w = (int) _component.getPreferredSize().getWidth();
        
        if(h>w) {
            _component.setSize(w, w);
        } else {
            _component.setSize(h, h);
        }
        _component.setPreferredSize(_component.getSize());
        _component.setMinimumSize(_component.getSize());
        _component.setMaximumSize(_component.getSize());
        return _component;
    }
    
    public static JPanel getHorPanel(String title, JComponent _component){
        JPanel retorno = new JPanel();
        retorno.setLayout(new BoxLayout(retorno, BoxLayout.X_AXIS));
        
        JLabel label = new JLabel(title);
        label.setMaximumSize(label.getPreferredSize());
        retorno.add(label);
        
        _component.setMaximumSize(_component.getPreferredSize());
        retorno.add(Box.createHorizontalGlue());
        retorno.add(_component);
        return retorno;
    }
}
