-- $Id: all.sql,v 1.12 2001/07/14 09:21:28 ciaccia Exp $

BEGIN;

-- MySQL Compatibility functions

CREATE FUNCTION unix_timestamp(timestamp) RETURNS int8 AS
'SELECT (CASE WHEN $1 = NULL THEN 0 ELSE date_part(\'epoch\', $1) END)::int8' LANGUAGE 'sql';

CREATE FUNCTION to_days(timestamp) RETURNS int8 AS
'SELECT floor(CASE WHEN $1 = NULL THEN 0 ELSE unix_timestamp($1)/86400 END)::int8' LANGUAGE 'sql';

CREATE FUNCTION dayofmonth(timestamp) RETURNS int2 AS
'SELECT date_part(\'day\', $1)::int2' LANGUAGE 'sql';

CREATE FUNCTION month(timestamp) RETURNS int2 AS
'SELECT date_part(\'month\', $1)::int2' LANGUAGE 'sql';

CREATE FUNCTION year(timestamp) RETURNS int4 AS
'SELECT date_part(\'year\', $1)::int4' LANGUAGE 'sql';

CREATE FUNCTION week(timestamp) RETURNS int2 AS
'SELECT date_part(\'week\', $1)::int2' LANGUAGE 'sql';

CREATE FUNCTION date_format(timestamp, text) RETURNS text AS
'SELECT CASE WHEN $1 = NULL THEN \'\' ELSE to_char($1, $2) END' LANGUAGE 'sql';

CREATE FUNCTION if(bool, varchar, varchar) RETURNS varchar AS
'SELECT CASE WHEN $1 THEN $2 ELSE $3 END' LANGUAGE 'sql';

CREATE FUNCTION phpads_ww(int, timestamp) RETURNS text AS
'SELECT to_char(week($2 + ((1 - $1) || \' day\')::interval)::int, \'FM00\'::text)' LANGUAGE 'sql';

CREATE FUNCTION phpads_yyyy(int, timestamp) RETURNS text AS '
SELECT CASE
WHEN week($2 + ((1 - $1) || \' day\')::interval) >= 52 AND month($2) = 1 THEN to_char(year($2)-1, \'FM0000\')
WHEN week($2 + ((1 - $1) || \' day\')::interval) = 1 AND month($2) = 12 THEN to_char(year($2)+1, \'FM0000\')
ELSE to_char(year($2), \'FM0000\')
END
' LANGUAGE 'sql';

-- Table structure for table 'clients'

CREATE SEQUENCE phpads_clients_clientid_seq;

CREATE TABLE phpads_clients (
   clientid int8 NOT NULL DEFAULT nextval('phpads_clients_clientid_seq')::int8,
   clientname varchar(255) NOT NULL,
   contact varchar(255),
   email varchar(64),
   views int2,
   clicks int2,
   clientusername varchar(64),
   clientpassword varchar(64),
   expire date,
   activate date,
   permissions int2,
   language varchar(64),
   active boolean,
   weight int2 default 1,   
   parent int8 DEFAULT 0 NOT NULL,
   report boolean,
   reportinterval int4 DEFAULT 7,
   reportlastdate date,
   reportdeactivate boolean,
   PRIMARY KEY (clientid)
);


-- Table structure for table 'banners'

CREATE SEQUENCE phpads_banners_bannerid_seq;

CREATE TABLE phpads_banners (
   bannerid int8 NOT NULL DEFAULT nextval('phpads_banners_bannerid_seq')::int8,
   clientid int8 DEFAULT 0 NOT NULL,
   banner text,
   width int2 DEFAULT 0 NOT NULL,
   height int2 DEFAULT 0 NOT NULL,
   format varchar (4) DEFAULT 'gif' NOT NULL, -- enum('gif','jpeg','png','html','url','web')
   url varchar(255) NOT NULL,
   alt varchar(255) NOT NULL,
   keyword varchar(255) NOT NULL,
   bannertext varchar(255) NOT NULL,
   active boolean NOT NULL,
   weight int2 DEFAULT 1 NOT NULL,
   seq int2 DEFAULT 0 NOT NULL,
   target varchar(8) DEFAULT '' NOT NULL,
   description varchar(255) DEFAULT '' NOT NULL,
   autohtml boolean DEFAULT 't' NOT NULL,   
   PRIMARY KEY (bannerid),
   FOREIGN KEY (clientid) REFERENCES phpads_clients (clientid) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX phpads_banners_clientid ON phpads_banners(clientid);

-- Table structure for table 'adclicks'

CREATE TABLE phpads_adclicks (
   bannerid int8 DEFAULT '0' NOT NULL,
   t_stamp timestamp,
   host varchar(255) NOT NULL,
   FOREIGN KEY (bannerid) REFERENCES phpads_banners(bannerid) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX phpads_adclicks_bannerid ON phpads_adclicks(bannerid);


-- Table structure for table 'adviews'

CREATE TABLE phpads_adviews (
   bannerid int8 DEFAULT '0' NOT NULL,
   t_stamp timestamp,
   host varchar(255) NOT NULL,
   FOREIGN KEY (bannerid) REFERENCES phpads_banners(bannerid) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX phpads_adviews_bannerid ON phpads_adviews(bannerid);


-- Table structure for table 'acls'

CREATE TABLE phpads_acls (
   bannerid int8 DEFAULT 0 NOT NULL,
   acl_type varchar(12) NOT NULL,
   acl_data varchar(255) NOT NULL,
   acl_ad boolean NOT NULL,
   acl_order int8 DEFAULT 0 NOT NULL,
   acl_con varchar(5),
   PRIMARY KEY (bannerid, acl_order),
   FOREIGN KEY (bannerid) REFERENCES phpads_banners(bannerid) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX phpads_acls_bannerid ON phpads_acls (bannerid);


-- Table structure for table 'adstats'

CREATE TABLE phpads_adstats (
  views int4 DEFAULT 0 NOT NULL,
  clicks int4 DEFAULT 0 NOT NULL,
  day date DEFAULT NOW() NOT NULL,
  bannerid int8 DEFAULT 0 NOT NULL,
  PRIMARY KEY (day, bannerid),
  FOREIGN KEY (bannerid) REFERENCES phpads_banners(bannerid) ON UPDATE CASCADE ON DELETE CASCADE
);

CREATE INDEX phpads_adstats_bannerid ON phpads_acls (bannerid);

CREATE SEQUENCE phpads_zones_zoneid_seq;

CREATE TABLE phpads_zones (
   zoneid int4 NOT NULL DEFAULT nextval('phpads_banners_bannerid_seq')::int8,
   zonename varchar(255) NOT NULL,
   zonetype int2 DEFAULT 0 NOT NULL,
   what oid NOT NULL,
   width int2 DEFAULT 0 NOT NULL,
   height int2 DEFAULT 0 NOT NULL,
   retrieval varchar(16) DEFAULT 'random' NOT NULL,
   cachecontents oid,
   cachetimestamp int4 DEFAULT 0 NOT NULL,
   PRIMARY KEY (zoneid)
);

COMMIT;
