<?php // $Id: dblib.php,v 1.13 2001/07/09 16:43:05 ciaccia Exp $ - #phpAdsNew Revision: 1.19 #

/************************************************************************/
/* phpPgAds                                                             */
/* ========                                                             */
/*                                                                      */
/* Copyright (c) 2001 by the phpPgAds developers                        */
/* http://www.greatbridge.org/project/phppgads/                         */
/*                                                                      */
/* This program is free software. You can redistribute it and/or modify */
/* it under the terms of the GNU General Public License as published by */
/* the Free Software Foundation; either version 2 of the License.       */
/************************************************************************/



// PostgreSQL DB Resource
$phpAds_db_link = '';


/*********************************************************/
/* Open a connection to the database                     */
/*********************************************************/

function db_connect()
{
	global $phpAds_hostname, $phpAds_db, $phpAds_pgsqluser, $phpAds_pgsqlpassword;
	global $phpPgAds_timezone;
	global $phpAds_db_link;

	$conn_str = (empty($phpAds_hostname) ? "" : "host=$phpAds_hostname ")."dbname=$phpAds_db user=$phpAds_pgsqluser".
		(empty($phpAds_pgsqlpassword) ? "" : " password=$phpAds_pgsqlpassword");

	if ($GLOBALS["phpAds_persistent_connections"])
		$phpAds_db_link = @pg_pconnect($conn_str);
	else
		$phpAds_db_link = @pg_connect($conn_str);

	if (!empty($phpPgAds_timezone))
		pg_Exec($phpAds_db_link, "SET TIMEZONE = '$phpPgAds_timezone'");

	return $phpAds_db_link;
	}



/*********************************************************/
/* Close the connection to the database			         */
/*********************************************************/

function db_close()
{
	global $phpAds_persistent_connections;
	global $phpAds_db_link;
	
	if (!$phpAds_persistent_connections)
		@pg_close ($phpAds_db_link);
}



/*********************************************************/
/* Execute a query                                       */
/*********************************************************/

function db_query($query, $link = "")
	{
    global $phpAds_last_query;
	global $phpAds_db_link;
	
    $phpAds_last_query = $query;
	
    return @pg_Exec($phpAds_db_link, $query);
	}



/*********************************************************/
/* Log a click to the database                           */
/*********************************************************/

function db_log_click($bannerid, $host)
	{
   global $phpAds_compact_stats, $phpAds_tbl_adstats;
   global $phpAds_tbl_adclicks;
	
   if ($phpAds_compact_stats)
		{
		$result = @db_query("UPDATE $phpAds_tbl_adstats SET clicks = clicks+1 WHERE bannerid = '$bannerid' AND day = CURRENT_DATE")
			or pg_die();
		
      // If row didn't exist.  Create it.
      if (pg_cmdtuples($result) == 0) 
			{
         $result = @db_query("INSERT INTO $phpAds_tbl_adstats (clicks, views, bannerid) VALUES (1, 0, '$bannerid')")
				or pg_die();
        }
        return $result;
    }
    
    // else
	 
    return @db_query("INSERT INTO $phpAds_tbl_adclicks VALUES ('$bannerid',  NOW(), '$host')")
		 or pg_die();
}



/*********************************************************/
/* Log a view to the database                            */
/*********************************************************/

function db_log_view($bannerid, $host)
{
    global $phpAds_compact_stats, $phpAds_tbl_adstats;
    global $phpAds_tbl_adviews;
    
    if ($phpAds_compact_stats)
    {
        $result = @db_query("UPDATE $phpAds_tbl_adstats SET views = views+1 WHERE bannerid = '$bannerid' AND day = CURRENT_DATE")
			  or pg_die();
		
        // If row didn't exist.  Create it.
        if (pg_cmdtuples($result) == 0) 
        {
            $result = @db_query("INSERT INTO $phpAds_tbl_adstats (clicks, views, bannerid) VALUES (0, 1, '$bannerid')")
					or pg_die();
        }
        return $result;
    }
    
    // else
    
    return @db_query("INSERT INTO $phpAds_tbl_adviews VALUES ('$bannerid', NOW(), '$host')")
		 or pg_die();
}



/*********************************************************/
/* Get overview statistics                               */
/*********************************************************/

function db_total_stats($table, $column, $bannerid, $timeconstraint="")
	{
	global $phpAds_tbl_adstats, $phpAds_begin_of_week;
    
	$ret = 0;
	$where = "";
	
	if (!empty($bannerid))
		$where = "WHERE bannerid = $bannerid";
    
	if (!empty($timeconstraint))
		{
		if (!empty($bannerid))
			$where .= " AND ";
		else
			$where = "WHERE ";
		
		if ($timeconstraint == "month")
			$where .= "date_part('month', t_stamp) = date_part('month', t_stamp)";
		elseif ($timeconstraint == "week")
			$where .= "phpads_ww($phpAds_begin_of_week, t_stamp) = phpads_ww($phpAds_begin_of_week, NOW()) 
				AND phpads_yyyy($phpAds_begin_of_week, t_stamp) = phpads_yyyy($phpAds_begin_of_week, NOW())";
		else
			$where .= "date_part('day', t_stamp) = date_part('day', NOW())";
		}
	
	$res = db_query("SELECT count(*) as qnt FROM $table $where") or pg_die();
	if (pg_numrows ($res))
		{
		$row = pg_fetch_array($res, 0);
		if (isset($row['qnt'])) $ret += $row['qnt'];
		}

	$where = "";
	if (!empty($bannerid)) 
		$where = "WHERE bannerid = $bannerid";
    
	if (!empty($timeconstraint))
		{
		if (!empty($bannerid))
			$where .= " AND ";
		else
			$where = "WHERE ";
		
		if ($timeconstraint == "month")
			$where .= "DATE_PART('month', day) = DATE_PART('month', CURRENT_DATE)";
		elseif ($timeconstraint == "week")
			$where .= "phpads_ww($phpAds_begin_of_week, day) = phpads_ww($phpAds_begin_of_week, NOW())
				AND phpads_yyyy($phpAds_begin_of_week, day) = phpads_yyyy($phpAds_begin_of_week, NOW())";
		else
		    $where .= "day = CURRENT_DATE";
		}
	
	$res = db_query("SELECT sum($column) as qnt FROM $phpAds_tbl_adstats $where") or pg_die();
	if (pg_numrows ($res))
		{
		$row = pg_fetch_array($res, 0);
		if (isset($row['qnt'])) $ret += $row['qnt'];
		}

	return $ret;
}

function db_total_clicks($bannerid="", $timeconstraint="")
	{
	return db_total_stats($GLOBALS["phpAds_tbl_adclicks"], "clicks", $bannerid, $timeconstraint);
	}

function db_total_views($bannerid="", $timeconstraint="")
	{
	return db_total_stats($GLOBALS["phpAds_tbl_adviews"], "views", $bannerid, $timeconstraint);
	}



/*********************************************************/
/* Delete statistics                                     */
/*********************************************************/

function db_delete_stats($bannerid)
	{
	global $phpAds_tbl_adviews, $phpAds_tbl_adclicks, $phpAds_tbl_adstats;
	
	db_query("DELETE FROM $phpAds_tbl_adviews WHERE bannerid = $bannerid") or pg_die();
	db_query("DELETE FROM $phpAds_tbl_adclicks WHERE bannerid = $bannerid") or pg_die();
	db_query("DELETE FROM $phpAds_tbl_adstats WHERE bannerid = $bannerid") or pg_die();

}



/*********************************************************/
/* Get the host of the client                            */
/*********************************************************/

function phpAds_getClientInformation()
{
	// Get host address and host name
	$addr = isset ($GLOBALS['REMOTE_ADDR']) ? $GLOBALS['REMOTE_ADDR'] : '';
	$host = isset ($GLOBALS['REMOTE_HOST']) ? $GLOBALS['REMOTE_HOST'] : '';
	
	// Lookup host name if needed
	if ($host == '' && $phpAds_reverse_lookup)
		$host = @gethostbyaddr ($addr);
	else
		$host = $addr;
	
	// Check for proxyserver
	$proxy = false;
	if (isset ($GLOBALS['HTTP_VIA']) && $GLOBALS['HTTP_VIA'] != '') $proxy = true;
	if (is_int (strpos ('proxy',   $host))) $proxy = true;
	if (is_int (strpos ('cache',   $host))) $proxy = true;
	if (is_int (strpos ('inktomi', $host))) $proxy = true;
	
	if ($proxy)
	{
		// Overwrite host address if a suitable header is found
		if (isset($GLOBALS['HTTP_FORWARDED']) && 		$GLOBALS['HTTP_FORWARDED'] != '') 		$addr = $GLOBALS['HTTP_FORWARDED'];
		if (isset($GLOBALS['HTTP_FORWARDED_FOR']) &&	$GLOBALS['HTTP_FORWARDED_FOR'] != '') 	$addr = $GLOBALS['HTTP_FORWARDED_FOR'];
		if (isset($GLOBALS['HTTP_X_FORWARDED']) &&		$GLOBALS['HTTP_X_FORWARDED'] != '') 	$addr = $GLOBALS['HTTP_X_FORWARDED'];
		if (isset($GLOBALS['HTTP_X_FORWARDED_FOR']) &&	$GLOBALS['HTTP_X_FORWARDED_FOR'] != '') $addr = $GLOBALS['HTTP_X_FORWARDED_FOR'];
		if (isset($GLOBALS['HTTP_CLIENT_IP']) &&		$GLOBALS['HTTP_CLIENT_IP'] != '') 		$addr = $GLOBALS['HTTP_CLIENT_IP'];
		
		// Get last item from list
		$addrArray = explode (',', $addr);
		$addr = trim($addrArray[sizeof($addrArray) - 1]);
		
		// Perform reverse lookup if needed
		if ($phpAds_reverse_lookup)
			$host = @gethostbyaddr ($addr);
		else
			$host = $addr;
	}
	
	
	return (array ($addr, $host));
}


/*********************************************************/
/* Check if host has to be ignored                       */
/*********************************************************/

function phpads_ignore_host()
{
	global $phpAds_ignore_hosts, $phpAds_reverse_lookup, $REMOTE_HOST, $REMOTE_ADDR;
	
	list ($addr, $host) = phpAds_getClientInformation();
	
	$found=0;
	
	while (($found == 0) && (list (, $h)=each($phpAds_ignore_hosts)))
	{
		if (ereg("^([0-9]{1,3}\.){1,3}([0-9]{1,3}|\*)$", $h))
		{
			// It's an IP address, evenually with a wildcard, so I create a regexp
			$h = str_replace(".", '\.', str_replace("*$", "", "^".$h."$"));
			
			if (ereg($h, $addr))
				$found = 1;
		}
		elseif (eregi("^(\*\.)?([a-z0-9-]+\.)*[a-z0-9-]+$", $h))
		{
			// It's an host name, evenually with a wildcard, so I create a regexp
			$h = str_replace(".", '\.', str_replace("^*", "", "^".$h."$"));
						
			if (eregi($h, $host))
				$found = 1;
		}
		elseif (eregi("$host|$addr", $h)) // This check is backwards compatibile
				$found = 1;
	}
	
	// Returns hostname or IP address if OK, false if host is ignored
	return $found ? false : (empty($host) ? $addr : $host);
}

?>
