'
'	Frank Lupo (Wolf) !!
'	frank_lupo@email.it
'
'	This is a Psql command for Postgresql write in Visual Basic Script
'
'	Class Message
'
Option Explicit

Class ClsMessage

    Public Property Get Help()
		Help="Try 'psql /HELP' for more information."
	End Property

    Public Property Get Usage()
		Usage = "This is psql, the PostgreSQL interactive terminal write in Vbs." & vbCrLf
		Usage = Usage & vbCrLf
		Usage = Usage & "Usage:" & vbCrLf
		Usage = Usage & "  psql options" & vbCrLf
		Usage = Usage & vbCrLf
		Usage = Usage & "Options:" & vbCrLf
'		Usage = Usage & "  -a              Echo all input from script" & vbCrLf
'		Usage = Usage & "  -A              Unaligned table output mode (-P format=unaligned)" & vbCrLf
		Usage = Usage & "  /CMD:COMMAND    Run only single command (SQL or internal) and exit" & vbCrLf
		Usage = Usage & "  /DB:NAME        Specify database name to connect to (default: " & App.Data.Setting.Database.Database & ")" & vbCrLf
'		Usage = Usage & "  -e              Echo commands sent to server" & vbCrLf
		Usage = Usage & "  /ECHOQ          Display queries that internal commands generate" & vbCrLf
		Usage = Usage & "  /FILE:FILENAME  Execute commands from file, then exit" & vbCrLf
'		Usage = Usage & "  -F STRING       Set field separator (default: '" & App.Setting.OptionsPrint.Options.FieldSep &"') (-P fieldsep=)" & vbCrLf
		Usage = Usage & "  /HOST:NAME      Specify database server host (default: " & App.Data.Setting.Database.Host & ")" & vbCrLf
		Usage = Usage & "  /HTML           HTML table output mode" & vbCrLf
		Usage = Usage & "  /LADB           List available databases, then exit" & vbCrLf
'		Usage = Usage & "  -n              Disable enhanced command line editing (readline)" & vbCrLf
		Usage = Usage & "  /OUTF:FILENAME  Send query results to file" & vbCrLf
		Usage = Usage & "  /PORT:PORT      Specify database server port (default: " & App.Data.Setting.Database.Port & ")" & vbCrLf
'		Usage = Usage & "  -P VAR[=ARG]    Set printing option 'VAR' to 'ARG' (see \pset command)" & vbCrLf
'		Usage = Usage & "  -q              Run quietly (no messages, only query output)" & vbCrLf
'		Usage = Usage & "  -R STRING       Set record separator (default:" & replace(App.Setting.OptionsPrint.Options.RecordSep,vbcrlf,"\n") & ") (-P recordsep=)" & vbCrLf
		Usage = Usage & "  /SSM            Single step mode (confirm each query)" & vbCrLf
'		Usage = Usage & "  -S              Single line mode (end of line terminates SQL command)" & vbCrLf
		Usage = Usage & "  /PRO            Print rows only" & vbCrLf
'		Usage = Usage & "  -T TEXT         Set HTML table tag attributes (width, border) (-P tableattr=)" & vbCrLf
		Usage = Usage & "  /USER:NAME      Specify database user name (default: " & App.Data.Setting.Database.User & ")" & vbCrLf
'		Usage = Usage & "  -v NAME=VALUE   Set psql variable 'NAME' to 'VALUE'" & vbCrLf
		Usage = Usage & "  /VERSION        Show version information and exit" & vbCrLf
		Usage = Usage & "  /PWD:PASSWORD   Prompt for password or password (should happen automatically)" & vbCrLf
'		Usage = Usage & "  -x              Turn on expanded table output (-P expanded)" & vbCrLf
'		Usage = Usage & "  -X              Do not read startup file (~/.psqlrc)" & vbCrLf
		Usage = Usage & "  /HELP           Show Help" & vbCrLf
		Usage = Usage & vbCrLf
		Usage = Usage & "For more information, type ""\?"" (for internal commands) or ""\help""" & vbCrLf
	End Property

    Public Property Get Version()
		Version = "Psql.vbs (PostgreSQL) " & App.Revision & "." & App.Minor & "." & App.Major & vbCrLf
		Version = Version & "Copyright (c) 2000-2002, Frank Lupo (Wolf) !!" & vbCrLf
		Version = Version & "Read the file COPYRIGHT or use the command \copyright to see the" & vbCrLf
		Version = Version & "usage and distribution terms." & vbCrLf
	End Property

    Public Property Get Copyright()
    	Copyright = "PostgreSQL Data Base Management System" & vbCrLf
    	Copyright = Copyright & vbCrLf
    	Copyright = Copyright & "Copyright (c) 2000-2002, Frank Lupo (Wolf) !!" & vbCrLf
    	Copyright = Copyright & vbCrLf
    	Copyright = Copyright & "This software is based on Postgres95, formerly known as Postgres, which" & vbCrLf
    	Copyright = Copyright & "contains the following notice:" & vbCrLf
    	Copyright = Copyright & vbCrLf
    	Copyright = Copyright & "Permission to use, copy, modify, and distribute this software and its" & vbCrLf
    	Copyright = Copyright & "documentation for any purpose, without fee, and without a written agreement" & vbCrLf
    	Copyright = Copyright & "is hereby granted, provided that the above copyright notice and this paragraph" & vbCrLf
    	Copyright = Copyright & "and the following two paragraphs appear in all copies." & vbCrLf
    	Copyright = Copyright & vbCrLf
    	Copyright = Copyright & "IN NO EVENT SHALL THE FRANK_LUPO BE LIABLE TO ANY PARTY FOR" & vbCrLf
    	Copyright = Copyright & "DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, INCLUDING LOST" & vbCrLf
    	Copyright = Copyright & "PROFITS, ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF" & vbCrLf
    	Copyright = Copyright & "THE FRANK_LUPO HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH" & vbCrLf
    	Copyright = Copyright & "DAMAGE." & vbCrLf
    	Copyright = Copyright & vbCrLf
    	Copyright = Copyright & "THE FRANK_LUPO SPECIFICALLY DISCLAIMS ANY WARRANTIES, INCLUDING," & vbCrLf
    	Copyright = Copyright & "BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A" & vbCrLf
    	Copyright = Copyright & "PARTICULAR PURPOSE.THE SOFTWARE PROVIDED HEREUNDER IS ON AN ""AS IS"" BASIS," & vbCrLf
    	Copyright = Copyright & "AND THE FRANK_LUPO HAS NO OBLIGATIONS TO PROVIDE MAINTENANCE," & vbCrLf
		Copyright = Copyright & "SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS." & vbCrLf
		Copyright = Copyright & vbCrLf
	End Property

    Public Property Get VersionSetEnv()
		VersionSetEnv = "SetEnv.vbs " & vbCrLf
		VersionSetEnv = VersionSetEnv & "Copyright (c) 2000-2002, Frank Lupo (Wolf) !!" & vbCrLf
		VersionSetEnv = VersionSetEnv & "Read the file COPYRIGHT" & vbCrLf
		VersionSetEnv = VersionSetEnv & "usage and distribution terms." & vbCrLf
	End Property

    Public Function Row(NumRow)
		if NumRow=1 then
			Row = "(" & NumRow & " row)"
		else
			Row = "(" & NumRow & " rows)"
		end if		
	End Function

    Public Property Get Welcome()
	    Welcome = "Welcome to psql, the PostgreSQL interactive terminal write to vbs." & vbCrLf
    	Welcome = Welcome & vbCrLf
    	Welcome = Welcome & "Type:  \copyright for distribution terms" & vbCrLf
'    	Welcome = Welcome & "       \h for help with SQL commands" & vbCrLf
    	Welcome = Welcome & "       \? for help on internal slash commands" & vbCrLf
    	Welcome = Welcome & "       \g or terminate with semicolon to execute query" & vbCrLf
    	Welcome = Welcome & "       \q to quit" & vbCrLf
	End Property

    Public Property Get InternalHelp()
InternalHelp = "" & vbCrLf

'		InternalHelp = " \a             toggle between unaligned and aligned output mode" & vbCrLf
'		InternalHelp = InternalHelp & " \c[onnect] [DBNAME|- [USER]]" & vbCrLf
'		InternalHelp = InternalHelp & "                connect to new database (currently 'gedis30')" & vbCrLf
'		InternalHelp = InternalHelp & " \C TITLE       set table title" & vbCrLf
		InternalHelp = InternalHelp & " \cd [DIRNAME]  change the current working directory" & vbCrLf
'		InternalHelp = InternalHelp & " \copy ...      perform SQL COPY with data stream to the client host" & vbCrLf
		InternalHelp = InternalHelp & " \copyright     show PostgreSQL usage and distribution terms" & vbCrLf
'		InternalHelp = InternalHelp & " \d TABLE       describe table (or view, index, sequence)" & vbCrLf
		InternalHelp = InternalHelp & " \d{t|i|s|v}... list tables/indexes/sequences/views" & vbCrLf
		InternalHelp = InternalHelp & " \d{p|S}        list access privileges, system tables" & vbCrLf
'		InternalHelp = InternalHelp & " \d{p|S|l}      list access privileges, system tables, or large objects" & vbCrLf
		InternalHelp = InternalHelp & " \da            list aggregate functions" & vbCrLf
		InternalHelp = InternalHelp & " \dd NAME       show comment for table, type, function, or operator" & vbCrLf
		InternalHelp = InternalHelp & " \df            list functions" & vbCrLf
		InternalHelp = InternalHelp & " \do            list operators" & vbCrLf
		InternalHelp = InternalHelp & " \dT            list data types" & vbCrLf
		InternalHelp = InternalHelp & " \du            list database users" & vbCrLf
		InternalHelp = InternalHelp & " \e FILENAME    edit the current query buffer or file with external editor" & vbCrLf
		InternalHelp = InternalHelp & " \echo TEXT     write text to standard output" & vbCrLf
'		InternalHelp = InternalHelp & " \encoding ENCODING  set client encoding" & vbCrLf
'		InternalHelp = InternalHelp & " \f STRING      set field separator" & vbCrLf
'		InternalHelp = InternalHelp & " \g FILENAME    send SQL command to server (and write results to file or |pipe)" & vbCrLf
'		InternalHelp = InternalHelp & " \h NAME        help on syntax of SQL commands, * for all commands" & vbCrLf

		InternalHelp = InternalHelp & " \H             toggle HTML output mode (currently " 
		if App.Data.Print.Html then
			InternalHelp = InternalHelp & "on"
		else
			InternalHelp = InternalHelp & "off"
		end if
		InternalHelp = InternalHelp & ")" & vbCrLf

		InternalHelp = InternalHelp & " \i FILENAME    execute commands from file" & vbCrLf
		InternalHelp = InternalHelp & " \l             list all databases" & vbCrLf
'		InternalHelp = InternalHelp & " \lo_export, \lo_import, \lo_list, \lo_unlink" & vbCrLf
'		InternalHelp = InternalHelp & "                large object operations" & vbCrLf
		InternalHelp = InternalHelp & " \o FILENAME    send all query results to file" & vbCrLf
		InternalHelp = InternalHelp & " \p             show the content of the current query buffer" & vbCrLf
'		InternalHelp = InternalHelp & " \pset VAR      set table output option (VAR := {format|border|expanded|" & vbCrLf
'		InternalHelp = InternalHelp & "                fieldsep|null|recordsep|tuples_only|title|tableattr|pager})" & vbCrLf
		InternalHelp = InternalHelp & " \q             quit psql" & vbCrLf
'		InternalHelp = InternalHelp & " \qecho TEXT    write text to query output stream (see \o)" & vbCrLf
		InternalHelp = InternalHelp & " \r             reset (clear) the query buffer" & vbCrLf
'		InternalHelp = InternalHelp & " \s FILENAME    print history or save it to file" & vbCrLf
'		InternalHelp = InternalHelp & " \set NAME VALUE  set internal variable" & vbCrLf

		InternalHelp = InternalHelp & " \t             show only rows (currently " 
		if App.Data.Print.PrintRowsOnly then
			InternalHelp = InternalHelp & "on"
		else
			InternalHelp = InternalHelp & "off"
		end if 
		InternalHelp = InternalHelp & ")" & vbCrLf

'		InternalHelp = InternalHelp & " \T TEXT        set HTML table tag attributes" & vbCrLf
'		InternalHelp = InternalHelp & " \unset NAME    unset (delete) internal variable" & vbCrLf
		InternalHelp = InternalHelp & " \w FILENAME    write current query buffer to file" & vbCrLf
'		InternalHelp = InternalHelp & " \x             toggle expanded output (currently off)" & vbCrLf
		InternalHelp = InternalHelp & " \z             list table access privileges" & vbCrLf
		InternalHelp = InternalHelp & " \! [COMMAND]   execute command in shell or start interactive shell" & vbCrLf
	End Property

    Public Function NoSuchFD(szCommand)
		NoSuchFD = trim(szCommand) & ": No such file or directory"
	End Function

    Public Function MissArg(szCommand)
		MissArg = trim(szCommand) & ": missing required argument"
	End Function

    Public Function RelNotFound(szCommand)
		RelNotFound = "Did not find any relation named """ & trim(szCommand) & """"
	End Function

    Public Function InvalidCommand(szCommand)
		InvalidCommand = "Invalid command " & trim(szCommand) & ". Try \? for help."
	End Function
End Class
