/**
 * trg_xorder.c,v 1.1 2003/07/17 14:10:46 myui Exp
 *
 * What is this?
 *  -- function to set document order using general triggers.
 *
 * ----------------------
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>,
 * 					  Atsuyuki Morishima <amorishima@acm.org>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote 
 * 	  products derived from this software without specific prior written
 *    permission.
 * 
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License (see COPYING.GPL), in which case the provisions 
 * of the GPL are required INSTEAD OF the above restrictions.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#include <string.h>
#include "postgres.h"
#include "executor/spi.h"      	/* this is what you need to work with SPI */
#include "commands/trigger.h"	/* -"- and triggers */

//#define __DEBUG__
//#define __BULKLOAD__

//#define __BEFOREUPDATE__

#define KIND_ROOT       0
#define KIND_ELEMENT    1
#define KIND_TEXT       2
#define KIND_COMMENT    3
#define KIND_PI         4
#define KIND_ATTRIBUTE  5
#define KIND_NAMESPACE  6

#define BEFORE_INSERT_TRG 1
#define BEFORE_UPDATE_TRG 2

#define STD_QUERY_SIZE   8192

#define EXIT_TRG_XORDER 							\
	SPI_finish();									\
	return PointerGetDatum(trigtuple)

#define PG_TEXT_GET_STR(textp_) \
	DatumGetCString(DirectFunctionCall1(textout, PointerGetDatum(textp_)))

Datum trg_xorder(PG_FUNCTION_ARGS);
static int xo_query_exec(char *query_str, ...);

Datum h_replace(PG_FUNCTION_ARGS);
//static char *StrShift( char *String, unsigned int nShift );


/*************************************************************************/
PG_FUNCTION_INFO_V1(trg_xorder);

Datum
trg_xorder(PG_FUNCTION_ARGS)
{
	TriggerData *trigdata = (TriggerData *) fcinfo->context;
	Trigger    *trigger;		/* to get trigger name */
	TupleDesc	tupdesc;		/* tuple descriptor */
	Relation	rel;			/* triggered relation */
	HeapTuple	trigtuple;		/* triggered NEW tuple */
	HeapTuple	trigtuple_old;	/* triggered OLD tuple */
	bool connected;				/* SPI connection */
	bool isnull;				/* getbinval() */
	
	/* arguments */
	int kind;
	char *dewey,*old_dewey;
	char *next_id,*old_next;
	int32 node_id,doc_id,pathid,parent_id,child_id,tag_id;
	int32 old_pathid,old_parent,old_tag;

	/* select into variable */
	char *path,*xorder;
	int dims;
	int32 l_order;
//	_Bool united;
	//char *nxtPathId=NULL;
	
	// initialize
	child_id = -1;
	path = xorder = NULL;
	dims = 0;
	l_order = 1;

#ifdef __DEBUG__
	elog(NOTICE, "[trg_xorder] enter");
#endif

	/*
	 * Some checks first...
	 */
    /* Called by trigger manager ? */
	if (!CALLED_AS_TRIGGER(fcinfo))
		elog(ERROR, "trg_xorder: not fired by trigger manager");

    /* check for null values */
#ifdef __BEFOREUPDATE__
    if (!TRIGGER_FIRED_BY_UPDATE(trigdata->tg_event))
		elog(ERROR, "trg_xorder: not fired by update trigger");
#else
    if (!TRIGGER_FIRED_BY_UPDATE(trigdata->tg_event) && !TRIGGER_FIRED_AFTER(trigdata->tg_event))
		elog(ERROR, "trg_xorder: not fired by after update trigger");
#endif

	trigtuple	 = trigdata->tg_newtuple;

	trigtuple_old = trigdata->tg_trigtuple;

	rel = trigdata->tg_relation;
	trigger = trigdata->tg_trigger;
	tupdesc = rel->rd_att;

    /* Connect to SPI manager */
	connected=(SPI_connect()==SPI_ERROR_CONNECT);

	/**
	 *  Well, the string value of attribute
	 * 
	 *     aval[1]=id, aval[2]=kind, aval[3]=document, aval[4]=pathid,
	 *     aval[5]=dewey, aval[6]=parent, aval[7]=child, a_val[8]=next
	 *	   aval[9]=tag
	 **/
	 parent_id = DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 6, &isnull));
	 if(isnull)
	 {
#ifdef __DEBUG__		
		elog(NOTICE,"parent is null");
#endif
		EXIT_TRG_XORDER;	 
	 }

	 old_parent = DatumGetInt32(SPI_getbinval(trigtuple_old, tupdesc, 6, &isnull));
	 old_tag = DatumGetInt32(SPI_getbinval(trigtuple_old, tupdesc, 9, &isnull));
	 tag_id = DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 9, &isnull));
	 if(parent_id==old_parent && (tag_id==old_tag || isnull))
	 {
#ifdef __DEBUG__		
		elog(NOTICE,"no need changing");
#endif
	 	EXIT_TRG_XORDER;
	 }
	 else
	 {
	 	next_id = SPI_getvalue(trigtuple, tupdesc, 8);
	 	old_next = SPI_getvalue(trigtuple_old, tupdesc, 8);
	 }

	 pathid = DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 4, &isnull));
	 old_pathid = DatumGetInt32(SPI_getbinval(trigtuple_old, tupdesc, 4, &isnull));	 
	 dewey = SPI_getvalue(trigtuple, tupdesc, 5);
	 old_dewey = SPI_getvalue(trigtuple_old, tupdesc, 5);
	 if(pathid!=old_pathid)
	 {
#ifdef __DEBUG__		
		elog(NOTICE,"already changed\nnew_pathid=%d,old_pathid=%d",
			pathid,old_pathid);
#endif
	 	EXIT_TRG_XORDER;
	 }
	 if(old_dewey!=NULL && strcmp(dewey,old_dewey)!=0)
	 {
#ifdef __DEBUG__		
			elog(NOTICE,"already changed\nnew_dewey=%s,old_dewey=%s",
				dewey,old_dewey);
#endif
		 	EXIT_TRG_XORDER;
	 }
	 	
	 node_id = DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 1, &isnull));
	 kind = (int) DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 2, &isnull));
	 doc_id = DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 3, &isnull));

#ifdef __DEBUG__
	elog(NOTICE, "node_id=%d,kind=%d,doc_id=%d,pathid=%d,dewey=%s,parent_id=%d\n"
				 "child_id=%d,next_id=%s,tag_id=%d",
		node_id,kind,doc_id,pathid,dewey,parent_id,child_id,next_id,tag_id);
	elog(NOTICE, "old_pathid=%d,old_parent=%d,old_next=%s,old_tag=%d",
				old_pathid,old_parent,old_next,old_tag);
#endif
	
	if(kind==KIND_ELEMENT || kind==KIND_TEXT || kind==KIND_COMMENT || kind==KIND_PI)
	{
	
	    xo_query_exec("SELECT last(dewey)+1 "
	        		  "FROM xml_node "
	        		  "WHERE next = %d ",node_id);
	
		if(SPI_processed>0)
		{
			l_order=DatumGetInt32(SPI_getbinval(
						SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1, &isnull));
			if(isnull)
				l_order = 1;
		}
	}

	if(kind==KIND_ELEMENT){

		/* select pathexp and calculate dewey */
		xo_query_exec("select "
							"(xp.pathexp || '#/' || ("
													"select " 
														"name " 
													"from "
														"xml_tag " 
													"where "
														"tagid=%d"
													")"
							"),"
							"pn.dewey + %d,"
							"icount(pn.dewey) + 1 "
						"from "
							"xml_node pn,"
							"xml_path xp "
						"where "
							"pn.id = %d and "
 							"xp.pathid = pn.pathid",
                      tag_id,l_order,parent_id
                      );

		if(SPI_processed>0)
		{
			path=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
			xorder=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2);
			dims=(int) DatumGetInt32(SPI_getbinval(
							SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 3, &isnull));
		}
		else
			elog(ERROR,"[SPI ERROR] path & label could't calculate");

		if(dewey == NULL)
		{
			/* set current node's path */
			xo_query_exec("INSERT INTO xml_path(pathid,pathexp) VALUES(%d,'%s')",node_id,path);
		}
		else
		{
			/* update influenced node's label */
			if(next_id != NULL)
			{
				xo_query_exec("UPDATE "
							      "xml_node "
							  "SET "
							      "dewey[%d] = dewey[%d] + 1 "
							  "WHERE "
							      "subarray(dewey,1,%d) = subarray('%s'::_int4,1,%d) AND "
							      "dewey[%d] >= %d",	//"last(dewey::_int4) >= %s",
		                      dims,dims,dims-1,xorder,dims-1,dims,l_order
							);
			}

			/* update insert-node's descendant path and label */
			SPI_getbinval(trigtuple, tupdesc, 7, &isnull);
			//child_id = DatumGetInt32(SPI_getbinval(trigtuple, tupdesc, 7, &isnull));
			if(!isnull)
			{	
				/* update insert-node's descendant label */
				xo_query_exec("UPDATE "
									"xml_node "
							  "SET "
									"dewey = ('%s' + subarray(dewey,icount('%s')+1)) "
							  "WHERE "
							      "_int_descendant(dewey,'%s')",
	                          xorder,dewey,dewey,dewey
							);
				/* need to modify desendant's pathexp... */
				xo_query_exec("UPDATE "
									"xml_path "
							  "SET "
									"pathexp = h_replace(pathexp,"
													   "(select pathexp from xml_path where pathid=%d),"
													   "'%s'"
													  ") "
							  "FROM "
							  		"xml_node cn "
							  "WHERE "
							  	  "_int_descendant(cn.dewey,'%s') AND "
							      "xml_path.pathid = cn.pathid",
	                          pathid,path,xorder
							);
				
			}

			/* set current node's path */
			xo_query_exec("UPDATE xml_path SET pathexp = '%s', united = NULL WHERE pathid = %d",path,node_id);			
		}
		
		/* set current node's label */
		xo_query_exec("UPDATE xml_node SET dewey = '%s' WHERE id = %d",xorder,node_id);
	}
	else if(kind==KIND_TEXT || kind==KIND_COMMENT || kind==KIND_PI){

		/* select pathexp and calculate dewey */
		xo_query_exec("select "
							"xp.pathexp || '#/%s',"
							"pn.dewey + %d,"
							"icount(pn.dewey) + 1 "
						"from "
							"xml_node pn,"
							"xml_path xp "
						"where "
							"pn.id = %d and "
 							"xp.pathid = pn.pathid",
                      kind==KIND_TEXT ? "text()" : kind==KIND_COMMENT ? "comment()" : kind==KIND_PI ? "processing-instruction()" : "",
                      l_order,parent_id
                      );

		if(SPI_processed>0){
			path=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
			xorder=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2);
			dims=(int) DatumGetInt32(SPI_getbinval(
							SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 3, &isnull));
		}
		else
			elog(ERROR,"[SPI ERROR]\n");
		
		if(dewey==NULL)
		{
			/* set current node's path */
			xo_query_exec("INSERT INTO xml_path(pathid,pathexp) VALUES(%d,'%s')",node_id,path);
		}
		else
		{
			/* update influenced node's label */
			if(next_id != NULL)
			{
				xo_query_exec("UPDATE "
							      "xml_node "
							  "SET "
							      "dewey[%d] = dewey[%d] + 1 "
							  "WHERE "
							      "subarray(dewey,1,%d) = subarray('%s'::_int4,1,%d) AND "
							      "dewey[%d] >= %d",	//"last(dewey::_int4) >= %s",
		                      dims,dims,dims-1,xorder,dims-1,dims,l_order
							);
			}

			/* set current node's path */
			xo_query_exec("UPDATE xml_path SET pathexp = '%s', united = NULL WHERE pathid=%d",path,node_id);					
		}
	
		/* set current node's label */
		xo_query_exec("UPDATE xml_node SET dewey = '%s' WHERE id = %d",xorder,node_id);
	}
	else if(kind==KIND_ATTRIBUTE){

		/* select pathexp and calculate dewey */
		xo_query_exec("SELECT "
							"xp.pathexp || '#/@' || "
								"(select name from xml_attribute where tagid=%d),"
							"pn.dewey + 0 "
						"FROM "
							"xml_node pn,"
							"xml_path xp "
						"WHERE "
							"pn.id = %d AND "
							"xp.pathid = pn.pathid",
						tag_id,parent_id
					);

		if(SPI_processed>0)
		{
			path=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 1);
			xorder=SPI_getvalue(SPI_tuptable->vals[0], SPI_tuptable->tupdesc, 2);
		}
		else
			elog(ERROR,"[SPI ERROR] result not found\n");

		/* set current node's path */
		if(dewey==NULL)
			xo_query_exec("INSERT INTO xml_path(pathid,pathexp) VALUES(%d,'%s')",node_id,path);
		else
			xo_query_exec("UPDATE xml_path SET pathexp = '%s', united = NULL WHERE pathid = %d",path,node_id);	

		/* set current node's label */	
		xo_query_exec("UPDATE xml_node SET dewey = '%s' WHERE id = %d",xorder,node_id);
	}
	else if(kind==KIND_NAMESPACE){

		/* set current node's label */
		xo_query_exec("UPDATE "
							"xml_node "
						"SET "
							"dewey = (select dewey + 0 from xml_node where id=%d) " 
						"WHERE "
							"id = %d",
						parent_id,node_id);
	}
	else{
		// When node-type is invalid one
		EXIT_TRG_XORDER;
	}

#ifdef __DEBUG__
	elog(NOTICE,"[trg_xorder] finish");
#endif

	/* Clean up */
	if(!connected)SPI_finish();
	
	return PointerGetDatum(trigtuple);
}


/**
 * xo_query_exec:
 *
 *
 */
static int xo_query_exec(char *query_str, ...)
{
	va_list args;
	int ret;
	char query[STD_QUERY_SIZE+1];

	va_start(args, query_str);
		vsnprintf(query, STD_QUERY_SIZE, query_str, args);
	va_end(args);

#ifdef __DEBUG__
	elog(NOTICE,"Query:%s",query);
#endif
	if((ret=SPI_exec(query,0))<0){
		switch(ret){
			case  -1:elog(ERROR,"[SPI_ERROR_CONNECT] %s",query);break;
			case  -2:elog(ERROR,"[SPI_ERROR_COPY] %s",query);break;
			case  -3:elog(ERROR,"[SPI_ERROR_OPUNKNOWN] %s",query);break;
			case  -4:elog(ERROR,"[SPI_ERROR_UNCONNECTED] %s",query);break;
			case  -5:elog(ERROR,"[SPI_ERROR_CURSOR] %s",query);break;
			case  -6:elog(ERROR,"[SPI_ERROR_ARGUMENT] %s",query);break;
			case  -7:elog(ERROR,"[SPI_ERROR_PARAM] %s",query);break;
			case  -8:elog(ERROR,"[SPI_ERROR_TRANSACTION] %s",query);break;
			case  -9:elog(ERROR,"[SPI_ERROR_NOATTRIBUTE] %s",query);break;
			case -10:elog(ERROR,"[SPI_ERROR_NOOUTFUNC] %s",query);break;
			case -11:elog(ERROR,"[SPI_ERROR_TYPUNKNOWN] %s",query);break;
			default:elog(ERROR,"[SPI_ERROR_OTHER] %s",query);
		}
	}
#ifdef __DEBUG__
	elog(NOTICE,"[Result:%d]",ret);
#endif
	return ret;
}

/**
 * h_replace:
 *
 * warning : undefined when buffer over flows.
 */
PG_FUNCTION_INFO_V1(h_replace);
Datum
h_replace(PG_FUNCTION_ARGS)
{
	char *str = DatumGetCString(DirectFunctionCall1(textout, PointerGetDatum(PG_GETARG_TEXT_P(0))));
	char *pat = DatumGetCString(DirectFunctionCall1(textout, PointerGetDatum(PG_GETARG_TEXT_P(1))));
	char *sub = DatumGetCString(DirectFunctionCall1(textout, PointerGetDatum(PG_GETARG_TEXT_P(2))));
	char *buf,*match_p;
	size_t lenpat, lensub, lenstr, lenres;
	struct varlena *res;
	
	if(*str == '\0')
		PG_RETURN_NULL();
	if(pat == NULL || *pat == '\0')
		PG_RETURN_TEXT_P(PG_GETARG_DATUM(0));
	
	lenstr = strlen(str);
	lenpat = strlen(pat);		// from
	lensub = strlen(sub);		// to
	lenres = lenstr + lensub - lenpat;

	buf = (char*) repalloc(str,lenres);

	/* make room for substituted string, or remove slack after it */
	if( (match_p=strstr(buf,pat))!=NULL && lensub != lenpat)
		memmove(match_p + lensub, match_p + lenpat, lenstr + 1 - lenpat);

	memcpy(match_p, sub, lensub);
	
	res=palloc(lenres+VARHDRSZ);
	res->vl_len = lenres+VARHDRSZ;

	memcpy(VARDATA(res),buf,lenres);
	PG_RETURN_TEXT_P(res);
}

