/**
 * dom_l2.sql,v 1.1 2003/07/17 14:10:45 myui Exp
 *
 * ----------------------
 * Copyright (c) 2003 Makoto Yui <yuin@bb.din.or.jp>
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of the author may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * ALTERNATIVELY, this product may be distributed under the terms of
 * the GNU Public License (see COPYING.GPL), in which case the provisions
 * of the GPL are required INSTEAD OF the above restrictions.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

-- This function is yet beta stage now. created one day..(-:
-- not tested well. report of testing is welcome.
-- send problems to mailing-list.

/*
	=== DOM LEVEL 2 CORE LIST ===

[y] : supported [n] : no plan to support now [-] : not yet implemented
//[p] : partical

-- DOMImplementation
[-] createDocument() ex [DOMImplementation.createDocument()]
[n] createDocumentType() ex [DOMImplementation.createDocumentType()]
[y] hasFeature() ex [DOMImplementation.hasFeature()]

-- Document
[y] createAttribute() ex [Document.createAttribute()]
[-] createAttributeNS() ex [Document.createAttributeNS()]
[n] createCDATASection() ex [Document.createCDATASection()]
[y] createComment() ex [Document.createComment()]
[-] createDocumentFragment() ex [Document.createDocumentFragment()]
[y] createElement() ex [Document.createElement()]
[y] createElementNS() ex [Document.createElementNS()]
[n] createEntityReference() ex [Document.createEntityReference()]
[y] createProcessingInstruction() ex [Document.createProcessingInstruction()]
[y] createTextNode() ex [Document.createTextNode()]
[n] getElementById() ex [Document.getElementById()]
[y] getElementsByTagName() ex [Document.getElementsByTagName()]
[-] getElementsByTagNameNS() ex [Document.getElementsByTagNameNS()]
[-] importNode() ex [Document.importNode()]

-- Node
[y] appendChild() ex [Node.appendChild()]
[-] cloneNode() ex [Node.cloneNode()]
[y] hasAttributes() ex [Node.hasAttributes()]
[y] hasChildNodes() ex [Node.hasChildNodes()]
[y] insertBefore() ex [Node.insertBefore()]
[n] isSupported() ex [Node.isSupported()]
[-] normalize() ex [Node.normalize()]
[-] removeChild() ex [Node.removeChild()]
[-] replaceChild() ex [Node.replaceChild()]

-- NodeList
[n] item() ex [NodeList.item()]

-- NamedNodeMap
[n] getNamedItem() ex [NamedNodeMap.getNamedItem()]
[n] getNamedItemNS() ex [NamedNodeMap.getNamedItemNS()]
[n] item() ex [NamedNodeMap.item()]
[n] removeNamedItem() ex [NamedNodeMap.removeNamedItem()]
[n] removeNamedItemNS() ex [NamedNodeMap.removeNamedItemNS()]
[n] setNamedItem() ex [NamedNodeMap.setNamedItem()]
[n] setNamedItemNS() ex [NamedNodeMap.setNamedItemNS()]

-- Element
[y] getAttribute() ex [Element.getAttribute()]
[y] getAttributeNode() ex [Element.getAttributeNode()]
[-] getAttributeNodeNS() ex [Element.getAttributeNodeNS()]
[-] getAttributeNS() ex [Element.getAttributeNS()]
[y] getElementsByTagName() ex [Element.getElementsByTagName()]
[-] getElementsByTagNameNS() ex [Element.getElementsByTagNameNS()]
[y] hasAttribute() ex [Element.hasAttribute()]
[-] hasAttributeNS() ex [Element.hasAttributeNS()]
[*] removeAttribute() ex [Element.removeAttribute()]
[-] removeAttributeNode() ex [Element.removeAttributeNode()]
[-] removeAttributeNS() ex [Element.removeAttributeNS()]
[y] setAttribute() ex [Element.setAttribute()]
[-] setAttributeNode() ex [Element.setAttributeNode()]
[-] setAttributeNodeNS() ex [Element.setAttributeNodeNS()]
[-] setAttributeNS() ex [Element.setAttributeNS()]

-- Text
[-] splitText() ex [Text.splitText()]

-- CharacterData
[y] appendData() ex [CharacterData.appendData()]
[y] deleteData() ex [CharacterData.deleteData()]
[y] insertData() ex [CharacterData.insertData()]
[y] replaceData() ex [CharacterData.replaceData()]
[y] substringData() ex [CharacterData.substringData()]


	=== DOM TreeWalker LIST ===

[y] getFirstChild()
[y] getNextSibling()


// NODE-TYPE and NUMBER BINDING
#define KIND_ROOT       0
#define KIND_ELEMENT    1
#define KIND_TEXT       2
#define KIND_COMMENT    3
#define KIND_PI         4
#define KIND_ATTRIBUTE  5
#define KIND_NAMESPACE  6
#define KIND_DUMMY		-1

TODO:
	support DOM exception.
	support treeWalker.

-- List of DOM exception --
 1 = INDEX_SIZE_ERR                  If index or size is negative, or greater than the allowed value.
 2 = DOMSTRING_SIZE_ERR              If the specified range of text does not fit into a DOMString.
 3 = HIERARCHY_REQUEST_ERR           If any node is inserted somewhere it doesn't belong.
 4 = WRONG_DOCUMENT_ERR              If a node is used in a different document than the one that created it (that doesn't support it).
 5 = INVALID_CHARACTER_ERR           If an invalid character is specified, such as in a name.
 6 = NO_DATA_ALLOWED_ERR             If data is specified for a node which does not support data.
 7 = NO_MODIFICATION_ALLOWED_ERR     If an attempt is made to modify an object where modifications are not allowed.
 8 = NOT_FOUND_ERR                   If an attempt was made to reference a node in a context where it does not exist.
 9 = NOT_SUPPORTED_ERR               If the implementation does not support the type of object requested.
10 = INUSE_ATTRIBUTE_ERR             If an attempt is made to add an attribute that is already in use elsewhere.
11 = INVALID_STATE_ERR               If an attempt is made to use an object that is not, or is no longer, usable.
12 = SYNTAX_ERR                      If an invalid or illegal string is specified.
13 = INVALID_MODIFICATION_ERR        If an attempt is made to modify the type of the underlying object.
14 = NAMESPACE_ERR                   If an attempt is made to create or change an object in a way which is incorrect with regard to namespaces.
15 = INVALID_ACCESS_ERR              If a parameter or an operation is not supported by the underlying object.

*/

--------------------------------------------------------------------------
-- Private functions
--------------------------------------------------------------------------

-- getNodeType(name VARCHAR)::SMALLINT
CREATE OR REPLACE FUNCTION getNodeType (VARCHAR) RETURNS INTEGER
AS '
	SELECT
		CASE upper($1)
			WHEN ''ELEMENT'' THEN 1
			WHEN ''TEXT'' THEN 2
			WHEN ''ATTRIBUTE'' THEN 5
			WHEN ''NAMESPACE'' THEN 6
			WHEN ''ROOT'' THEN 0
			WHEN ''DUMMY'' THEN -1
			WHEN ''COMMENT'' THEN 3
			WHEN ''PI'' THEN 4
			WHEN ''PROCESSINGINSTRUCTION'' THEN 4
			ELSE
				NULL
		END
' LANGUAGE 'sql' IMMUTABLE STRICT;

/**
 -- getDocument(docname VARCHAR)::INTEGER
 -- returns document.
 */
CREATE OR REPLACE FUNCTION getDocument (VARCHAR) RETURNS INTEGER AS '
	SELECT
	    xn.id
	FROM
	    xml_node xn,
	    xml_document xd
	WHERE
	    xd.name = $1 AND
	    xn.docid = xd.docid AND
	    xn.kind = getnodetype(''ROOT'')
' LANGUAGE 'sql' STABLE STRICT;

/**
 -- Document.getDocumentElement()::Element
 -- getDocumentElement(docroot INTEGER)::INTEGER
 -- returns rootnode.
 */
CREATE OR REPLACE FUNCTION getDocumentElement (INTEGER) RETURNS INTEGER AS '
	SELECT
	    xn2.id
	FROM
	    xml_node xn1,
	    xml_node xn2
	WHERE
	    xn1.id = $1 AND
	    xn1.kind = getNodeType(''ROOT'') AND
	    xn2.parent = xn1.id
' LANGUAGE 'sql' STABLE STRICT;

--------------------------------------------------------------------------
-- Interface DOMImplementation
--------------------------------------------------------------------------

/**
 -- DOMImplementation.createDocument(namespaceURI, qualifiedName, doctype)
 */
 -- yet not supported

/**
 -- DOMImplementation.createDocumentType(qualifiedName, publicId, systemId)
 */
 -- no plan to support

/**
 -- DOMImplementation.hasFeature(feature, version)
 -- hasFeature(feature VARCHAR,version VARCHAR)::BOOLEAN
 */
CREATE OR REPLACE FUNCTION hasFeature (VARCHAR,VARCHAR) RETURNS BOOLEAN
AS '
SELECT
    exists(SELECT
                *
            FROM
                domimpl
            WHERE
                upper(feature) = upper($1) AND
                upper(version) = upper($2)
            )
' LANGUAGE 'sql' IMMUTABLE STRICT;

--------------------------------------------------------------------------
-- Interface Document
--------------------------------------------------------------------------

/**
 -- createAttribute(docnode INTEGER, attname VARCHAR)::INTEGER
 	returns reference of created node.
 */
CREATE OR REPLACE FUNCTION createAttribute (INTEGER, VARCHAR) RETURNS INTEGER AS '
	DECLARE
		V_DOCNODE ALIAS FOR $1;
		V_ATTVAL ALIAS FOR $2;
		V_DOCID     INTEGER;
		V_NODEID	INTEGER;
		V_DUMMYID	INTEGER;
	BEGIN
		SELECT INTO V_DOCID docid FROM xml_node WHERE id=V_DOCNODE AND kind=getNodeType(''ROOT'');
		IF NOT FOUND THEN
			RAISE NOTICE ''First argument must be root node --> %'',V_DOCNODE;
		END IF;
		V_NODEID := nextval(''xml_nodeid_seq'');
		V_DUMMYID := nextval(''xml_node_dummy_seq'');
        EXECUTE
            ''INSERT INTO xml_node(id,kind,docid,pathid,dewey,parent,tagid) '' ||
			''VALUES('' || V_NODEID || '', getNodeType(''''ATTRIBUTE''''), '' || V_DOCID || '','' || V_NODEID || '',''''{-1,'' || V_DOCID || '','' || V_DUMMYID || ''}'''','' || V_DOCNODE || '', xml_attid('''''' || V_ATTVAL || ''''''))'';
		INSERT INTO xml_path VALUES(V_NODEID,''#/@'' || V_ATTVAL,''false'');
        RETURN V_NODEID;
	END;
' LANGUAGE 'plpgsql' STRICT;

/**
 -- Document.createAttributeNS(namespaceURI, qualifiedName)
 */
 -- yet not implemented.
 -- namespace decl with attribute have to be considered well.
 -- in XpSQL implementation, namespace decl is just same to attribute now.
 -- attribute is a special child. attribute could has childs?

/**
 -- Document.createCDATASection(data)
 */
 -- XPath ignores CDATA

/**
 -- Document.createDocumentFragment()
 */
-- not yet supported

/**
 -- createElementNS(Document INTEGER, namespaceURI VARCHAR, qualifiedName VARCHAR)::INTEGER
 -- returns new created node id.

 -- test --
 	select createElementNS(1,'http://myin.org/','myin:aaa')
	select createElementNS(1,'http://myin.org','bbb')
 */
CREATE OR REPLACE FUNCTION createElementNS (INTEGER, VARCHAR, VARCHAR) RETURNS INTEGER AS '
	DECLARE
		V_DOCNODE ALIAS FOR $1;
		V_NSURI ALIAS FOR $2;
		V_QNAME ALIAS FOR $3;
		V_PREFIX VARCHAR;
		V_DEFAULTNS BOOLEAN;
		V_NODEID INTEGER;
	BEGIN
		V_PREFIX := substring(V_QNAME from ''^[^:]+'');
		IF V_PREFIX = V_QNAME THEN
			V_DEFAULTNS := TRUE;
		END IF;
		V_NODEID := createElement(V_DOCNODE,V_QNAME);
		IF V_NODEID IS NULL THEN
			RAISE EXCEPTION ''createElement(%,%) failed.'',V_DOCNODE,V_QNAME;
		END IF;
		IF V_DEFAULTNS THEN
			PERFORM setnamespace(V_NODEID,V_NSURI);
		ELSE
			PERFORM setnamespace(V_NODEID,V_PREFIX,V_NSURI);
		END IF;
		IF NOT FOUND THEN
			RAISE EXCEPTION ''setNamespace(%,%,%) failed.'',V_NODEID,V_PREFIX,V_NSURI;
		END IF;
		RETURN V_NODEID;
	END;
' LANGUAGE 'plpgsql' STRICT;

/**
 -- Document.createEntityReference(name)
 */
-- no plan to support now.

/**
 -- Document.getElementById(elementId)
 */
-- no plan to support
-- cos, xpsql has no support for DTD.

/**
 -- Document.getElementsByTagName(tagName)
 -- getElementsByTagName(docroot INTEGER, tagName VARCHAR)::INTEGER
 -- returns NodeList.
 */
-- appearently, this is the same method as Element.getElementsByTagName

/**
 -- Document.getElementsByTagNameNS(namespaceURI, localName)
 */
-- not yet supported

/**
 -- Document.importNode(importedNode, deep)
 */
-- to be supported near feature.

--------------------------------------------------------------------------
-- Interface Node
--------------------------------------------------------------------------

/**
 -- Node.cloneNode(deep)
 */
-- yet not implemented

/**
 -- Node.hasAttributes()
 -- hasAttributes(node INTEGER)::BOOLEAN
 -- Returns whether this node (if it is an element) has any attributes.
 */
CREATE OR REPLACE FUNCTION hasAttributes (INTEGER) RETURNS BOOLEAN AS '
	SELECT
		EXISTS(
				SELECT
				    id
				FROM
				    xml_node
				WHERE
				    kind=getNodeType(''ATTRIBUTE'') AND
				    parent = $1
		)
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- Node.hasChildNodes()
 -- hasChildNodes(nodeid INTEGER)::BOOLEAN
 */
CREATE OR REPLACE FUNCTION hasChildNodes (INTEGER) RETURNS BOOLEAN AS '
	SELECT
	    exists(SELECT
	                id
	            FROM
	                xml_node
	            WHERE
	                parent = $1
	            )
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- Node.normalize()
 */
-- not yet supported. to be supported in a feature.

/**
 -- Node.removeChild(oldChild)
 */
-- not yet supported.

/**
 -- Node.replaceChild(newChild, oldChild)
 */
-- not yet supported.


--------------------------------------------------------------------------
-- Interface NodeList
--------------------------------------------------------------------------


--------------------------------------------------------------------------
-- Interface NamedNodeMap
--------------------------------------------------------------------------


--------------------------------------------------------------------------
-- Interface Element
--------------------------------------------------------------------------

/**
 -- getAttribute(element integer, attname varchar)::VARCHAR
 -- Retrieves an attribute value by name.
 */
CREATE OR REPLACE FUNCTION getAttribute (INTEGER, VARCHAR) RETURNS VARCHAR AS '
	SELECT
	    value
	FROM
	    xml_node
	WHERE
	    parent = $1 AND
	    tagid = get_attid($2) AND
	    kind = getNodeType(''ATTRIBUTE'')
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- getAttributeNode(element integer, attname varchar)::INTEGER
 -- Retrieves an attribute node by name.
 */
CREATE OR REPLACE FUNCTION getAttributeNode (INTEGER, VARCHAR) RETURNS INTEGER AS '
	SELECT
	    id
	FROM
	    xml_node
	WHERE
	    parent = $1 AND
	    tagid = get_attid($2) AND
	    kind = getNodeType(''ATTRIBUTE'')
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- Element.getAttributeNodeNS(namespaceURI, localName)
 */
-- yet not supported

/**
 -- Element.getAttributeNS(namespaceURI, localName)
 */
-- yet not supported

/**
 -- Element.getElementsByTagName(name)
 -- getElementsByTagName(element INTEGER, tagName VARCHAR)::INTEGER
 -- returns NodeList.
 */
CREATE OR REPLACE FUNCTION getElementsByTagName (INTEGER, VARCHAR) RETURNS SETOF INTEGER AS '
	SELECT
	    xn2.id
	FROM
	    xml_node xn1,
	    xml_node xn2
	WHERE
	    xn1.id = $1 AND
	    _int_descendant(xn2.dewey,xn1.dewey) AND
	    xn2.tagid=get_tagid($2) AND
	    xn2.kind = getNodeType(''ELEMENT'')
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- Element.getAttributeNodeNS(namespaceURI, localName)
 */
-- not yet supported

/**
 -- Element.hasAttribute(name)
 -- hasAttribute(element INTEGER, attname VARCHAR)::BOOLEAN
 -- Boolean -  true if an attribute with a given name is specified on this element
 */
CREATE OR REPLACE FUNCTION hasAttribute (INTEGER, VARCHAR) RETURNS BOOLEAN AS '
	SELECT
		EXISTS(
			SELECT
			    id
			FROM
			    xml_node
			WHERE
			    tagid=get_attid($2) AND
			    kind=getNodeType(''ATTRIBUTE'') AND
			    parent = $1
		)
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- Element.hasAttributeNS(namespaceURI, localName)
 */
-- not yet supported

/**
 -- Element.removeAttribute(name)
 -- removeAttribute(element INTEGER, attname VARCHAR)::VOID
 */
CREATE OR REPLACE FUNCTION removeAttribute (INTEGER, VARCHAR) RETURNS VOID AS '
	DELETE FROM
	    xml_node
	WHERE
	    parent = $1 and tagid=get_attid($2) and kind=getNodeType(''ATTRIBUTE'')
' LANGUAGE 'SQL' STRICT;

/**
 -- Element.removeAttributeNode(oldAttr)
	Returns:
 		Attr -  The Attr node that was removed.
 */
-- not yet supported.

/**
 -- Element.removeAttributeNS(namespaceURI, localName)
 */
-- not yet supported.

/**
 -- Element.setAttributeNS(namespaceURI, qualifiedName, value)
 */
-- not yet supported

/**
 -- Element.setAttributeNode(newAttr)
 -- setAttributeNode(element INTEGER, newAttr INTEGER)::BOOLEAN
 -- Returns:
		Attr -  If the newAttr attribute replaces an existing attribute
		with the same local name and namespace URI, the replaced Attr
		node is returned, otherwise null is returned.
 */
-- not yet supported

--CREATE OR REPLACE FUNCTION setAttributeNode (INTEGER, INTEGER) RETURNS BOOLEAN AS '
--	DECLARE
--		V_ELEM ALIAS FOR $1;
--		V_ATT ALIAS FOR $2:
--		V_RES INTEGER;
--		V_ATTNAME VARCHAR;
--	BEGIN
--		-- check argument
--		SELECT INTO V_RES id
--		FROM xml_node
--		WHERE id = V_ELEM and kind=getNodeType(''ELEMENT'');
--		IF NOT FOUND THEN
--			RAISE EXCEPTION ''first argument type is invalid.'';
--		END IF;
--		SELECT INTO V_RES tagid
--		FROM xml_node
--		WHERE id = V_ATT and kind=getNodeType(''ATTRIBUTE'') dewey[1]=-1;
--		IF NOT FOUND THEN
--			RAISE EXCEPTION ''second argument type is invalid.'';
--		END IF;
--		-- extract attribute value
--		SELECT INTO V_ATTNAME name
--		FROM xml_attribute
--		WHERE tagid = V_RES;
--		-- select attibute which has same parent and same name.
--		SELECT
--		    id
--		FROM
--		    xml_node
--		WHERE
--		    parent = V_ELEM AND
--		    tagid=get_attid(V_ATTNAME) AND
--		    kind=getNodeType('ATTRIBUTE');
--
--
--
--		RETRUN true;
--	END;
--' LANGUAGE 'plpgsql' STRICT;

/**
 -- Element.setAttributeNodeNS(newAttr)
 */
-- not yet supported


--------------------------------------------------------------------------
-- Interface Text
--------------------------------------------------------------------------
/**
 -- Text.splitText(offset)
 */
-- not yet supported. to be supported in the feature.


--------------------------------------------------------------------------
-- Interface CharactorData
--------------------------------------------------------------------------

/**
 -- appendData(CharacterDataNode INTEGER, value VARCHAR)::BOOLEAN
 */
CREATE OR REPLACE FUNCTION appendData (INTEGER, VARCHAR) RETURNS BOOLEAN AS '
    DECLARE
        V_RES INTEGER;
    BEGIN
        SELECT INTO V_RES id FROM xml_node
        WHERE id=$1 AND (kind=getNodeType(''TEXT'') OR kind=getNodeType(''COMMENT''));
        IF NOT FOUND THEN
            RAISE NOTICE ''Node type must be comment or text --> %'',$1;
        END IF;
        UPDATE xml_node SET value = value || $2 WHERE id = $1;
        RETURN TRUE;
	END;
' LANGUAGE 'plpgsql' STRICT;

/**
 -- CharacterData.deleteData(offset, count)
 -- deleteData(CharacterDataNode INTEGER, offset INTEGER, count INTEGER)::BOOLEAN
 */
CREATE OR REPLACE FUNCTION deleteData (INTEGER, INTEGER, INTEGER) RETURNS BOOLEAN AS '
    DECLARE
    	V_RES INTEGER;
        V_TRG_NODE ALIAS FOR $1;
        V_OFFSET INTEGER;
    	V_COUNT ALIAS FOR $3;
    BEGIN
    	V_OFFSET = $2+1;
        IF V_OFFSET < 1 OR V_COUNT < 0 THEN
            RAISE EXCEPTION ''INDEX_SIZE_ERR'';
        END IF;
        SELECT INTO V_RES id FROM xml_node
        	WHERE id=V_TRG_NODE AND (kind=getNodeType(''TEXT'') OR kind=getNodeType(''COMMENT''));
        IF NOT FOUND THEN
            RAISE NOTICE ''Node type must be comment or text --> %'',V_TRG_NODE;
        END IF;
        UPDATE xml_node SET value = overlay(value placing '''' from V_OFFSET for V_COUNT) WHERE id = V_TRG_NODE;
        RETURN TRUE;
	END;
' LANGUAGE 'plpgsql' STRICT;

/**
 -- caution!! this function is stupid. will be repaced with c function.
 -- CharacterData.insertData(offset, arg)
 -- insertData(charctorDataNode INTEGER, offset INTEGER, arg VARCHAR)::BOOLEAN
 */
CREATE OR REPLACE FUNCTION insertData (INTEGER, INTEGER, VARCHAR) RETURNS BOOLEAN AS '
    DECLARE
    	V_RES INTEGER;
        V_TRG_NODE ALIAS FOR $1;
        V_OFFSET ALIAS FOR $2;
    	V_ARG ALIAS FOR $3;
    BEGIN
        IF V_OFFSET < 1 THEN
            RAISE EXCEPTION ''INDEX_SIZE_ERR'';
        END IF;
        SELECT INTO V_RES id FROM xml_node
        	WHERE id=V_TRG_NODE AND (kind=getNodeType(''TEXT'') OR kind=getNodeType(''COMMENT''));
        IF NOT FOUND THEN
            RAISE NOTICE ''Node type must be comment or text --> %'',V_TRG_NODE;
        END IF;
        UPDATE xml_node SET value = substr(value,1,V_OFFSET) || V_ARG || substr(value,V_OFFSET) WHERE id = V_TRG_NODE;
        RETURN TRUE;
	END;
' LANGUAGE 'plpgsql' STRICT;

/**
 -- CharacterData.replaceData(offset, count, arg)
 -- replaceData(CharacterDataNode INTEGER, offset INTEGER, count INTEGER, arg VARCHAR)::BOOLEAN
 */
CREATE OR REPLACE FUNCTION replaceData (INTEGER, INTEGER, INTEGER, VARCHAR) RETURNS BOOLEAN AS '
    DECLARE
    	V_RES INTEGER;
        V_TRG_NODE ALIAS FOR $1;
        V_OFFSET INTEGER;
    	V_COUNT ALIAS FOR $3;
    	V_ARG ALIAS FOR $4;
    BEGIN
    	V_OFFSET = $2+1;
        IF V_OFFSET < 1 OR V_COUNT < 0 THEN
            RAISE EXCEPTION ''INDEX_SIZE_ERR'';
        END IF;
        SELECT INTO V_RES id FROM xml_node
        	WHERE id=V_TRG_NODE AND (kind=getNodeType(''TEXT'') OR kind=getNodeType(''COMMENT''));
        IF NOT FOUND THEN
            RAISE NOTICE ''Node type must be comment or text --> %'',V_TRG_NODE;
        END IF;
        UPDATE xml_node SET value = overlay(value placing V_ARG from V_OFFSET for V_COUNT) WHERE id = V_TRG_NODE;
        RETURN TRUE;
	END;
' LANGUAGE 'plpgsql' STRICT;

/**
 -- CharacterData.substringData(offset, count)
 -- substringData(CharacterDataNode INTEGER, offset INTEGER, count INTEGER)::BOOLEAN
 -- Extracts a range of data from the node.
 */
CREATE OR REPLACE FUNCTION substringData (INTEGER, INTEGER, INTEGER) RETURNS VARCHAR AS '
	SELECT
	    substring(value from $2 + 1 for $3)
	FROM
	    xml_node
	WHERE
	    id = $1 AND
	    (kind=getNodeType(''TEXT'') OR kind=getNodeType(''COMMENT''));
' LANGUAGE 'SQL' STABLE STRICT;


--------------------------------------------------------------------------
-- Interface TreeWalker
--------------------------------------------------------------------------

/**
 -- getFirstChild(curnode INTEGER)::INTEGER
 */
CREATE OR REPLACE FUNCTION getFirstChild(INTEGER) RETURNS INTEGER AS '
	SELECT child
	FROM xml_node
	WHERE id = $1;
' LANGUAGE 'SQL' STABLE STRICT;

/**
 -- getNextSibling(curnode INTEGER)::INTEGER
 */
CREATE OR REPLACE FUNCTION getNextSibling(INTEGER) RETURNS INTEGER AS '
	SELECT next
	FROM xml_node
	WHERE id = $1;
' LANGUAGE 'SQL' STABLE STRICT;