SELECT DISTINCT
    xn3.docid,
    xn3.id
FROM
    xml_path xp2,
    xml_node xn2,
    xml_node xn3
WHERE
    xp2.pathexp LIKE '#%/closed_auction' AND
    xn2.pathid = xp2.pathid AND
    xn3.parent = xn2.parent AND
    xn2.dewey < xn3.dewey AND
--    xn3.kind > 0 AND
--    xn3.kind < 5 AND
    xn3.kind = '1'

QUERY PLAN
Unique  (cost=2098.71..2127.17 rows=379 width=134) (actual time=25545.38..26718.03 rows=974 loops=1)
  ->  Sort  (cost=2098.71..2108.20 rows=3795 width=134) (actual time=25545.38..26204.50 rows=474825 loops=1)
        Sort Key: xn3.docid, xn3.id
        ->  Nested Loop  (cost=0.00..1873.13 rows=3795 width=134) (actual time=37.59..14673.28 rows=474825 loops=1)
              Join Filter: ("outer".dewey < "inner".dewey)
              ->  Nested Loop  (cost=0.00..320.74 rows=454 width=67) (actual time=28.68..48.88 rows=975 loops=1)
                    ->  Seq Scan on xml_path xp2  (cost=0.00..27.77 rows=1 width=4) (actual time=28.58..30.68 rows=1 loops=1)
                          Filter: (pathexp ~~ '#%/closed_auction'::text)
                    ->  Index Scan using xml_node_pathid on xml_node xn2  (cost=0.00..283.87 rows=728 width=63) (actual time=0.09..11.50 rows=975 loops=1)
                          Index Cond: (xn2.pathid = "outer".pathid)
              ->  Index Scan using xml_node_parent on xml_node xn3  (cost=0.00..3.37 rows=4 width=67) (actual time=0.05..11.86 rows=975 loops=975)
                    Index Cond: (xn3.parent = "outer".parent)
                    Filter: (kind = 1::smallint)
Total runtime: 29198.56 msec

SELECT DISTINCT
    xn3.docid,
    xn3.id
FROM
    xml_path xp2,
    xml_node xn2,
    xml_node xn3
WHERE
--    xp2.pathexp LIKE '#%/closed_auction' AND
    xp2.pathexp LIKE '#/site#/closed_auction' AND
    xn2.pathid = xp2.pathid AND
    xn3.parent = xn2.parent AND
    xn2.dewey < xn3.dewey AND
--    xn3.kind > 0 AND
--    xn3.kind < 5 AND
    xn3.kind = '1'

QUERY PLAN
Unique  (cost=2098.71..2127.17 rows=379 width=134) (actual time=3.96..3.96 rows=0 loops=1)
  ->  Sort  (cost=2098.71..2108.20 rows=3795 width=134) (actual time=3.96..3.96 rows=0 loops=1)
        Sort Key: xn3.docid, xn3.id
        ->  Nested Loop  (cost=0.00..1873.13 rows=3795 width=134) (actual time=3.89..3.89 rows=0 loops=1)
              Join Filter: ("outer".dewey < "inner".dewey)
              ->  Nested Loop  (cost=0.00..320.74 rows=454 width=67) (actual time=3.89..3.89 rows=0 loops=1)
                    ->  Seq Scan on xml_path xp2  (cost=0.00..27.77 rows=1 width=4) (actual time=3.88..3.88 rows=0 loops=1)
                          Filter: (pathexp ~~ '#/site#/closed_auction'::text)
                    ->  Index Scan using xml_node_pathid on xml_node xn2  (cost=0.00..283.87 rows=728 width=63) (never executed)
                          Index Cond: (xn2.pathid = "outer".pathid)
              ->  Index Scan using xml_node_parent on xml_node xn3  (cost=0.00..3.37 rows=4 width=67) (never executed)
                    Index Cond: (xn3.parent = "outer".parent)
                    Filter: (kind = 1::smallint)
Total runtime: 4.16 msec


set enable_nestloop to off;

QUERY PLAN
Unique  (cost=32471.58..32500.04 rows=379 width=134) (actual time=15271.46..16430.01 rows=974 loops=1)
  ->  Sort  (cost=32471.58..32481.07 rows=3795 width=134) (actual time=15271.45..15918.63 rows=474825 loops=1)
        Sort Key: xn3.docid, xn3.id
        ->  Hash Join  (cost=15677.13..32246.00 rows=3795 width=134) (actual time=4797.05..8124.66 rows=474825 loops=1)
              Hash Cond: ("outer".parent = "inner".parent)
              Join Filter: ("inner".dewey < "outer".dewey)
              ->  Seq Scan on xml_node xn3  (cost=0.00..14483.12 rows=153199 width=67) (actual time=0.10..1785.67 rows=167864 loops=1)
                    Filter: (kind = 1::smallint)
              ->  Hash  (cost=15676.00..15676.00 rows=454 width=67) (actual time=2985.81..2985.81 rows=0 loops=1)
                    ->  Hash Join  (cost=27.78..15676.00 rows=454 width=67) (actual time=2651.88..2983.94 rows=975 loops=1)
                          Hash Cond: ("outer".pathid = "inner".pathid)
                          ->  Seq Scan on xml_node xn2  (cost=0.00..13323.70 rows=463770 width=63) (actual time=0.09..2331.34 rows=510947 loops=1)
                          ->  Hash  (cost=27.77..27.77 rows=1 width=4) (actual time=16.98..16.98 rows=0 loops=1)
                                ->  Seq Scan on xml_path xp2  (cost=0.00..27.77 rows=1 width=4) (actual time=14.96..16.98 rows=1 loops=1)
                                      Filter: (pathexp ~~ '#%/closed_auction'::text)
Total runtime: 18778.17 msec

set enable_nestloop to on;