.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "CREATE OPERATOR" "l" "2002-11-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE OPERATOR \- define a new operator
.SH SYNOPSIS
.sp
.nf
CREATE OPERATOR \fIname\fR ( PROCEDURE = \fIfunc_name\fR
     [, LEFTARG = \fIlefttype\fR
     ] [, RIGHTARG = \fIrighttype\fR ]
     [, COMMUTATOR = \fIcom_op\fR ] [, NEGATOR = \fIneg_op\fR ]
     [, RESTRICT = \fIres_proc\fR ] [, JOIN = \fIjoin_proc\fR ]
     [, HASHES ] [, MERGES ]
     [, SORT1 = \fIleft_sort_op\fR ] [, SORT2 = \fIright_sort_op\fR ]
     [, LTCMP = \fIless_than_op\fR ] [, GTCMP = \fIgreater_than_op\fR ] )
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The operator to be defined. See below for allowable characters.
The name may be schema-qualified, for example
CREATE OPERATOR myschema.+ (...).
.TP
\fB\fIfunc_name\fB\fR
The function used to implement this operator.
.TP
\fB\fIlefttype\fB\fR
The type of the left-hand argument of the operator, if any.
This option would be omitted for a left-unary operator.
.TP
\fB\fIrighttype\fB\fR
The type of the right-hand argument of the operator, if any.
This option would be omitted for a right-unary operator.
.TP
\fB\fIcom_op\fB\fR
The commutator of this operator.
.TP
\fB\fIneg_op\fB\fR
The negator of this operator.
.TP
\fB\fIres_proc\fB\fR
The restriction selectivity estimator function for this operator.
.TP
\fB\fIjoin_proc\fB\fR
The join selectivity estimator function for this operator.
.TP
\fBHASHES\fR
Indicates this operator can support a hash join.
.TP
\fBMERGES\fR
Indicates this operator can support a merge join.
.TP
\fB\fIleft_sort_op\fB\fR
If this operator can support a merge join, the less-than
operator that sorts the left-hand data type of this operator.
.TP
\fB\fIright_sort_op\fB\fR
If this operator can support a merge join, the less-than
operator that sorts the right-hand data type of this operator.
.TP
\fB\fIless_than_op\fB\fR
If this operator can support a merge join, the less-than
operator that compares the input data types of this operator.
.TP
\fB\fIgreater_than_op\fB\fR
If this operator can support a merge join, the greater-than
operator that compares the input data types of this operator.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE OPERATOR\fR
Message returned if the operator is successfully created.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE OPERATOR\fR defines a new operator,
\fIname\fR.
The user who defines an operator becomes its owner.
.PP
If a schema name is given then the operator is created in the
specified schema. Otherwise it is created in the current schema (the one
at the front of the search path; see CURRENT_SCHEMA()).
.PP
Two operators in the same schema can have the same name if they operate on
different data types. This is called \fIoverloading\fR. The
system will attempt to pick the intended operator based on the actual
input data types when there is ambiguity.
.PP
The operator \fIname\fR
is a sequence of up to \fBNAMEDATALEN\fR-1 (63 by default) characters
from the following list:
.sp
.nf
+ - * / < > = ~ ! @ # % ^ & | ` ? $
   
.sp
.fi
There are a few restrictions on your choice of name:
.TP 0.2i
\(bu
$ cannot be defined as a single-character operator,
although it can be part of a multicharacter operator name.
.TP 0.2i
\(bu
-- and /* cannot appear anywhere in an operator name,
since they will be taken as the start of a comment.
.TP 0.2i
\(bu
A multicharacter operator name cannot end in + or
-,
unless the name also contains at least one of these characters:
.sp
.nf
~ ! @ # % ^ & | ` ? $
     
.sp
.fi
For example, @- is an allowed operator name,
but *- is not.
This restriction allows PostgreSQL to
parse SQL-compliant queries without requiring spaces between tokens.
.PP
.sp
.RS
.B "Note:"
When working with non-SQL-standard operator names, you will usually
need to separate adjacent operators with spaces to avoid ambiguity.
For example, if you have defined a left-unary operator named @,
you cannot write X*@Y; you must write
X* @Y to ensure that
PostgreSQL reads it as two operator names
not one.
.PP
.RE
.sp
.PP
The operator != is mapped to <> on input, so these two names
are always equivalent.
.PP
At least one of LEFTARG and RIGHTARG must be defined. For
binary operators, both should be defined. For right unary
operators, only LEFTARG should be defined, while for left
unary operators only RIGHTARG should be defined.
.PP
The
\fIfunc_name\fR procedure must have
been previously defined using \fBCREATE FUNCTION\fR and must
be defined to accept the correct number of arguments
(either one or two) of the indicated types.
.PP
The commutator operator should be identified if one exists,
so that PostgreSQL can
reverse the order of the operands if it wishes.
For example, the operator area-less-than, <<<,
would probably have a commutator
operator, area-greater-than, >>>.
Hence, the query optimizer could freely convert:
.sp
.nf
box '((0,0), (1,1))'  >>> MYBOXES.description
   
.sp
.fi
to
.sp
.nf
MYBOXES.description <<< box '((0,0), (1,1))'
   
.sp
.fi
.PP
This allows the execution code to always use the latter
representation and simplifies the query optimizer somewhat.
.PP
Similarly, if there is a negator operator then it should be
identified.
Suppose that an
operator, area-equal, ===, exists, as well as an area not
equal, !==.
The negator link allows the query optimizer to simplify
.sp
.nf
NOT MYBOXES.description === box '((0,0), (1,1))'
   
.sp
.fi
to
.sp
.nf
MYBOXES.description !== box '((0,0), (1,1))'
   
.sp
.fi
.PP
If a commutator operator name is supplied, 
PostgreSQL
searches for it in the catalog. If it is found and it
does not yet have a commutator itself, then the commutator's
entry is updated to have the newly created operator as its
commutator. This applies to the negator, as well.
This is to allow the definition of two operators that are
the commutators or the negators of each other. The first
operator should be defined without a commutator or negator
(as appropriate). When the second operator is defined,
name the first as the commutator or negator. The first
will be updated as a side effect. (As of
\fBPostgreSQL\fR 6.5, 
it also works to just have both operators refer to each other.)
.PP
The HASHES, MERGES, SORT1,
SORT2, LTCMP, and GTCMP options
are present to support the query optimizer in performing joins.
PostgreSQL can always evaluate a join
(i.e., processing a clause with two tuple variables separated by an
operator that returns a \fBboolean\fR) by iterative
substitution . In addition,
PostgreSQL can use a hash-join algorithm
; however, it must know whether this
strategy is applicable. The current hash-join algorithm is only
correct for operators that represent equality tests; furthermore,
equality of the data type must mean bitwise equality of the
representation of the type. (For example, a data type that
contains unused bits that don't matter for equality tests could not
be hash-joined.) The HASHES flag indicates to the query optimizer
that a hash join may safely be used with this operator.
.PP
Similarly, the MERGES flag indicates whether merge-sort
is a usable join strategy for this operator. A merge join requires
that the two input data types have consistent orderings, and that
the merge-join operator behave like equality with respect to that
ordering. For example, it is possible to merge-join equality
between an integer and a float variable by sorting both inputs in
ordinary numeric order. Execution of a merge join requires that
the system be able to identify four operators related to the
merge-join equality operator: less-than comparison for the left
input data type, less-than comparison for the right input data
type, less-than comparison between the two data types, and
greater-than comparison between the two data types. It is possible
to specify these by name, as the SORT1,
SORT2, LTCMP, and GTCMP options
respectively. The system will fill in the default names
<, <, <,
> respectively if any of these are omitted when
MERGES is specified. Also, MERGES will be
assumed to be implied if any of these four operator options appear.
.PP
If other join strategies are found to be practical,
PostgreSQL
will change the optimizer and run-time system to use
them and will require additional specification when an
operator is defined. Fortunately, the research community
invents new join strategies infrequently, and the added
generality of user-defined join strategies was not felt to
be worth the complexity involved.
.PP
The RESTRICT and JOIN options assist the
query optimizer in estimating result sizes. If a clause of the
form:
.sp
.nf
myboxes.description <<< box '((0,0), (1,1))'
.sp
.fi
is present in the qualification,
then PostgreSQL may have to
estimate the fraction of the instances in myboxes that
satisfy the clause. The function
\fIres_proc\fR
must be a registered function (meaning it is already defined using
\fBCREATE FUNCTION\fR) which accepts arguments of the correct
data types and returns a floating-point number. The
query optimizer simply calls this function, passing the
parameter ((0,0), (1,1)) and multiplies the result by the relation
size to get the expected number of instances.
.PP
Similarly, when the operands of the operator both contain
instance variables, the query optimizer must estimate the
size of the resulting join. The function \fBjoin_proc\fR will
return another floating-point number which will be multiplied
by the cardinalities of the two tables involved to
compute the expected result size.
.PP
The difference between the function
.sp
.nf
my_procedure_1 (MYBOXES.description, box '((0,0), (1,1))')
   
.sp
.fi
and the operator
.sp
.nf
MYBOXES.description === box '((0,0), (1,1))'
   
.sp
.fi
is that PostgreSQL
attempts to optimize operators and can
decide to use an index to restrict the search space when
operators are involved. However, there is no attempt to
optimize functions, and they are performed by brute force.
Moreover, functions can have any number of arguments while
operators are restricted to one or two.
.SS "NOTES"
.PP
Refer to the chapter on operators in the
\fIPostgreSQL User's Guide\fR
for further information.
Refer to \fBDROP OPERATOR\fR to delete
user-defined operators from a database.
.PP
To give a schema-qualified operator name in \fIcom_op\fR or the other optional
arguments, use the OPERATOR() syntax, for example
.sp
.nf
   COMMUTATOR = OPERATOR(myschema.===) ,
.sp
.fi
.SH "USAGE"
.PP
The following command defines a new operator,
area-equality, for the BOX data type:
.sp
.nf
CREATE OPERATOR === (
   LEFTARG = box,
   RIGHTARG = box,
   PROCEDURE = area_equal_procedure,
   COMMUTATOR = ===,
   NEGATOR = !==,
   RESTRICT = area_restriction_procedure,
   JOIN = area_join_procedure,
   HASHES,
   SORT1 = <<<,
   SORT2 = <<<
   -- Since sort operators were given, MERGES is implied.
   -- LTCMP and GTCMP are assumed to be < and > respectively
);
  
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
\fBCREATE OPERATOR\fR
is a PostgreSQL extension.
There is no \fBCREATE OPERATOR\fR
statement in SQL92.
