.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE TABLE" "" "2008-01-03" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE TABLE \- define a new table

.SH SYNOPSIS
.sp
.nf
CREATE [ [ GLOBAL | LOCAL ] { TEMPORARY | TEMP } ] TABLE \fItable_name\fR (
  { \fIcolumn_name\fR \fIdata_type\fR [ DEFAULT \fIdefault_expr\fR ] [ \fIcolumn_constraint\fR [ ... ] ]
    | \fItable_constraint\fR
    | LIKE \fIparent_table\fR [ { INCLUDING | EXCLUDING } DEFAULTS ] }  [, ... ]
)
[ INHERITS ( \fIparent_table\fR [, ... ] ) ]
[ WITH OIDS | WITHOUT OIDS ]
[ ON COMMIT { PRESERVE ROWS | DELETE ROWS | DROP } ]

where \fIcolumn_constraint\fR is:

[ CONSTRAINT \fIconstraint_name\fR ]
{ NOT NULL | NULL | UNIQUE | PRIMARY KEY |
  CHECK (\fIexpression\fR) |
  REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR ) ] [ MATCH FULL | MATCH PARTIAL | MATCH SIMPLE ]
    [ ON DELETE \fIaction\fR ] [ ON UPDATE \fIaction\fR ] }
[ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]

and \fItable_constraint\fR is:

[ CONSTRAINT \fIconstraint_name\fR ]
{ UNIQUE ( \fIcolumn_name\fR [, ... ] ) |
  PRIMARY KEY ( \fIcolumn_name\fR [, ... ] ) |
  CHECK ( \fIexpression\fR ) |
  FOREIGN KEY ( \fIcolumn_name\fR [, ... ] ) REFERENCES \fIreftable\fR [ ( \fIrefcolumn\fR [, ... ] ) ]
    [ MATCH FULL | MATCH PARTIAL | MATCH SIMPLE ] [ ON DELETE \fIaction\fR ] [ ON UPDATE \fIaction\fR ] }
[ DEFERRABLE | NOT DEFERRABLE ] [ INITIALLY DEFERRED | INITIALLY IMMEDIATE ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE TABLE\fR will create a new, initially empty table
in the current database. The table will be owned by the user issuing the
command.
.PP
If a schema name is given (for example, CREATE TABLE
myschema.mytable ...) then the table is created in the
specified schema. Otherwise it is created in the current schema.
Temporary tables exist in a special schema, so a schema name may not be
given when creating a temporary table.
The table name must be distinct from the name of any other table,
sequence, index, or view in the same schema.
.PP
\fBCREATE TABLE\fR also automatically creates a data
type that represents the composite type corresponding
to one row of the table. Therefore, tables cannot have the same
name as any existing data type in the same schema.
.PP
A table cannot have more than 1600 columns. (In practice, the
effective limit is lower because of tuple-length constraints).
.PP
The optional constraint clauses specify constraints (or tests) that
new or updated rows must satisfy for an insert or update operation
to succeed. A constraint is an SQL object that helps define the
set of valid values in the table in various ways.
.PP
There are two ways to define constraints: table constraints and
column constraints. A column constraint is defined as part of a
column definition. A table constraint definition is not tied to a
particular column, and it can encompass more than one column.
Every column constraint can also be written as a table constraint;
a column constraint is only a notational convenience if the
constraint only affects one column.
.SH "PARAMETERS"
.TP
\fBTEMPORARY or TEMP\fR
If specified, the table is created as a temporary table.
Temporary tables are automatically dropped at the end of a
session, or optionally at the end of the current transaction 
(see ON COMMIT below). Existing permanent tables with the same 
name are not visible to the current session while the temporary 
table exists, unless they are referenced with schema-qualified 
names. Any indexes created on a temporary table are automatically
temporary as well.

Optionally, GLOBAL or LOCAL
can be written before TEMPORARY or TEMP.
This makes no difference in PostgreSQL, but see
Compatibility [\fBcreate_table\fR(l)].
.TP
\fB\fItable_name\fB\fR
The name (optionally schema-qualified) of the table to be created.
.TP
\fB\fIcolumn_name\fB\fR
The name of a column to be created in the new table.
.TP
\fB\fIdata_type\fB\fR
The data type of the column. This may include array specifiers.
.TP
\fBDEFAULT\fR
The DEFAULT clause assigns a default data value for
the column whose column definition it appears within. The value
is any variable-free expression (subqueries and cross-references
to other columns in the current table are not allowed). The
data type of the default expression must match the data type of the
column.

The default expression will be used in any insert operation that
does not specify a value for the column. If there is no default
for a column, then the default is null.
.TP
\fBLIKE \fIparent_table\fB [ { INCLUDING | EXCLUDING } DEFAULTS ]\fR
The LIKE clause specifies a table from which
the new table automatically inherits all column names, their data types, and
not-null constraints.

Unlike INHERITS, the new table and inherited table
are complete decoupled after creation has been completed. Data inserted
into the new table will not be reflected into the parent table.

Default expressions for the inherited column definitions will only be included if
INCLUDING DEFAULTS is specified. The default is to exclude
default expressions.
.TP
\fBINHERITS ( \fIparent_table\fB [, ... ] )\fR
The optional INHERITS clause specifies a list of
tables from which the new table automatically inherits all
columns. If the same column name exists in more than one parent
table, an error is reported unless the data types of the columns
match in each of the parent tables. If there is no conflict,
then the duplicate columns are merged to form a single column in
the new table. If the column name list of the new table
contains a column that is also inherited, the data type must
likewise match the inherited column(s), and the column
definitions are merged into one. However, inherited and new
column declarations of the same name need not specify identical
constraints: all constraints provided from any declaration are
merged together and all are applied to the new table. If the
new table explicitly specifies a default value for the column,
this default overrides any defaults from inherited declarations
of the column. Otherwise, any parents that specify default
values for the column must all specify the same default, or an
error will be reported.
.TP
\fBWITH OIDS\fR
.TP
\fBWITHOUT OIDS\fR
This optional clause specifies whether rows of the new table
should have OIDs (object identifiers) assigned to them. The
default is to have OIDs. (If the new table inherits from any
tables that have OIDs, then WITH OIDS is forced even
if the command says WITHOUT OIDS.)

Specifying WITHOUT OIDS allows the user to suppress
generation of OIDs for rows of a table. This may be worthwhile
for large tables, since it will reduce OID consumption and
thereby postpone wraparound of the 32-bit OID counter. Once the
counter wraps around, uniqueness of OIDs can no longer be
assumed, which considerably reduces their usefulness. Specifying
WITHOUT OIDS also reduces the space required
to store the table on disk by 4 bytes per row of the table,
thereby improving performance.
.TP
\fBCONSTRAINT \fIconstraint_name\fB\fR
An optional name for a column or table constraint. If not specified,
the system generates a name.
.TP
\fBNOT NULL\fR
The column is not allowed to contain null values.
.TP
\fBNULL\fR
The column is allowed to contain null values. This is the default.

This clause is only available for compatibility with
non-standard SQL databases. Its use is discouraged in new
applications.
.TP
\fBUNIQUE (column constraint)\fR
.TP
\fBUNIQUE ( \fIcolumn_name\fB [, ... ] ) (table constraint)\fR
The UNIQUE constraint specifies that a
group of one or more distinct columns of a table may contain
only unique values. The behavior of the unique table constraint
is the same as that for column constraints, with the additional
capability to span multiple columns.

For the purpose of a unique constraint, null values are not
considered equal.

Each unique table constraint must name a set of columns that is
different from the set of columns named by any other unique or
primary key constraint defined for the table. (Otherwise it
would just be the same constraint listed twice.)
.TP
\fBPRIMARY KEY (column constraint)\fR
.TP
\fBPRIMARY KEY ( \fIcolumn_name\fB [, ... ] ) (table constraint)\fR
The primary key constraint specifies that a column or columns of a table
may contain only unique (non-duplicate), nonnull values.
Technically, PRIMARY KEY is merely a
combination of UNIQUE and NOT NULL, but
identifying a set of columns as primary key also provides
metadata about the design of the schema, as a primary key
implies that other tables
may rely on this set of columns as a unique identifier for rows.

Only one primary key can be specified for a table, whether as a
column constraint or a table constraint.

The primary key constraint should name a set of columns that is
different from other sets of columns named by any unique
constraint defined for the same table.
.TP
\fBCHECK (\fIexpression\fB)\fR
The CHECK clause specifies an expression producing a
Boolean result which new or updated rows must satisfy for an
insert or update operation to succeed. A check constraint
specified as a column constraint should reference that column's
value only, while an expression appearing in a table constraint
may reference multiple columns.

Currently, CHECK expressions cannot contain
subqueries nor refer to variables other than columns of the
current row.
.TP
\fBREFERENCES \fIreftable\fB [ ( \fIrefcolumn\fB ) ] [ MATCH \fImatchtype\fB ] [ ON DELETE \fIaction\fB ] [ ON UPDATE \fIaction\fB ] (column constraint)\fR
.TP
\fBFOREIGN KEY ( \fIcolumn\fB [, ... ] )\fR
Theses clauses specify a foreign key constraint, which specifies
that a group of one or more columns of the new table must only
contain values which match against values in the referenced
column(s) \fIrefcolumn\fR
of the referenced table \fIreftable\fR. If \fIrefcolumn\fR is omitted, the
primary key of the \fIreftable\fR is used. The
referenced columns must be the columns of a unique or primary
key constraint in the referenced table.

A value inserted into these columns is matched against the
values of the referenced table and referenced columns using the
given match type. There are three match types: MATCH
FULL, MATCH PARTIAL, and MATCH
SIMPLE, which is also the default. MATCH
FULL will not allow one column of a multicolumn foreign key
to be null unless all foreign key columns are null.
MATCH SIMPLE allows some foreign key columns
to be null while other parts of the foreign key are not
null. MATCH PARTIAL is not yet implemented.

In addition, when the data in the referenced columns is changed,
certain actions are performed on the data in this table's
columns. The ON DELETE clause specifies the
action to perform when a referenced row in the referenced table is
being deleted. Likewise, the ON UPDATE
clause specifies the action to perform when a referenced column
in the referenced table is being updated to a new value. If the
row is updated, but the referenced column is not actually
changed, no action is done. There are the following possible
actions for each clause:
.RS
.TP
\fBNO ACTION\fR
Produce an error indicating that the deletion or update
would create a foreign key constraint violation. This is
the default action.
.TP
\fBRESTRICT\fR
Same as NO ACTION except that this action
will not be deferred even if the rest of the constraint is
deferrable and deferred.
.TP
\fBCASCADE\fR
Delete any rows referencing the deleted row, or update the
value of the referencing column to the new value of the
referenced column, respectively.
.TP
\fBSET NULL\fR
Set the referencing column values to null.
.TP
\fBSET DEFAULT\fR
Set the referencing column values to their default value.
.RE
.PP

If primary key column is updated frequently, it may be wise to
add an index to the foreign key column so that NO
ACTION and CASCADE actions
associated with the foreign key column can be more efficiently
performed.
.TP
\fBDEFERRABLE\fR
.TP
\fBNOT DEFERRABLE\fR
This controls whether the constraint can be deferred. A
constraint that is not deferrable will be checked immediately
after every command. Checking of constraints that are
deferrable may be postponed until the end of the transaction
(using the SET CONSTRAINTS [\fBset_constraints\fR(l)] command).
NOT DEFERRABLE is the default. Only foreign
key constraints currently accept this clause. All other
constraint types are not deferrable.
.TP
\fBINITIALLY IMMEDIATE\fR
.TP
\fBINITIALLY DEFERRED\fR
If a constraint is deferrable, this clause specifies the default
time to check the constraint. If the constraint is
INITIALLY IMMEDIATE, it is checked after each
statement. This is the default. If the constraint is
INITIALLY DEFERRED, it is checked only at the
end of the transaction. The constraint check time can be
altered with the SET CONSTRAINTS [\fBset_constraints\fR(l)] command.
.TP
\fBON COMMIT\fR
The behavior of temporary tables at the end of a transaction
block can be controlled using ON COMMIT. 
The three options are:
.RS
.TP
\fBPRESERVE ROWS\fR
No special action is taken at the ends of transactions.
This is the default behavior.
.TP
\fBDELETE ROWS\fR
All rows in the temporary table will be deleted at the
end of each transaction block. Essentially, an automatic
\fBtruncate\fR(l) is done at each commit.
.TP
\fBDROP\fR
The temporary table will be dropped at the end of the current
transaction block.
.RE
.PP
.SH "NOTES"
.TP 0.2i
\(bu
Whenever an application makes use of OIDs to identify specific
rows of a table, it is recommended to create a unique constraint
on the \fBoid\fR column of that table, to ensure that
OIDs in the table will indeed uniquely identify rows even after
counter wraparound. Avoid assuming that OIDs are unique across
tables; if you need a database-wide unique identifier, use the
combination of \fBtableoid\fR and row OID for the
purpose. (It is likely that future PostgreSQL
releases will use a separate OID counter for each table, so that
it will be \fBnecessary\fR, not optional, to include
\fBtableoid\fR to have a unique identifier
database-wide.)
.sp
.RS
.B "Tip:"
The use of WITHOUT OIDS is not recommended
for tables with no primary key, since without either an OID or a
unique data key, it is difficult to identify specific rows.
.RE
.sp
.TP 0.2i
\(bu
PostgreSQL automatically creates an
index for each unique constraint and primary key constraint to
enforce the uniqueness. Thus, it is not necessary to create an
explicit index for primary key columns. (See CREATE INDEX [\fBcreate_index\fR(l)] for more information.)
.TP 0.2i
\(bu
Unique constraints and primary keys are not inherited in the
current implementation. This makes the combination of
inheritance and unique constraints rather dysfunctional.
.SH "EXAMPLES"
.PP
Create table \fBfilms\fR and table
\fBdistributors\fR:
.sp
.nf
CREATE TABLE films (
    code        char(5) CONSTRAINT firstkey PRIMARY KEY,
    title       varchar(40) NOT NULL,
    did         integer NOT NULL,
    date_prod   date,
    kind        varchar(10),
    len         interval hour to minute
);
.sp
.fi
.sp
.nf
CREATE TABLE distributors (
     did    integer PRIMARY KEY DEFAULT nextval('serial'),
     name   varchar(40) NOT NULL CHECK (name <> '')
);
.sp
.fi
.PP
Create a table with a 2-dimensional array:
.sp
.nf
CREATE TABLE array (
    vector  int[][]
);
.sp
.fi
.PP
Define a unique table constraint for the table
films. Unique table constraints can be defined
on one or more columns of the table.
.sp
.nf
CREATE TABLE films (
    code        char(5),
    title       varchar(40),
    did         integer,
    date_prod   date,
    kind        varchar(10),
    len         interval hour to minute,
    CONSTRAINT production UNIQUE(date_prod)
);
.sp
.fi
.PP
Define a check column constraint:
.sp
.nf
CREATE TABLE distributors (
    did     integer CHECK (did > 100),
    name    varchar(40)
);
.sp
.fi
.PP
Define a check table constraint:
.sp
.nf
CREATE TABLE distributors (
    did     integer,
    name    varchar(40)
    CONSTRAINT con1 CHECK (did > 100 AND name <> '')
);
.sp
.fi
.PP
Define a primary key table constraint for the table
\fBfilms\fR. Primary key table constraints can be defined
on one or more columns of the table.
.sp
.nf
CREATE TABLE films (
    code        char(5),
    title       varchar(40),
    did         integer,
    date_prod   date,
    kind        varchar(10),
    len         interval hour to minute,
    CONSTRAINT code_title PRIMARY KEY(code,title)
);
.sp
.fi
.PP
Define a primary key constraint for table
\fBdistributors\fR. The following two examples are
equivalent, the first using the table constraint syntax, the second
the column constraint notation.
.sp
.nf
CREATE TABLE distributors (
    did     integer,
    name    varchar(40),
    PRIMARY KEY(did)
); 
.sp
.fi
.sp
.nf
CREATE TABLE distributors (
    did     integer PRIMARY KEY,
    name    varchar(40)
);
.sp
.fi
.PP
This assigns a literal constant default value for the column
name, arranges for the default value of column
did to be generated by selecting the next value
of a sequence object, and makes the default value of
modtime be the time at which the row is
inserted.
.sp
.nf
CREATE TABLE distributors (
    name      varchar(40) DEFAULT 'Luso Films',
    did       integer DEFAULT nextval('distributors_serial'),
    modtime   timestamp DEFAULT current_timestamp
);
.sp
.fi
.PP
Define two NOT NULL column constraints on the table
\fBdistributors\fR, one of which is explicitly
given a name:
.sp
.nf
CREATE TABLE distributors (
    did     integer CONSTRAINT no_null NOT NULL,
    name    varchar(40) NOT NULL
);
.sp
.fi
.PP
Define a unique constraint for the name column:
.sp
.nf
CREATE TABLE distributors (
    did     integer,
    name    varchar(40) UNIQUE
);
.sp
.fi
The above is equivalent to the following specified as a table constraint:
.sp
.nf
CREATE TABLE distributors (
    did     integer,
    name    varchar(40),
    UNIQUE(name)
);
.sp
.fi
.SH "COMPATIBILITY"
.PP
The \fBCREATE TABLE\fR command conforms to SQL92
and to a subset of SQL99, with exceptions listed below.
.SS "TEMPORARY TABLES"
.PP
Although the syntax of CREATE TEMPORARY TABLE
resembles that of the SQL standard, the effect is not the same. In the
standard, 
temporary tables are defined just once and automatically exist (starting
with empty contents) in every session that needs them.
PostgreSQL instead
requires each session to issue its own CREATE TEMPORARY
TABLE command for each temporary table to be used. This allows
different sessions to use the same temporary table name for different
purposes, whereas the standard's approach constrains all instances of a
given temporary table name to have the same table structure.
.PP
The standard's definition of the behavior of temporary tables is
widely ignored. PostgreSQL's behavior
on this point is similar to that of several other SQL databases.
.PP
The standard's distinction between global and local temporary tables
is not in PostgreSQL, since that distinction
depends on the concept of modules, which
PostgreSQL does not have.
For compatibility's sake, PostgreSQL will
accept the GLOBAL and LOCAL keywords
in a temporary table declaration, but they have no effect.
.PP
The ON COMMIT clause for temporary tables
also resembles the SQL standard, but has some differences.
If the ON COMMIT clause is omitted, SQL specifies that the
default behavior is ON COMMIT DELETE ROWS. However, the
default behavior in PostgreSQL is
ON COMMIT PRESERVE ROWS. The ON COMMIT
DROP option does not exist in SQL.
.SS "COLUMN CHECK CONSTRAINTS"
.PP
The SQL standard says that CHECK column constraints
may only refer to the column they apply to; only CHECK
table constraints may refer to multiple columns.
PostgreSQL does not enforce this
restriction; it treats column and table check constraints alike.
.SS "NULL ``CONSTRAINT''"
.PP
The NULL ``constraint'' (actually a
non-constraint) is a PostgreSQL
extension to the SQL standard that is included for compatibility with some
other database systems (and for symmetry with the NOT
NULL constraint). Since it is the default for any
column, its presence is simply noise.
.SS "INHERITANCE"
.PP
Multiple inheritance via the INHERITS clause is
a PostgreSQL language extension. SQL99
(but not SQL92) defines single inheritance using a different
syntax and different semantics. SQL99-style inheritance is not
yet supported by PostgreSQL.
.SS "OBJECT IDS"
.PP
The PostgreSQL concept of OIDs is not
standard.
.SS "ZERO-COLUMN TABLES"
.PP
PostgreSQL allows a table of no columns
to be created (for example, CREATE TABLE foo();). This
is an extension from the SQL standard, which does not allow zero-column
tables. Zero-column tables are not in themselves very useful, but
disallowing them creates odd special cases for \fBALTER TABLE
DROP COLUMN\fR, so it seems cleaner to ignore this spec restriction.
.SH "SEE ALSO"
ALTER TABLE [\fBalter_table\fR(l)], DROP TABLE [\fBdrop_table\fR(l)]
