.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "INSERT" "" "2008-01-03" "SQL - Language Statements" "SQL Commands"
.SH NAME
INSERT \- create new rows in a table

.SH SYNOPSIS
.sp
.nf
INSERT INTO \fItable\fR [ ( \fIcolumn\fR [, ...] ) ]
    { DEFAULT VALUES | VALUES ( { \fIexpression\fR | DEFAULT } [, ...] ) | \fIquery\fR }
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBINSERT\fR allows one to insert new rows into a
table. One can insert
a single row at a time or several rows as a result of a query.
.PP
The columns in the target list may be listed in any order.
Each column not present in the target list will be inserted
using a default value, either its declared default value
or null.
.PP
If the expression for each column is not of the correct data type,
automatic type conversion will be attempted.
.PP
You must have INSERT privilege to a table in
order to insert into it. If you use the \fIquery\fR clause to insert rows from a
query, you also need to have SELECT privilege on
any table used in the query.
.SH "PARAMETERS"
.TP
\fB\fItable\fB\fR
The name (optionally schema-qualified) of an existing table.
.TP
\fB\fIcolumn\fB\fR
The name of a column in \fItable\fR.
.TP
\fBDEFAULT VALUES\fR
All columns will be filled with their default values.
.TP
\fB\fIexpression\fB\fR
An expression or value to assign to \fIcolumn\fR.
.TP
\fBDEFAULT\fR
This column will be filled with its default value.
.TP
\fB\fIquery\fB\fR
A query (\fBSELECT\fR statement) that supplies the
rows to be inserted. Refer to the \fBSELECT\fR
statement for a description of the syntax.
.SH "OUTPUTS"
.PP
On successful completion, an \fBINSERT\fR command returns a command
tag of the form
.sp
.nf
INSERT \fIoid\fR \fIcount\fR
.sp
.fi
The \fIcount\fR is the number
of rows inserted. If \fIcount\fR
is exactly one, and the target table has OIDs, then
\fIoid\fR is the
OID assigned to the inserted row. Otherwise
\fIoid\fR is zero.
.SH "EXAMPLES"
.PP
Insert a single row into table films:
.sp
.nf
INSERT INTO films VALUES
    ('UA502', 'Bananas', 105, '1971-07-13', 'Comedy', '82 minutes');
.sp
.fi
.PP
In this second example, the last column len is
omitted and therefore it will have the default value of null:
.sp
.nf
INSERT INTO films (code, title, did, date_prod, kind)
    VALUES ('T_601', 'Yojimbo', 106, '1961-06-16', 'Drama');
.sp
.fi
.PP
The third example uses the DEFAULT clause for
the date columns rather than specifying a value:
.sp
.nf
INSERT INTO films VALUES
    ('UA502', 'Bananas', 105, DEFAULT, 'Comedy', '82 minutes');
INSERT INTO films (code, title, did, date_prod, kind)
    VALUES ('T_601', 'Yojimbo', 106, DEFAULT, 'Drama');
.sp
.fi
.PP
This examples inserts several rows into table
films from table tmp:
.sp
.nf
INSERT INTO films SELECT * FROM tmp;
.sp
.fi
.PP
This example inserts into array columns:
.sp
.nf
-- Create an empty 3x3 gameboard for noughts-and-crosses
-- (all of these commands create the same board)
INSERT INTO tictactoe (game, board[1:3][1:3])
    VALUES (1,'{{"","",""},{},{"",""}}');
INSERT INTO tictactoe (game, board[3][3])
    VALUES (2,'{}');
INSERT INTO tictactoe (game, board)
    VALUES (3,'{{,,},{,,},{,,}}');
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBINSERT\fR conforms fully to the SQL standard.
Possible limitations of the \fIquery\fR clause are documented under
SELECT [\fBselect\fR(l)].
