.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "LISTEN" "" "2008-01-03" "SQL - Language Statements" "SQL Commands"
.SH NAME
LISTEN \- listen for a notification

.SH SYNOPSIS
.sp
.nf
LISTEN \fIname\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBLISTEN\fR registers the current session as a
listener on the notification condition \fIname\fR.
If the current session is already registered as a listener for
this notification condition, nothing is done.
.PP
Whenever the command \fBNOTIFY \fIname\fB\fR is invoked, either
by this session or another one connected to the same database, all
the sessions currently listening on that notification condition are
notified, and each will in turn notify its connected client
application. See the discussion of \fBNOTIFY\fR for
more information.
.PP
A session can be unregistered for a given notify condition with the
\fBUNLISTEN\fR command. A session's listen
registrations are automatically cleared when the session ends.
.PP
The method a client application must use to detect notification events depends on
which PostgreSQL application programming interface it
uses. With the \fBlibpq\fR library, the application issues
\fBLISTEN\fR as an ordinary SQL command, and then must
periodically call the function \fBPQnotifies\fR to find out
whether any notification events have been received. Other interfaces such as
\fBlibpgtcl\fR provide higher-level methods for handling notify events; indeed,
with \fBlibpgtcl\fR the application programmer should not even issue
\fBLISTEN\fR or \fBUNLISTEN\fR directly. See the
documentation for the interface you are using for more details.
.PP
NOTIFY [\fBnotify\fR(l)]
contains a more extensive
discussion of the use of \fBLISTEN\fR and
\fBNOTIFY\fR.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
Name of a notify condition (any identifier).
.SH "EXAMPLES"
.PP
Configure and execute a listen/notify sequence from
\fBpsql\fR:
.sp
.nf
LISTEN virtual;
NOTIFY virtual;
Asynchronous notification "virtual" received from server process with PID 8448.
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBLISTEN\fR statement in the SQL
standard.
.SH "SEE ALSO"
NOTIFY [\fBnotify\fR(l)], UNLISTEN [\fBunlisten\fR(l)]
