.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "PG_EXECUTE" "" "2008-01-03" "" "PostgreSQL 7.4.19 Documentation"
.SH NAME
pg_execute \- send a query and optionally loop over the results

.SH SYNOPSIS
.sp
.nf
pg_execute [-array \fIarrayVar\fR] [-oid \fIoidVar\fR] \fIconn\fR \fIcommandString\fR [\fIprocedure\fR]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBpg_execute\fR submits a command to the
PostgreSQL server.
.PP
If the command is not a \fBSELECT\fR statement, the
number of rows affected by the command is returned. If the command
is an \fBINSERT\fR statement and a single row is
inserted, the OID of the inserted row is stored in the variable
\fIoidVar\fR if the optional \fI-oid\fR
argument is supplied.
.PP
If the command is a \fBSELECT\fR statement, then, for
each row in the result, the row values are stored in the
\fIarrayVar\fR variable, if supplied, using the
column names as the array indices, else in variables named by the
column names, and then the optional
\fIprocedure\fR is executed if supplied.
(Omitting the \fIprocedure\fR probably makes sense
only if the query will return a single row.) The number of rows
selected is returned.
.PP
The \fIprocedure\fR can use the Tcl commands
break, continue, and
return with the expected behavior. Note that if
the \fIprocedure\fR executes
return, then \fBpg_execute\fR
does not return the number of affected rows.
.PP
\fBpg_execute\fR is a newer function which provides
a superset of the features of \fBpg_select\fR and
can replace \fBpg_exec\fR in many cases where access
to the result handle is not needed.
.PP
For server-handled errors, \fBpg_execute\fR will
throw a Tcl error and return a two-element list. The first element
is an error code, such as PGRES_FATAL_ERROR, and
the second element is the server error text. For more serious
errors, such as failure to communicate with the server,
\fBpg_execute\fR will throw a Tcl error and return
just the error message text.
.SH "ARGUMENTS"
.TP
\fB-array \fIarrayVar\fB\fR
Specifies the name of an array variable where result rows are
stored, indexed by the column names. This is ignored if
\fIcommandString\fR is not a \fBSELECT\fR
statement.
.TP
\fB-oid \fIoidVar\fB\fR
Specifies the name of a variable into which the OID from an
\fBINSERT\fR statement will be stored.
.TP
\fB\fIconn\fB\fR
The handle of the connection on which to execute the command.
.TP
\fB\fIcommandString\fB\fR
The SQL command to execute.
.TP
\fB\fIprocedure\fB\fR
Optional procedure to execute for each result row of a
\fBSELECT\fR statement.
.SH "RETURN VALUE"
.PP
The number of rows affected or returned by the command.
.SH "EXAMPLES"
.PP
In the following examples, error checking with
catch has been omitted for clarity.
.PP
Insert a row and save the OID in result_oid:
.sp
.nf
pg_execute -oid result_oid $pgconn "INSERT INTO mytable VALUES (1);"
.sp
.fi
.PP
Print the columns item and value from each
row:
.sp
.nf
pg_execute -array d $pgconn "SELECT item, value FROM mytable;" {
    puts "Item=$d(item) Value=$d(value)"
}
.sp
.fi
.PP
Find the maximum and minimum values and store them in
$s(max) and $s(min):
.sp
.nf
pg_execute -array s $pgconn "SELECT max(value) AS max, min(value) AS min FROM mytable;"
.sp
.fi
.PP
Find the maximum and minimum values and store them in
$max and $min:
.sp
.nf
pg_execute $pgconn "SELECT max(value) AS max, min(value) AS min FROM mytable;"
.sp
.fi
