/*--------------------------------------------------------------------
 * FILE:
 *     admin_init.c
 *
 * NOTE:
 *     This file is composed of the tool 
 *     which generate initial setup files
 *
 *--------------------------------------------------------------------
 */

/*--------------------------------------
 * INTERFACE ROUTINES
 *
 * I/O call:
 *      
 *-------------------------------------
 */
#include "postgres.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <time.h>
#include <pwd.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <netdb.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <errno.h>
#include <fcntl.h>
#include <time.h>
#include <arpa/inet.h>
#include <sys/param.h>
#include <sys/select.h>
#include <sys/file.h>
#include <dirent.h>
#include <getopt.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

/*
#include "replicate_com.h"
*/
#include "libpq/pqsignal.h"
#include "pgc_admin.h"

char * ServerTbl = NULL;
int ServerTblSize = 0;
Physical_Server_Info * PhysicalServerTbl = NULL;
SSL_Server_Info * AdminTbl = NULL;
SSL_Server_Info * ProbeTbl = NULL;
Pglb_Info * PglbTbl = NULL;
Cluster_Info * ClusterDbTbl = NULL;
Pgrp_Info * PgrpTbl = NULL;
Partial_Info * PartialTbl = NULL;
Record_Num_Info * RecordNumTbl = NULL;
Shmid_Info ShmidTbl;

char * PGR_Data_Path = NULL;
char * PGR_Write_Path = NULL;

/* for replicate_com.h */
ConfDataType * ConfData_Top = (ConfDataType *)NULL;
ConfDataType * ConfData_End = (ConfDataType *)NULL;
int Install_All = 0;
int Debug_Print = 0;
int Log_Print = 0;
int AdminSock = -1;
SSL_Info SSL_Tbl;


static int install_setup_files(char * command);
static int read_admin_conf_data(void);
static int setup_files(void);
static void all_free(int exit_status);
static void usage(void);

int
main(int argc, char * argv[])
{
	int opt = 0;
	char * r_path = NULL;
	char * w_path = NULL;
	bool detach = true;

	if (r_path == NULL)
		r_path = ".";
	while ((opt = getopt(argc, argv, "D:W:alvh")) != -1)
	{
		switch (opt)
		{
			case 'D':
				if (!optarg)
				{
					usage();
					exit(1);
				}
				r_path = optarg;
				break;
			case 'W':
				if (!optarg)
				{
					usage();
					exit(1);
				}
				w_path = optarg;
				break;
			case 'a':
				Install_All = 1;
				break;
			case 'l':
				Log_Print = 1;
				break;
			case 'v':
				Debug_Print = 1;
				break;
			case 'n':
				detach = false;
				break;
			case 'h':
				usage();
				exit(0);
				break;
			default:
				usage();
				exit(1);
		}
	}

	PGR_Data_Path = r_path;
	PGR_Write_Path = (w_path == NULL)?PGR_Data_Path:w_path;

	if (optind == (argc-1) && !strncasecmp(argv[optind],"install",7))
	{
		install_setup_files(argv[0]);
	}
	else
	{
		setup_files();
	}
	return STATUS_OK;
}

static int
install_setup_files(char * command)
{
	char * func = "install_setup_files()";
	int flag;

	if (read_admin_conf_data() != STATUS_OK)
	{
		fprintf(stderr,"%s/%s file can not open.\n",PGR_Data_Path, PGC_ADMIN_CONF_FILE);
		fprintf(stderr,"When you want to just create new %s, please run %s without 'install' option.\n\n",PGC_ADMIN_CONF_FILE, command);
		fprintf(stderr,"If you want to create new %s and install it,\nPlease push <y>  --> ",PGC_ADMIN_CONF_FILE);
		flag = fgetc(stdin);
		if ((flag != 'y') && (flag != 'Y'))
		{
			return STATUS_ERROR;
		}
		fprintf(stderr,"begin to create setup files\n");
		if (setup_files() != STATUS_OK)
		{
			fprintf(stderr,"setup files creation were failed\n");
			return STATUS_ERROR;
		}
		fprintf(stderr,"setup files creation were successed\n");
		/*
		all_free(0);
		*/

		if (read_admin_conf_data() != STATUS_OK)
		{
			show_error("%s:read_admin_conf_data failed",func);
			return STATUS_ERROR;
		}
	}

	/* create pgcluster conf files */
	PGRcreate_pgcluster_conf(PGR_Write_Path);
show_debug("PGRcreate_pgcluster_conf OK");
	/* create admin pem files */
	PGRcreate_admin_pem_files(PGR_Write_Path);
show_debug("PGRcreate_admin_pem_files OK");

	/* create probe pem files */
	PGRcreate_probe_pem_files(PGR_Write_Path);
show_debug("PGRcreate_probe_pem_files OK");

	/* send configuration files to each server */
	PGRsend_conf_files(PGR_Write_Path);
show_debug("PGRsend_conf_files OK");

	PGR_Clear_Shm();
	return STATUS_OK;
}

static int
read_admin_conf_data(void)
{
	char * func ="read_admin_conf_data()";

	if (PGRinit_Admin(PGR_Data_Path) != STATUS_OK)
	{
		show_error("%s:PGRget_Admin_Conf_Data error",func);
		PGR_Clear_Shm();
		return STATUS_ERROR;
	}
	/* read server information files */
	if (PGRget_Admin_Conf_Data(PGR_Data_Path, PGC_ADMIN_CONF_FILE ) != STATUS_OK)
	{
		PGR_Clear_Shm();
		return STATUS_ERROR;
	}
	return STATUS_OK;
}

static int
setup_files(void)
{
	char * func = "setup_files()";
	int rtn = STATUS_OK;

	/* allocate table area */
	if (PGRinit_Server(PGR_Data_Path) != STATUS_OK)
	{
		show_error("%s:PGRinit_Server error",func);
		all_free(1);
	}

	/* read server information files */
	if (PGRget_Admin_Conf_Data(PGR_Data_Path, PGC_SERVER_CONF_FILE) != STATUS_OK)
	{
		show_error("%s:PGRget_Admin_Conf_Data error",func);
		return STATUS_ERROR;
	}

	/* read template files */
	if (PGRget_Template_Data(PGR_Data_Path) != STATUS_OK)
	{
		show_error("%s:PGRget_Template_Data error",func);
		return STATUS_ERROR;
	}

	/* create pgc_admin conf file */
	rtn = PGRcreate_pgc_admin_conf(PGR_Write_Path);
	if (rtn != STATUS_OK)
	{
		show_error("%s:PGRcreate_pgc_admin_conf failed",func);
		return rtn;
	}

	/* create public key files */
	rtn = PGRcreate_public_key_files(PGR_Write_Path);
	if (rtn != STATUS_OK)
	{
		show_error("%s:PGRcreate_public_key_files failed",func);
		return rtn;
	}

	/* send pulic key files to each server */
	rtn = PGRsend_public_key_files(PGR_Write_Path);
	if (rtn != STATUS_OK)
	{
		show_error("%s:PGRsend_public_key_files failed",func);
		fprintf(stderr,"Please check public key in each server.\n");
		fprintf(stderr,"If it is not created, please try <ssh-keygen> command\n");
		return rtn;
	}

	/* send pgc_admin conf file */
	rtn = PGRsend_pgc_admin_conf_file(PGR_Write_Path);
	if (rtn != STATUS_OK)
	{
		show_error("%s:PGRsend_pgc_admin_conf_file failed",func);
		return rtn;
	}

	/* send pgc_probe conf file */
	rtn = PGRsend_pgc_probe_conf_file(PGR_Write_Path);
	if (rtn != STATUS_OK)
	{
		show_error("%s:PGRsend_pgc_probe_conf_file failed",func);
		return rtn;
	}

	return rtn;
}

static void
all_free(int exit_status)
{
	if (PhysicalServerTbl != NULL)
	{
		free(PhysicalServerTbl);
		PhysicalServerTbl = NULL;
	}
	if (AdminTbl != NULL)
	{
		free(AdminTbl);
		AdminTbl = NULL;
	}
	if (ProbeTbl != NULL)
	{
		free(ProbeTbl);
		ProbeTbl = NULL;
	}
	if (PglbTbl != NULL)
	{
		free(PglbTbl);
		PglbTbl = NULL;
	}
	if (ClusterDbTbl != NULL)
	{
		free(ClusterDbTbl);
		ClusterDbTbl = NULL;
	}
	if (PgrpTbl != NULL)
	{
		free(PgrpTbl);
		PgrpTbl = NULL;
	}
	if (PgrpTbl != NULL)
	{
		free(PgrpTbl);
		PgrpTbl = NULL;
	}
	if (PartialTbl  != NULL)
	{
		free(PartialTbl);
		PartialTbl = NULL;
	}
}

/*--------------------------------------------------------------------
 * SYMBOL
 *    usage()
 * NOTES
 *    show usage of admin_init
 * ARGS
 *    void
 * RETURN
 *    none
 *--------------------------------------------------------------------
 */
static void
usage(void)
{
	char * path;

	path = getenv("PGDATA");
	if (path == NULL)
		path = ".";
	fprintf(stderr,"PGReplicate version [%s]\n",PGREPLICATE_VERSION);
	fprintf(stderr,"A replication server for cluster DB servers (based on PostgreSQL)\n\n");
	fprintf(stderr,"usage: pgc_admin_init [-D path_of_config_file] [-W path_of_work_files] [-v][-h][install]\n");
	fprintf(stderr,"    config file default path: %s/%s\n",path, PGC_SERVER_CONF_FILE);
	fprintf(stderr,"    -v: debug mode \n");
	fprintf(stderr,"    -h: print this help\n");
}
