/*--------------------------------------------------------------------
 * FILE:
 *     packet.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <ctype.h>
#include <time.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/wait.h>
#include <arpa/inet.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

Probe_Header * PGC_Set_Packet_Header(Probe_Header * header, Probe_Header * h_data);
Server_Status * PGC_Set_Server_Status(Server_Status * body, Server_Status * data);
Pglb_Info * PGC_Set_Pglb_Info_2_packet(Pglb_Info * body, Pglb_Info * data);
Pglb_Info * PGC_Set_Packet_2_Pglb_Info(Pglb_Info * pglb, Pglb_Info * packet);
Cluster_Info * PGC_Set_Cluster_Info_2_packet(Cluster_Info * body, Cluster_Info * data);
Cluster_Info * PGC_Set_Packet_2_Cluster_Info(Cluster_Info * cluster, Cluster_Info * packet);
Pgrp_Info * PGC_Set_Pgrp_Info_2_packet(Pgrp_Info * body, Pgrp_Info * data);
Pgrp_Info * PGC_Set_Packet_2_Pgrp_Info(Pgrp_Info * pgrp, Pgrp_Info * packet);
ClusterTbl * PGC_Set_ClusterTbl_2_packet(ClusterTbl * body, ClusterTbl * data);
ClusterTbl * PGC_Set_Packet_2_ClusterTbl(ClusterTbl * cluster, ClusterTbl * packet);
ReplicateServerInfo * PGC_Set_ReplicateServerInfo_2_packet(ReplicateServerInfo * body, ReplicateServerInfo * data);
ReplicateServerInfo * PGC_Set_Packet_2_ReplicateServerInfo(ReplicateServerInfo * replicate, ReplicateServerInfo * packet);
HostTbl * PGC_Set_HostTbl_2_packet(HostTbl * body, HostTbl * data);
HostTbl * PGC_Set_Packet_2_HostTbl(HostTbl * host, HostTbl * packet);
SSL_Server_Info * PGC_Set_SSL_Server_Info_2_packet(SSL_Server_Info * body, SSL_Server_Info * data);
SSL_Server_Info * PGC_Set_Packet_2_SSL_Server_Info(SSL_Server_Info * ssl_server, SSL_Server_Info * packet);
int PGC_Probe_Send_Packet(Probe_Header * header, char * body );
int PGC_Admin_Send_Packet(SSL_Info * ssl_tbl, Probe_Header * header, char * body, uint16_t physicalServerId );
SSL_Server_Info * PGC_Get_Probe_In_PhysicalServer(uint16_t physicalServerId);
int PGC_Send_Status_Packet(SSL_Info * ssl_tbl, Probe_Header * header, char * body );
char * PGC_Read_Probe_Packet(SSL_Info *ssl_tbl, Probe_Header * header);
Probe_Header * PGC_Response_Receive(SSL_Info * ssl_tbl, Probe_Header * header);

Probe_Header *
PGC_Set_Packet_Header(Probe_Header * header, Probe_Header * h_data)
{
	/* char * func = "PGC_Set_Packet_Header()";*/
	if ((header == NULL) || (h_data == NULL))
	{
		return NULL;
	}
	memset(header, 0, sizeof(Probe_Header));
	header->packet_no = htons(h_data->packet_no);
	header->serverType = htons(h_data->serverType);
	header->status = htons(h_data->status);
	header->body_length = htonl(h_data->body_length);
	header->rec_num = htonl(h_data->rec_num);
	return header;
}

Server_Status *
PGC_Set_Server_Status(Server_Status * body, Server_Status * data)
{
	if ((body == NULL) || (data == NULL))
	{
		return NULL;
	}
	body->status = htons(data->status);
	body->portNumber = htons(data->portNumber);
	memcpy(body->hostName,data->hostName,sizeof(body->hostName));
	return body;
}

Pglb_Info *
PGC_Set_Pglb_Info_2_packet(Pglb_Info * body, Pglb_Info * data)
{
	/* char * func = "PGC_Set_Pglb_Info_2_packet()";*/
	body->physicalServerId = htons(data->physicalServerId);
	body->status = htons(data->status);
	body->serverNo = htons(data->serverNo);
	body->receivePortNumber = htons(data->receivePortNumber);
	body->recoveryPortNumber = htons(data->recoveryPortNumber);
	body->maxClusterNum = htons(data->maxClusterNum);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	memcpy(body->backendSocketDir, data->backendSocketDir, sizeof(body->backendSocketDir));
	memcpy(body->usePool, data->usePool, sizeof(body->usePool));
	memcpy(body->lifecheckTimeout, data->lifecheckTimeout, sizeof(body->lifecheckTimeout));
	memcpy(body->lifecheckInterval, data->lifecheckInterval, sizeof(body->lifecheckInterval));
	memcpy(body->connectionLifetime, data->connectionLifetime, sizeof(body->connectionLifetime));
	memcpy(body->logFileName, data->logFileName, sizeof(body->logFileName));
	memcpy(body->logFileSize, data->logFileSize, sizeof(body->logFileSize));
	body->logRotate = htons(data->logRotate);
	memcpy(body->workPath, data->workPath, sizeof(body->workPath));
	memcpy(body->binPath, data->binPath, sizeof(body->binPath));

	return body;
}

Pglb_Info *
PGC_Set_Packet_2_Pglb_Info(Pglb_Info * pglb, Pglb_Info * packet)
{
	/*char * func = "PGC_Set_Packet_2_Pglb_Info()";*/
	if ((pglb == NULL) || ( packet == NULL))
	{
		return NULL;
	}
	pglb->physicalServerId = ntohs(packet->physicalServerId);
	pglb->status = ntohs(packet->status);
	pglb->serverNo = ntohs(packet->serverNo);
	pglb->receivePortNumber = ntohs(packet->receivePortNumber);
	pglb->recoveryPortNumber = ntohs(packet->recoveryPortNumber);
	pglb->maxClusterNum = ntohs(packet->maxClusterNum);
	memcpy(pglb->hostName, packet->hostName, sizeof(pglb->hostName));
	memcpy(pglb->backendSocketDir, packet->backendSocketDir, sizeof(pglb->backendSocketDir));
	memcpy(pglb->usePool, packet->usePool, sizeof(pglb->usePool));
	memcpy(pglb->lifecheckTimeout, packet->lifecheckTimeout, sizeof(pglb->lifecheckTimeout));
	memcpy(pglb->lifecheckInterval, packet->lifecheckInterval, sizeof(pglb->lifecheckInterval));
	memcpy(pglb->connectionLifetime, packet->connectionLifetime, sizeof(pglb->connectionLifetime));
	memcpy(pglb->logFileName, packet->logFileName, sizeof(pglb->logFileName));
	memcpy(pglb->logFileSize, packet->logFileSize, sizeof(pglb->logFileSize));
	pglb->logRotate = ntohs(packet->logRotate);
	memcpy(pglb->workPath, packet->workPath, sizeof(pglb->workPath));
	memcpy(pglb->binPath, packet->binPath, sizeof(pglb->binPath));

	return pglb;
}

Cluster_Info *
PGC_Set_Cluster_Info_2_packet(Cluster_Info * body, Cluster_Info * data)
{
	/* char * func = "PGC_Set_Cluster_Info_2_packet()"; */
	body->physicalServerId = htons(data->physicalServerId);
	body->status = htons(data->status);
	body->serverNo = htons(data->serverNo);
	body->portNumber = htons(data->portNumber);
	body->recoveryPortNumber = htons(data->recoveryPortNumber);
	body->maxConnections = htons(data->maxConnections);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	memcpy(body->rsyncPath, data->rsyncPath, sizeof(body->rsyncPath));
	memcpy(body->rsyncOption, data->rsyncOption, sizeof(body->rsyncOption));
	memcpy(body->rsyncCompress, data->rsyncCompress, sizeof(body->rsyncCompress));
	memcpy(body->rsyncTimeout, data->rsyncTimeout, sizeof(body->rsyncTimeout));
	memcpy(body->rsyncBwlimit, data->rsyncBwlimit, sizeof(body->rsyncBwlimit));
	memcpy(body->pgdumpPath, data->pgdumpPath, sizeof(body->pgdumpPath));
	memcpy(body->pingPath, data->pingPath, sizeof(body->pingPath));
	memcpy(body->whenStandAlone, data->whenStandAlone, sizeof(body->whenStandAlone));
	memcpy(body->replicationTimeout, data->replicationTimeout, sizeof(body->replicationTimeout));
	memcpy(body->lifecheckTimeout, data->lifecheckTimeout, sizeof(body->lifecheckTimeout));
	memcpy(body->lifecheckInterval, data->lifecheckInterval, sizeof(body->lifecheckInterval));
	memcpy(body->workPath, data->workPath, sizeof(body->workPath));
	memcpy(body->binPath, data->binPath, sizeof(body->binPath));

	return body;
}

Cluster_Info *
PGC_Set_Packet_2_Cluster_Info(Cluster_Info * cluster, Cluster_Info * packet)
{
	/* char * func ="PGC_Set_Packet_2_Cluster_Info()";*/
	if ((cluster == NULL) || (packet == NULL))
	{
		return NULL;
	}
	cluster->physicalServerId = ntohs(packet->physicalServerId);
	cluster->status = ntohs(packet->status);
	cluster->serverNo = ntohs(packet->serverNo);
	cluster->portNumber = ntohs(packet->portNumber);
	cluster->recoveryPortNumber = ntohs(packet->recoveryPortNumber);
	cluster->maxConnections = ntohs(packet->maxConnections);
	memcpy(cluster->hostName, packet->hostName, sizeof(cluster->hostName));
	memcpy(cluster->rsyncPath, packet->rsyncPath, sizeof(cluster->rsyncPath));
	memcpy(cluster->rsyncOption, packet->rsyncOption, sizeof(cluster->rsyncOption));
	memcpy(cluster->rsyncCompress, packet->rsyncCompress, sizeof(cluster->rsyncCompress));
	memcpy(cluster->rsyncTimeout, packet->rsyncTimeout, sizeof(cluster->rsyncTimeout));
	memcpy(cluster->rsyncBwlimit, packet->rsyncBwlimit, sizeof(cluster->rsyncBwlimit));
	memcpy(cluster->pgdumpPath, packet->pgdumpPath, sizeof(cluster->pgdumpPath));
	memcpy(cluster->pingPath, packet->pingPath, sizeof(cluster->pingPath));
	memcpy(cluster->whenStandAlone, packet->whenStandAlone, sizeof(cluster->whenStandAlone));
	memcpy(cluster->replicationTimeout, packet->replicationTimeout, sizeof(cluster->replicationTimeout));
	memcpy(cluster->lifecheckTimeout, packet->lifecheckTimeout, sizeof(cluster->lifecheckTimeout));
	memcpy(cluster->lifecheckInterval, packet->lifecheckInterval, sizeof(cluster->lifecheckInterval));
	memcpy(cluster->workPath, packet->workPath, sizeof(cluster->workPath));
	memcpy(cluster->binPath, packet->binPath, sizeof(cluster->binPath));
	return cluster;
}

Pgrp_Info *
PGC_Set_Pgrp_Info_2_packet(Pgrp_Info * body, Pgrp_Info * data)
{
	/* char * func ="PGC_Set_Pgrp_Info_2_packet()"; */
	body->physicalServerId = htons(data->physicalServerId);
	body->status = htons(data->status);
	body->serverNo = htons(data->serverNo);
	body->replicationPortNumber = htons(data->replicationPortNumber);
	body->recoveryPortNumber = htons(data->recoveryPortNumber);
	body->RLogPortNumber = htons(data->RLogPortNumber);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	memcpy(body->useRlog, data->useRlog, sizeof(body->useRlog));
	memcpy(body->replicationTimeout, data->replicationTimeout, sizeof(body->replicationTimeout));
	memcpy(body->lifecheckTimeout, data->lifecheckTimeout, sizeof(body->lifecheckTimeout));
	memcpy(body->lifecheckInterval, data->lifecheckInterval, sizeof(body->lifecheckInterval));
	memcpy(body->logFileName, data->logFileName, sizeof(body->logFileName));
	memcpy(body->logFileSize, data->logFileSize, sizeof(body->logFileSize));
	body->logRotate = htons(data->logRotate);
	memcpy(body->workPath, data->workPath, sizeof(body->workPath));
	memcpy(body->binPath, data->binPath, sizeof(body->binPath));

	return body;
}

Pgrp_Info *
PGC_Set_Packet_2_Pgrp_Info(Pgrp_Info * pgrp, Pgrp_Info * packet)
{
	/* char * func ="PGC_Set_Packet_2_Pgrp_Info()";*/
	if ((pgrp == NULL) || (packet == NULL))
	{
		return NULL;
	}
	pgrp->physicalServerId = ntohs(packet->physicalServerId);
	pgrp->status = ntohs(packet->status);
	pgrp->serverNo = ntohs(packet->serverNo);
	pgrp->replicationPortNumber = ntohs(packet->replicationPortNumber);
	pgrp->recoveryPortNumber = ntohs(packet->recoveryPortNumber);
	pgrp->RLogPortNumber = ntohs(packet->RLogPortNumber);
	memcpy(pgrp->hostName, packet->hostName, sizeof(pgrp->hostName));
	memcpy(pgrp->useRlog, packet->useRlog, sizeof(pgrp->useRlog));
	memcpy(pgrp->replicationTimeout, packet->replicationTimeout, sizeof(pgrp->replicationTimeout));
	memcpy(pgrp->lifecheckTimeout, packet->lifecheckTimeout, sizeof(pgrp->lifecheckTimeout));
	memcpy(pgrp->lifecheckInterval, packet->lifecheckInterval, sizeof(pgrp->lifecheckInterval));
	memcpy(pgrp->logFileName, packet->logFileName, sizeof(pgrp->logFileName));
	memcpy(pgrp->logFileSize, packet->logFileSize, sizeof(pgrp->logFileSize));
	pgrp->logRotate = ntohs(packet->logRotate);
	memcpy(pgrp->workPath, packet->workPath, sizeof(pgrp->workPath));
	memcpy(pgrp->binPath, packet->binPath, sizeof(pgrp->binPath));
	return pgrp;
}

ClusterTbl *
PGC_Set_ClusterTbl_2_packet(ClusterTbl * body, ClusterTbl * data)
{
	if ((body == NULL) || (data == NULL))
	{
		return NULL;
	}
	body->useFlag = htons(data->useFlag);
	body->port = htons(data->port);
	body->max_connect = htons(data->max_connect);
	body->use_num = htons(data->use_num);
	body->rate= htons(data->rate);
	body->rec_no = htons(data->rec_no);
	body->retry_count = htons(data->retry_count);
	body->dummy = 0;
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));

	return body;
}

ClusterTbl *
PGC_Set_Packet_2_ClusterTbl(ClusterTbl * cluster, ClusterTbl * packet)
{
	if ((cluster == NULL) || (packet == NULL))
	{
		return NULL;
	}
	cluster->useFlag = htons(packet->useFlag);
	cluster->port = htons(packet->port);
	cluster->max_connect = htons(packet->max_connect);
	cluster->use_num = htons(packet->use_num);
	cluster->rate= htons(packet->rate);
	cluster->rec_no = htons(packet->rec_no);
	cluster->retry_count = htons(packet->retry_count);
	cluster->dummy = 0;
	memcpy(cluster->hostName, packet->hostName, sizeof(cluster->hostName));

	return cluster;
}

ReplicateServerInfo *
PGC_Set_ReplicateServerInfo_2_packet(ReplicateServerInfo * body, ReplicateServerInfo * data)
{
	if ((body == NULL) || (data == NULL))
	{
		return NULL;
	}
	body->useFlag = htons(data->useFlag);
	body->portNumber = htons(data->portNumber);
	body->recoveryPortNumber = htons(data->recoveryPortNumber);
	body->lifecheckPortNumber = htons(data->lifecheckPortNumber);
	body->RLogPortNumber = htons(data->RLogPortNumber);
	body->retry_count = htons(data->retry_count);
	body->response_mode = htons(data->response_mode);
	body->dummy = 0;
	body->replicate_id = htonl(data->replicate_id);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	/*
	body->sock = htonl(data->sock);
	body->rlog_sock = htonl(data->rlog_sock);
	*/

	return body;
}

ReplicateServerInfo *
PGC_Set_Packet_2_ReplicateServerInfo(ReplicateServerInfo * replicate, ReplicateServerInfo * packet)
{
	if ((replicate == NULL) || (packet == NULL))
	{
		return NULL;
	}
	replicate->useFlag = ntohs(packet->useFlag);
	replicate->portNumber = ntohs(packet->portNumber);
	replicate->recoveryPortNumber = ntohs(packet->recoveryPortNumber);
	replicate->lifecheckPortNumber = ntohs(packet->lifecheckPortNumber);
	replicate->RLogPortNumber = ntohs(packet->RLogPortNumber);
	replicate->retry_count = ntohs(packet->retry_count);
	replicate->response_mode = ntohs(packet->response_mode);
	replicate->dummy = 0;
	/*
	replicate->sock = ntohl(packet->sock);
	replicate->rlog_sock = ntohl(packet->rlog_sock);
	*/
	replicate->replicate_id = ntohl(packet->replicate_id);
	memcpy(replicate->hostName, packet->hostName, sizeof(replicate->hostName));

	return replicate;
}

HostTbl *
PGC_Set_HostTbl_2_packet(HostTbl * body, HostTbl * data)
{
	if ((body == NULL) || (data == NULL))
	{
		return NULL;
	}
	body->useFlag = htons(data->useFlag);
	body->port = htons(data->port);
	body->recoveryPort = htons(data->recoveryPort);
	body->hostNum = htons(data->hostNum);
	body->retry_count = htons(data->retry_count);
	body->dummy = 0;
	body->transaction_count= htons(data->transaction_count);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	memcpy(body->resolvedName, data->resolvedName, sizeof(body->resolvedName));
	return body;
}

HostTbl *
PGC_Set_Packet_2_HostTbl(HostTbl * host, HostTbl * packet)
{
	if ((host == NULL) || (packet == NULL))
	{
		return NULL;
	}
	host->useFlag = ntohs(packet->useFlag);
	host->port = ntohs(packet->port);
	host->recoveryPort = ntohs(packet->recoveryPort);
	host->hostNum = ntohs(packet->hostNum);
	host->retry_count = ntohs(packet->retry_count);
	host->dummy = 0;
	host->transaction_count= ntohs(packet->transaction_count);
	memcpy(host->hostName, packet->hostName, sizeof(host->hostName));
	memcpy(host->resolvedName, packet->resolvedName, sizeof(host->resolvedName));
	return host;
}

Physical_Server_Info *
PGC_Set_Physical_Server_Info_2_packet(Physical_Server_Info * body, Physical_Server_Info * data)
{
	if ((body == NULL) || ( data == NULL))
	{
		return NULL;
	}
	body->physicalServerId = htons(data->physicalServerId);
	body->status = htons(data->status);
	body->serverNo = htons(data->serverNo);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	memcpy(body->ipAddr, data->ipAddr, sizeof(body->ipAddr));
	memcpy(body->userName, data->userName, sizeof(body->userName));
	return body;
}

Physical_Server_Info *
PGC_Set_Packet_2_Physical_Server_Info(Physical_Server_Info * server, Physical_Server_Info * packet)
{
	if ((server == NULL) || ( packet == NULL))
	{
		return NULL;
	}
	server->physicalServerId = ntohs(packet->physicalServerId);
	server->status = ntohs(packet->status);
	server->serverNo = ntohs(packet->serverNo);
	memcpy(server->hostName, packet->hostName, sizeof(server->hostName));
	memcpy(server->ipAddr, packet->ipAddr, sizeof(server->ipAddr));
	memcpy(server->userName, packet->userName, sizeof(server->userName));
	return server;
}

SSL_Server_Info *
PGC_Set_SSL_Server_Info_2_packet(SSL_Server_Info * body, SSL_Server_Info * data)
{
	if ((body == NULL) || (data == NULL))
	{
		return NULL;
	}
	body->physicalServerId = htons(data->physicalServerId);
	body->status = htons(data->status);
	body->serverNo = htons(data->serverNo);
	body->portNumber = htons(data->portNumber);
	memcpy(body->hostName, data->hostName, sizeof(body->hostName));
	memcpy(body->workPath, data->workPath, sizeof(body->workPath));
	memcpy(body->binPath, data->binPath, sizeof(body->binPath));
	memcpy(body->sslPath, data->sslPath, sizeof(body->sslPath));
	return body;
}

SSL_Server_Info *
PGC_Set_Packet_2_SSL_Server_Info(SSL_Server_Info * ssl_server, SSL_Server_Info * packet)
{
	if ((ssl_server == NULL) || (packet == NULL))
	{
		return NULL;
	}
	ssl_server->physicalServerId = ntohs(packet->physicalServerId);
	ssl_server->status = ntohs(packet->status);
	ssl_server->serverNo = ntohs(packet->serverNo);
	ssl_server->portNumber = ntohs(packet->portNumber);
	memcpy(ssl_server->hostName, packet->hostName, sizeof(ssl_server->hostName));
	memcpy(ssl_server->workPath, packet->workPath, sizeof(ssl_server->workPath));
	memcpy(ssl_server->binPath, packet->binPath, sizeof(ssl_server->binPath));
	return ssl_server;
}

int
PGC_Probe_Send_Packet(Probe_Header * header, char * body )
{
	char * func = "PGC_Probe_Send_Packet()";
	SSL_Info ssl_tbl;
	int count = 0;
	SSL_Server_Info * admin = AdminTbl;

	if (AdminTbl == NULL)
	{
		show_error("%s: AdminTbl is null",func);
		return STATUS_ERROR;
	}

	count = 0;
	while (PGC_Create_Probe_Send_SSL(&ssl_tbl, admin->hostName, admin->portNumber) == NULL)
	{
		PGC_Close_SSL(&ssl_tbl);
		if (count > MAX_RETRY_TIMES )
		{
			show_error("%s:host[%s] port[%d]PGC_Create_Probe_Send_SSL failed",func,admin->hostName, admin->portNumber);
			return STATUS_ERROR;
		}
		count ++;
		sleep(1);
	}
	if(PGC_Send_Status_Packet(&ssl_tbl, header, body) != STATUS_OK)
	{
        PGC_Close_SSL(&ssl_tbl);
		return STATUS_ERROR;
	}
	PGC_Close_SSL(&ssl_tbl);
	return STATUS_OK;
}

int
PGC_Admin_Send_Packet(SSL_Info * ssl_tbl, Probe_Header * header, char * body, uint16_t physicalServerId )
{
	char * func = "PGC_Admin_Send_Packet()";
	int count = 0;
	SSL_Server_Info * probe = NULL;

	probe = PGC_Get_Probe_In_PhysicalServer(physicalServerId);
	if (probe == NULL)
	{
		show_error("%s: probe is not available in %d server",func, physicalServerId);
		return STATUS_ERROR;
	}
	count = 0;
	while (PGC_Create_Admin_Send_SSL(ssl_tbl, probe->hostName, probe->portNumber) == NULL)
	{
		PGC_Close_SSL(ssl_tbl);
		if (count > MAX_RETRY_TIMES )
		{
			show_error("%s:host[%s] port[%d]PGC_Create_Admin_Send_SSL failed",func,probe->hostName, probe->portNumber);
			return STATUS_ERROR;
		}
		count ++;
		sleep(1);
	}
	if(PGC_Send_Status_Packet(ssl_tbl, header, body) != STATUS_OK)
	{
		show_error("%s:host[%s] port[%d]PGC_Send_Status_Packet failed",func,probe->hostName, probe->portNumber);
		PGC_Close_SSL(ssl_tbl);
		return STATUS_ERROR;
	}
	/*PGC_Close_SSL(ssl_tbl);*/
	return STATUS_OK;
}

SSL_Server_Info *
PGC_Get_Probe_In_PhysicalServer(uint16_t physicalServerId)
{
	char * func ="PGC_Get_Probe_In_PhysicalServer()";
	SSL_Server_Info * probe = NULL;
	int count = 0;

	if (ProbeTbl == NULL)
	{
		show_error("%s: ProbeTbl is null",func);	
		return NULL;
	}
	probe = ProbeTbl;
	while (probe->portNumber != 0)
	{
		if (probe->physicalServerId == physicalServerId)
		{
			return probe;
		}
		probe ++;
		count ++;
		if (count >= MAX_PROBE_SERVER)
			break;
	}
	return NULL;	
}

int
PGC_Send_Status_Packet(SSL_Info * ssl_tbl, Probe_Header * header, char * body )
{
	char * func ="PGC_Send_Status_Packet()";
	char * buf = NULL;
	char * p = NULL;
	int length = 0;
	int send_length = 0;
	int status = STATUS_ERROR;

	if ((ssl_tbl == NULL) ||
		(header == NULL))
	{
		return status;
	}
	length = ntohl(header->body_length);
	buf = (char *)malloc(sizeof(Probe_Header) + length );
	if (buf == NULL)
	{
		show_error("%s: malloc faild (%s)",func,strerror(errno));
		return status;
	}
	
	p = buf;
	memcpy(p, (char *)header, sizeof(Probe_Header));
	if (length > 0)
	{
		p = buf + sizeof(Probe_Header);
		memcpy((char *)p,(char *)body,length);
	}
	send_length = PGC_SSL_Send(ssl_tbl, buf, sizeof(Probe_Header) + length);
	if (buf != NULL)
	{
		free(buf);
	}
	if (send_length == sizeof(Probe_Header) +length)
	{
		status = STATUS_OK;
	}
	return status;
}

char *
PGC_Read_Probe_Packet(SSL_Info * ssl_tbl, Probe_Header * header)
{
	/* char * func = "PGC_Read_Probe_Packet()";*/
	char * body = NULL;
	int body_length = 0;
	int r_size = 0;

	/*
	 * Wait for something to happen.
	 */
	memset(header,0,sizeof(Probe_Header));
	r_size = PGC_SSL_Read(ssl_tbl, (char *)header, sizeof(Probe_Header));
	if (r_size > 0)
	{
		body_length = ntohl(header->body_length);
		body = (char *)malloc(body_length + 4);
		if (body == NULL)
		{
			show_error("malloc failed:(%s)\n",strerror(errno));
			return NULL;
		}
		memset((char *)body,0,body_length + 4);
		if (body_length == 0)
		{
			return body;
		}
		r_size = PGC_SSL_Read(ssl_tbl, (char *)body, body_length);
		if (r_size == body_length)
		{
			return body;
		}
		else
		{
			free(body);
			return NULL;
		}
	}
	else
	{
		header->body_length = r_size;
	}
	return NULL;
}

Probe_Header *
PGC_Response_Receive(SSL_Info * ssl_tbl, Probe_Header * header)
{
	char * packet = NULL;

	if (header == NULL)
	{
		return NULL;
	}
	memset(header, 0, sizeof(Probe_Header));
	packet = PGC_Read_Probe_Packet (ssl_tbl, header);
	if ((packet == NULL) && (header->body_length != 0))
	{
		return NULL;
	}
	if (packet != NULL)
	{
		free(packet);
		packet = NULL;
	}
	return header;
}

int
PGC_Response_Send(SSL_Info * ssl_tbl, uint16_t packet_no, uint16_t status)
{
	Probe_Header header;
	
	memset((char *)&header, 0, sizeof(Probe_Header));
	header.packet_no = htons(USER_RECOVERY_ANS_PKT);
	header.status = htons(status);
	return ( PGC_Send_Status_Packet(ssl_tbl, &header, NULL));

}
