/*--------------------------------------------------------------------
 * FILE:
 *     probe_get_pgrp_status.c
 *
 * NOTE:
 *     This file is composed of the probe process 
 *     Low level I/O functions that called by in these functions are 
 *     contained in 'replicate_com.c'.
 *
 *--------------------------------------------------------------------
 */
#include "postgres.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <signal.h>
#include <sys/wait.h>
#include <ctype.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/shm.h>
#include <errno.h>
#include <fcntl.h>
#include <sys/file.h>

#ifdef MULTIBYTE
#include "mb/pg_wchar.h"
#endif

#include "pgc_admin.h"

int PGC_Get_Pgrp_Status(void);
HostTbl * PGC_Get_Pgrp_Shm(char * path);
int PGC_Send_Pgrp_Status(Pgrp_Info * pgrp, HostTbl * cluster );
int PGC_Get_HostTbl_Rec_Num(HostTbl * cluster);

int
PGC_Get_Pgrp_Status(void)
{
	char * func = "PGC_Get_Pgrp_Status()";
	Pgrp_Info * pgrp = NULL;
	int count = 0;
	HostTbl * cluster = NULL;

	if (PgrpTbl == NULL)
	{
		show_error("%s: table is not allocated",func);
		return STATUS_ERROR;
	}
	pgrp = PgrpTbl;
	count = 0;
	while ((pgrp->status != 0) && (count < MAX_PGLB_SERVER))
	{
		cluster = PGC_Get_Pgrp_Shm(pgrp->workPath);
		if (cluster != NULL)
		{
			PGC_Send_Pgrp_Status(pgrp, cluster );	
			shmdt((char *)cluster);
			cluster = NULL;
		}
		else
		{
			show_debug("%s:pgrp->status status error send",func);
			pgrp->status = DATA_ERR;
			PGC_Send_Pgrp_Status(pgrp, NULL );	
		}
		count ++;
	}
	return STATUS_OK;
}

HostTbl *
PGC_Get_Pgrp_Shm(char * path)
{
	char * func = "PGC_Get_Pgrp_Shm()";
	IPCInfo ipc_list[4];
	int rtn = 0;
	HostTbl * cluster = NULL;

	memset(ipc_list, 0, sizeof(ipc_list));
	rtn = PGR_Get_IPC_File(path, PGREPLICATE_IPC_FILE, ipc_list);
	if (rtn <= 0)
	{
		show_error("%s:PGR_Get_IPC_File failed",func);
		return NULL;
	}
	cluster = (HostTbl *)shmat(ipc_list[0].shmid,0,0);
	if (cluster == (HostTbl *)-1)
	{
		show_error("%s:shmat failed (%s)",func,strerror(errno));
		return NULL;
	}
	return cluster;
}

int
PGC_Send_Pgrp_Status(Pgrp_Info * pgrp, HostTbl * cluster )
{
	char * func ="PGC_Send_Pgrp_Status()";
	Probe_Header r_header;
	Probe_Header h_data;
	int cluster_num = 0;
	char * body = NULL;
	int size = 0;
	HostTbl * cp = NULL;
	char * p = NULL;
	int status = STATUS_OK;

	cluster_num = PGC_Get_HostTbl_Rec_Num(cluster);
	size = sizeof(Pgrp_Info) + ( sizeof(HostTbl) * (cluster_num ));
	body = (char *)malloc(size);
	if (body == NULL)
	{
		show_error("%s: malloc failed (%s)",func, strerror(errno));
		return STATUS_ERROR;
	}
	memset(body, 0, size);
	p = body;
	PGC_Set_Pgrp_Info_2_packet((Pgrp_Info *)p, pgrp);
	if (cluster_num > 0)
	{
		p = body + sizeof(Pgrp_Info);
		cp = cluster;
		while(cp->port != 0)
		{
			PGC_Set_HostTbl_2_packet((HostTbl *)p,cp);
			p += sizeof(HostTbl);
			cp ++;
		}
	}
	h_data.packet_no = GET_STS_ANS_PKT;
	h_data.serverType = SERVER_TYPE_PGRP;
	h_data.body_length = size;
	h_data.rec_num = cluster_num;
	PGC_Set_Packet_Header(&r_header, &h_data);
	status = PGC_Probe_Send_Packet(&r_header,body);
	if (body != NULL)
	{
		free(body);
		body = NULL;
	}
	return status;
}

int
PGC_Get_HostTbl_Rec_Num(HostTbl * cluster)
{
	int cluster_num = 0;
	HostTbl * cp = NULL;
	if (cluster == NULL)
	{
		return 0;
	}
	cp = cluster;
	while(cp->port != 0)
	{
		cluster_num ++;
		cp ++;
	}
	return cluster_num;
}
