#include <stdio.h>
#include <strings.h>
#include <signal.h>
#include <errno.h>
#include <fcntl.h>
#include <grp.h>
#include <unistd.h>
#include <ctype.h>
#include <time.h>
#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/socket.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <netdb.h>
#include <netinet/in.h>
#ifdef HAVE_NETINET_TCP_H
#include <netinet/tcp.h>
#endif
#include <arpa/inet.h>
#include <sys/file.h>
#include <netdb.h>

#define HOSTNAME_MAX_LENGTH     (128)
#define DATA_END    (-1)

typedef struct ReplicateServerInfoType
{
	uint32_t useFlag;
	char hostName[HOSTNAME_MAX_LENGTH];
	uint16_t portNumber;
	uint16_t recoveryPortNumber;
	uint16_t lifecheckPortNumber;
	uint16_t RLogPortNumber;
	int32_t sock;
	int32_t rlog_sock;
	uint32_t replicate_id;
	uint16_t response_mode;
	uint16_t retry_count;
} ReplicateServerInfo;

int
main(int argc,char *argv[])
{
	int ReplicateServerShmid;
	ReplicateServerInfo * ReplicateServerData;
	ReplicateServerInfo * sp;

	ReplicateServerShmid = atoi(argv[1]);
	printf("id=%d\n",ReplicateServerShmid);

	ReplicateServerData = (ReplicateServerInfo *)shmat(ReplicateServerShmid,0,0);
	if (ReplicateServerData == (ReplicateServerInfo *)-1)
	{
		fprintf(stderr,"shmat failed\n");
		return 1;
	}

	sp = ReplicateServerData;
	while (sp->useFlag != DATA_END)
	{
		printf("useFlag[%d]\n",sp->useFlag);
		printf("hostName[%s]\n",sp->hostName);
		printf("portNumber[%d]\n",sp->portNumber);
		sp++;
	}
	shmdt(ReplicateServerData);
}
