

#### Inputs

# input tiff
set(INPUT_tiff "undefined" CACHE STRING "")
set_property(CACHE INPUT_tiff PROPERTY STRINGS undefined no qt system)

# input webp
set(INPUT_webp "undefined" CACHE STRING "")
set_property(CACHE INPUT_webp PROPERTY STRINGS undefined no qt system)



#### Libraries

qt_find_package(WrapJasper PROVIDED_TARGETS WrapJasper::WrapJasper MODULE_NAME imageformats QMAKE_LIB jasper)
qt_find_package(TIFF PROVIDED_TARGETS TIFF::TIFF MODULE_NAME imageformats QMAKE_LIB tiff)
qt_find_package(WrapWebP PROVIDED_TARGETS WrapWebP::WrapWebP MODULE_NAME imageformats QMAKE_LIB webp)


#### Tests



#### Features

qt_feature("jasper" PRIVATE
    LABEL "JasPer"
    CONDITION QT_FEATURE_imageformatplugin AND WrapJasper_FOUND
    DISABLE INPUT_jasper STREQUAL 'no'
)
qt_feature_definition("jasper" "QT_NO_IMAGEFORMAT_JASPER" NEGATE)
qt_feature("mng" PRIVATE
    LABEL "MNG"
    CONDITION libs.mng OR FIXME
    DISABLE INPUT_mng STREQUAL 'no'
)
qt_feature("tiff" PRIVATE
    LABEL "TIFF"
    CONDITION QT_FEATURE_imageformatplugin
    DISABLE INPUT_tiff STREQUAL 'no'
)
qt_feature("system-tiff" PRIVATE
    LABEL "  Using system libtiff"
    CONDITION QT_FEATURE_tiff AND TIFF_FOUND
    ENABLE INPUT_tiff STREQUAL 'system'
    DISABLE INPUT_tiff STREQUAL 'qt'
)
qt_feature("webp" PRIVATE
    LABEL "WEBP"
    CONDITION QT_FEATURE_imageformatplugin
    DISABLE INPUT_webp STREQUAL 'no'
)
qt_feature("system-webp" PRIVATE
    LABEL "  Using system libwebp"
    CONDITION QT_FEATURE_webp AND WrapWebP_FOUND
    ENABLE INPUT_webp STREQUAL 'system'
    DISABLE INPUT_webp STREQUAL 'qt'
)
qt_configure_add_summary_section(NAME "Further Image Formats")
qt_configure_add_summary_entry(ARGS "jasper")
qt_configure_add_summary_entry(ARGS "mng")
qt_configure_add_summary_entry(ARGS "tiff")
qt_configure_add_summary_entry(ARGS "system-tiff")
qt_configure_add_summary_entry(ARGS "webp")
qt_configure_add_summary_entry(ARGS "system-webp")
qt_configure_end_summary_section() # end of "Further Image Formats" section
