; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -instsimplify < %s | FileCheck %s

target datalayout = "e-m:o-i64:64-f80:128-n8:16:32:64-S128"

%struct.A = type { [7 x i8] }

define %struct.A* @test1(%struct.A* %b, %struct.A* %e) {
; CHECK-LABEL: @test1(
; CHECK-NEXT:    ret %struct.A* [[E:%.*]]
;
  %e_ptr = ptrtoint %struct.A* %e to i64
  %b_ptr = ptrtoint %struct.A* %b to i64
  %sub = sub i64 %e_ptr, %b_ptr
  %sdiv = sdiv exact i64 %sub, 7
  %gep = getelementptr inbounds %struct.A, %struct.A* %b, i64 %sdiv
  ret %struct.A* %gep
}

define i8* @test2(i8* %b, i8* %e) {
; CHECK-LABEL: @test2(
; CHECK-NEXT:    ret i8* [[E:%.*]]
;
  %e_ptr = ptrtoint i8* %e to i64
  %b_ptr = ptrtoint i8* %b to i64
  %sub = sub i64 %e_ptr, %b_ptr
  %gep = getelementptr inbounds i8, i8* %b, i64 %sub
  ret i8* %gep
}

define i64* @test3(i64* %b, i64* %e) {
; CHECK-LABEL: @test3(
; CHECK-NEXT:    ret i64* [[E:%.*]]
;
  %e_ptr = ptrtoint i64* %e to i64
  %b_ptr = ptrtoint i64* %b to i64
  %sub = sub i64 %e_ptr, %b_ptr
  %ashr = ashr exact i64 %sub, 3
  %gep = getelementptr inbounds i64, i64* %b, i64 %ashr
  ret i64* %gep
}

define %struct.A* @test4(%struct.A* %b) {
; CHECK-LABEL: @test4(
; CHECK-NEXT:    ret %struct.A* null
;
  %b_ptr = ptrtoint %struct.A* %b to i64
  %sub = sub i64 0, %b_ptr
  %sdiv = sdiv exact i64 %sub, 7
  %gep = getelementptr inbounds %struct.A, %struct.A* %b, i64 %sdiv
  ret %struct.A* %gep
}

define i8* @test5(i8* %b) {
; CHECK-LABEL: @test5(
; CHECK-NEXT:    ret i8* null
;
  %b_ptr = ptrtoint i8* %b to i64
  %sub = sub i64 0, %b_ptr
  %gep = getelementptr inbounds i8, i8* %b, i64 %sub
  ret i8* %gep
}

define i64* @test6(i64* %b) {
; CHECK-LABEL: @test6(
; CHECK-NEXT:    ret i64* null
;
  %b_ptr = ptrtoint i64* %b to i64
  %sub = sub i64 0, %b_ptr
  %ashr = ashr exact i64 %sub, 3
  %gep = getelementptr inbounds i64, i64* %b, i64 %ashr
  ret i64* %gep
}

define i8* @test7(i8* %b, i8** %e) {
; CHECK-LABEL: @test7(
; CHECK-NEXT:    [[E_PTR:%.*]] = ptrtoint i8** [[E:%.*]] to i64
; CHECK-NEXT:    [[B_PTR:%.*]] = ptrtoint i8* [[B:%.*]] to i64
; CHECK-NEXT:    [[SUB:%.*]] = sub i64 [[E_PTR]], [[B_PTR]]
; CHECK-NEXT:    [[GEP:%.*]] = getelementptr inbounds i8, i8* [[B]], i64 [[SUB]]
; CHECK-NEXT:    ret i8* [[GEP]]
;
  %e_ptr = ptrtoint i8** %e to i64
  %b_ptr = ptrtoint i8* %b to i64
  %sub = sub i64 %e_ptr, %b_ptr
  %gep = getelementptr inbounds i8, i8* %b, i64 %sub
  ret i8* %gep
}

define <8 x i64*> @undef_vec1() {
; CHECK-LABEL: @undef_vec1(
; CHECK-NEXT:    ret <8 x i64*> undef
;
  %el = getelementptr inbounds i64, i64* undef, <8 x i64> undef
  ret <8 x i64*> %el
}

define <8 x i64*> @undef_vec2() {
; CHECK-LABEL: @undef_vec2(
; CHECK-NEXT:    ret <8 x i64*> undef
;
  %el = getelementptr i64, <8 x i64*> undef, <8 x i64> undef
  ret <8 x i64*> %el
}

