/*
 * Decompiled with CFR 0.152.
 */
package gnu.bytecode;

import gnu.bytecode.AttrContainer;
import gnu.bytecode.Attribute;
import gnu.bytecode.ConstantPool;
import gnu.bytecode.CpoolEntry;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.SourceDebugExtAttr;
import gnu.bytecode.SourceFileAttr;
import gnu.bytecode.Type;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Vector;

public class ClassType
extends ObjectType
implements AttrContainer,
Externalizable {
    int classfileFormatVersion = 2949123;
    int thisClassIndex;
    ClassType superClass;
    int superClassIndex = -1;
    ClassType[] interfaces;
    int[] interfaceIndexes;
    public int access_flags;
    Attribute attributes;
    public static final ClassType[] noClasses = new ClassType[0];
    boolean emitDebugInfo = true;
    ConstantPool constants;
    SourceDebugExtAttr sourceDbgExt;
    Field fields;
    int fields_count;
    Field last_field;
    int ConstantValue_name_index;
    int Code_name_index;
    int LocalVariableTable_name_index;
    int LineNumberTable_name_index;
    Method methods;
    int methods_count;
    Method last_method;
    public Method constructor;

    public short getClassfileMajorVersion() {
        return (short)(this.classfileFormatVersion >> 16);
    }

    public short getClassfileMinorVersion() {
        return (short)(this.classfileFormatVersion & 0xFFFF);
    }

    public void setClassfileVersion(int major, int minor) {
        this.classfileFormatVersion = (major & 0xFFFF) * 65536 + minor * 65535;
    }

    public void setClassfileVersionJava5() {
        this.setClassfileVersion(49, 0);
    }

    public static ClassType make(String name) {
        return (ClassType)Type.getType(name);
    }

    public static ClassType make(String name, ClassType superClass) {
        ClassType type = ClassType.make(name);
        if (type.superClass == null) {
            type.setSuper(superClass);
        }
        return type;
    }

    public final Attribute getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute attributes) {
        this.attributes = attributes;
    }

    public final ConstantPool getConstants() {
        return this.constants;
    }

    public final CpoolEntry getConstant(int i) {
        if (this.constants == null || this.constants.pool == null || i > this.constants.count) {
            return null;
        }
        return this.constants.pool[i];
    }

    public final int getModifiers() {
        if (this.access_flags == 0 && (this.flags & 4) != 0 && this.getReflectClass() != null) {
            this.access_flags = this.reflectClass.getModifiers();
        }
        return this.access_flags;
    }

    public final void setModifiers(int flags) {
        this.access_flags = flags;
    }

    public final boolean hasOuterLink() {
        this.getFields();
        return (this.flags & 8) != 0;
    }

    public ClassType getOuterLinkType() {
        return !this.hasOuterLink() ? null : (ClassType)this.getDeclaredField("this$0").getType();
    }

    public final Field setOuterLink(ClassType outer) {
        if ((this.flags & 4) != 0) {
            throw new Error("setOuterLink called for existing class " + this.getName());
        }
        Field field = this.getDeclaredField("this$0");
        if (field == null) {
            field = this.addField("this$0", outer);
            this.flags |= 8;
            for (Method meth = this.methods; meth != null; meth = meth.getNext()) {
                if (!"<init>".equals(meth.getName())) continue;
                if (meth.code != null) {
                    throw new Error("setOuterLink called when " + meth + " has code");
                }
                Type[] arg_types = meth.arg_types;
                Type[] new_types = new Type[arg_types.length + 1];
                System.arraycopy(arg_types, 0, new_types, 1, arg_types.length);
                new_types[0] = outer;
                meth.arg_types = new_types;
                meth.signature = null;
            }
        } else if (!outer.equals(field.getType())) {
            throw new Error("inconsistent setOuterLink call for " + this.getName());
        }
        return field;
    }

    public boolean isAccessible(ClassType declaring, int modifiers) {
        String classPackage;
        String className;
        int cmods = declaring.getModifiers();
        if ((modifiers & 1) != 0 && (cmods & 1) != 0) {
            return true;
        }
        String callerName = this.getName();
        if (callerName.equals(className = declaring.getName())) {
            return true;
        }
        if ((modifiers & 2) != 0) {
            return false;
        }
        int dot = callerName.lastIndexOf(46);
        String callerPackage = dot >= 0 ? callerName.substring(0, dot) : "";
        dot = className.lastIndexOf(46);
        String string = classPackage = dot >= 0 ? className.substring(0, dot) : "";
        if (callerPackage.equals(classPackage)) {
            return true;
        }
        return (modifiers & 4) != 0 && this.isSubclass(declaring);
    }

    public void setName(String name) {
        this.this_name = name;
        this.setSignature("L" + name.replace('.', '/') + ";");
    }

    public void setStratum(String stratum) {
        if (this.sourceDbgExt == null) {
            this.sourceDbgExt = new SourceDebugExtAttr(this);
        }
        this.sourceDbgExt.addStratum(stratum);
    }

    public void setSourceFile(String name) {
        int slash;
        if (this.sourceDbgExt != null) {
            this.sourceDbgExt.addFile(name);
            if (this.sourceDbgExt.fileCount > 1) {
                return;
            }
        }
        if ((slash = (name = SourceFileAttr.fixSourceFile(name)).lastIndexOf(47)) >= 0) {
            name = name.substring(slash + 1);
        }
        SourceFileAttr.setSourceFile(this, name);
    }

    public void setSuper(String name) {
        this.setSuper(name == null ? Type.pointer_type : ClassType.make(name));
    }

    public void setSuper(ClassType superClass) {
        this.superClass = superClass;
    }

    public ClassType getSuperclass() {
        if (this.superClass == null && !this.isInterface() && !"java.lang.Object".equals(this.getName()) && (this.flags & 4) != 0 && this.getReflectClass() != null) {
            this.superClass = (ClassType)ClassType.make(this.reflectClass.getSuperclass());
        }
        return this.superClass;
    }

    public String getPackageName() {
        String name = this.getName();
        int index = name.lastIndexOf(46);
        return index < 0 ? "" : name.substring(0, index);
    }

    public synchronized ClassType[] getInterfaces() {
        if (this.interfaces == null && (this.flags & 4) != 0 && this.getReflectClass() != null) {
            Class<?>[] reflectInterfaces = this.reflectClass.getInterfaces();
            int numInterfaces = reflectInterfaces.length;
            this.interfaces = numInterfaces == 0 ? noClasses : new ClassType[numInterfaces];
            for (int i = 0; i < numInterfaces; ++i) {
                this.interfaces[i] = (ClassType)Type.make(reflectInterfaces[i]);
            }
        }
        return this.interfaces;
    }

    public void setInterfaces(ClassType[] interfaces) {
        this.interfaces = interfaces;
    }

    public void addInterface(ClassType newInterface) {
        int oldCount;
        if (this.interfaces == null || this.interfaces.length == 0) {
            oldCount = 0;
            this.interfaces = new ClassType[1];
        } else {
            int i = oldCount = this.interfaces.length;
            while (--i >= 0) {
                if (this.interfaces[i] != newInterface) continue;
                return;
            }
            ClassType[] newInterfaces = new ClassType[oldCount + 1];
            System.arraycopy(this.interfaces, 0, newInterfaces, 0, oldCount);
            this.interfaces = newInterfaces;
        }
        this.interfaces[oldCount] = newInterface;
    }

    public final boolean isInterface() {
        return (this.getModifiers() & 0x200) != 0;
    }

    public final void setInterface(boolean val) {
        this.access_flags = val ? (this.access_flags |= 0x600) : (this.access_flags &= 0xFFFFFDFF);
    }

    public ClassType() {
    }

    public ClassType(String class_name) {
        this.setName(class_name);
    }

    public final synchronized Field getFields() {
        if ((this.flags & 5) == 4) {
            this.addFields();
        }
        return this.fields;
    }

    public final int getFieldCount() {
        return this.fields_count;
    }

    public Field getDeclaredField(String name) {
        Field field = this.getFields();
        while (field != null) {
            if (name.equals(field.name)) {
                return field;
            }
            field = field.next;
        }
        return null;
    }

    public Field getField(String name, int mask) {
        ClassType cl = this;
        do {
            Field field;
            if ((field = cl.getDeclaredField(name)) != null && (mask == -1 || (field.getModifiers() & mask) != 0)) {
                return field;
            }
            ClassType[] interfaces = cl.getInterfaces();
            if (interfaces == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                field = interfaces[i].getField(name, mask);
                if (field == null) continue;
                return field;
            }
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public Field getField(String name) {
        return this.getField(name, 1);
    }

    public Field addField() {
        return new Field(this);
    }

    public Field addField(String name) {
        Field field = new Field(this);
        field.setName(name);
        return field;
    }

    public final Field addField(String name, Type type) {
        Field field = new Field(this);
        field.setName(name);
        field.setType(type);
        return field;
    }

    public final Field addField(String name, Type type, int flags) {
        Field field = this.addField(name, type);
        field.flags = flags;
        return field;
    }

    public void addFields() {
        java.lang.reflect.Field[] fields;
        Class clas = this.getReflectClass();
        try {
            fields = clas.getDeclaredFields();
        }
        catch (SecurityException ex) {
            fields = clas.getFields();
        }
        int count = fields.length;
        for (int i = 0; i < count; ++i) {
            java.lang.reflect.Field field = fields[i];
            if ("this$0".equals(field.getName())) {
                this.flags |= 8;
            }
            this.addField(field.getName(), Type.make(field.getType()), field.getModifiers());
        }
        this.flags |= 1;
    }

    public final Method getMethods() {
        return this.methods;
    }

    public final int getMethodCount() {
        return this.methods_count;
    }

    Method addMethod() {
        return new Method(this, 0);
    }

    public Method addMethod(String name) {
        return this.addMethod(name, 0);
    }

    public Method addMethod(String name, int flags) {
        Method method = new Method(this, flags);
        method.setName(name);
        return method;
    }

    public Method addMethod(String name, Type[] arg_types, Type return_type, int flags) {
        return this.addMethod(name, flags, arg_types, return_type);
    }

    public Method addMethod(String name, int flags, Type[] arg_types, Type return_type) {
        Method method = this.getDeclaredMethod(name, arg_types);
        if (method != null && return_type.equals(method.getReturnType()) && (flags & method.access_flags) == flags) {
            return method;
        }
        method = this.addMethod(name, flags);
        method.arg_types = arg_types;
        method.return_type = return_type;
        return method;
    }

    public Method addMethod(String name, String signature, int flags) {
        Method meth = this.addMethod(name, flags);
        meth.setSignature(signature);
        return meth;
    }

    public Method getMethod(java.lang.reflect.Method method) {
        String name = method.getName();
        Class<?>[] parameterClasses = method.getParameterTypes();
        Type[] parameterTypes = new Type[parameterClasses.length];
        int i = parameterClasses.length;
        while (--i >= 0) {
            parameterTypes[i] = Type.make(parameterClasses[i]);
        }
        return this.addMethod(name, method.getModifiers(), parameterTypes, Type.make(method.getReturnType()));
    }

    public final synchronized Method getDeclaredMethods() {
        if ((this.flags & 6) == 4) {
            this.addMethods(this.getReflectClass());
        }
        return this.methods;
    }

    public final int countMethods(Filter filter, int searchSupers) {
        return this.getMethods(filter, searchSupers, null, 0);
    }

    public Method[] getMethods(Filter filter, boolean searchSupers) {
        return this.getMethods(filter, searchSupers ? 1 : 0);
    }

    public Method[] getMethods(Filter filter, int searchSupers) {
        int count = this.getMethods(filter, searchSupers, null, 0);
        Method[] result = new Method[count];
        this.getMethods(filter, searchSupers, result, 0);
        return result;
    }

    public int getMethods(Filter filter, int searchSupers, Method[] result, int offset) {
        int count = 0;
        for (ClassType ctype = this; ctype != null; ctype = ctype.getSuperclass()) {
            ClassType[] interfaces;
            for (Method meth = ctype.getDeclaredMethods(); meth != null; meth = meth.getNext()) {
                if (!filter.select(meth)) continue;
                if (result != null) {
                    result[offset + count] = meth;
                }
                ++count;
            }
            if (searchSupers == 0) break;
            if (searchSupers <= 1 || (interfaces = ctype.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                count += interfaces[i].getMethods(filter, searchSupers, result, offset + count);
            }
        }
        return count;
    }

    public int getMethods(Filter filter, int searchSupers, Vector result, String context) {
        int count = 0;
        for (ClassType ctype = this; ctype != null; ctype = ctype.getSuperclass()) {
            ClassType[] interfaces;
            if (context == null || (ctype.getModifiers() & 1) != 0 || context.equals(ctype.getPackageName())) {
                for (Method meth = ctype.getDeclaredMethods(); meth != null; meth = meth.getNext()) {
                    if (!filter.select(meth)) continue;
                    if (result != null) {
                        result.addElement(meth);
                    }
                    ++count;
                }
            }
            if (searchSupers == 0) break;
            if (searchSupers <= 1 || (interfaces = ctype.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                count += interfaces[i].getMethods(filter, searchSupers, result, context);
            }
        }
        return count;
    }

    public Method getDeclaredMethod(String name, Type[] arg_types) {
        int needOuterLinkArg = "<init>".equals(name) && this.hasOuterLink() ? 1 : 0;
        Method method = this.getDeclaredMethods();
        while (method != null) {
            if (name.equals(method.getName())) {
                Type[] method_args = method.getParameterTypes();
                if (arg_types == null || arg_types == method_args && needOuterLinkArg == 0) {
                    return method;
                }
                int i = arg_types.length;
                if (i == method_args.length - needOuterLinkArg) {
                    String need_sig;
                    String meth_sig;
                    Type need_type;
                    Type meth_type;
                    while (--i >= 0 && ((meth_type = method_args[i + needOuterLinkArg]) == (need_type = arg_types[i]) || need_type == null || (meth_sig = meth_type.getSignature()).equals(need_sig = need_type.getSignature()))) {
                    }
                    if (i < 0) {
                        return method;
                    }
                }
            }
            method = method.next;
        }
        return null;
    }

    public Method getDeclaredMethod(String name, int argCount) {
        Method result = null;
        int needOuterLinkArg = "<init>".equals(name) && this.hasOuterLink() ? 1 : 0;
        Method method = this.getDeclaredMethods();
        while (method != null) {
            if (name.equals(method.getName()) && argCount + needOuterLinkArg == method.getParameterTypes().length) {
                if (result != null) {
                    throw new Error("ambiguous call to getDeclaredMethod(\"" + name + "\", " + argCount + ")\n - " + result + "\n - " + method);
                }
                result = method;
            }
            method = method.next;
        }
        return result;
    }

    public Method getMethod(String name, Type[] arg_types) {
        ClassType cl = this;
        do {
            Method method;
            if ((method = cl.getDeclaredMethod(name, arg_types)) == null) continue;
            return method;
        } while ((cl = cl.getSuperclass()) != null);
        cl = this;
        do {
            ClassType[] interfaces;
            if ((interfaces = cl.getInterfaces()) == null) continue;
            for (int i = 0; i < interfaces.length; ++i) {
                Method method = interfaces[i].getDeclaredMethod(name, arg_types);
                if (method == null) continue;
                return method;
            }
        } while ((cl = cl.getSuperclass()) != null);
        return null;
    }

    public void addMethods(Class clas) {
        Constructor<?>[] cmethods;
        java.lang.reflect.Method[] methods;
        this.flags |= 2;
        try {
            methods = clas.getDeclaredMethods();
        }
        catch (SecurityException ex) {
            methods = clas.getMethods();
        }
        int count = methods.length;
        for (int i = 0; i < count; ++i) {
            java.lang.reflect.Method method = methods[i];
            if (!method.getDeclaringClass().equals(clas)) continue;
            int modifiers = method.getModifiers();
            Class<?>[] paramTypes = method.getParameterTypes();
            int j = paramTypes.length;
            Type[] args = new Type[j];
            while (--j >= 0) {
                args[j] = Type.make(paramTypes[j]);
            }
            Method meth = this.addMethod(method.getName(), modifiers);
            meth.arg_types = args;
            meth.return_type = Type.make(method.getReturnType());
        }
        try {
            cmethods = clas.getDeclaredConstructors();
        }
        catch (SecurityException ex) {
            cmethods = clas.getConstructors();
        }
        count = cmethods.length;
        for (int i = 0; i < count; ++i) {
            int modifiers;
            Constructor<?> method = cmethods[i];
            if (!method.getDeclaringClass().equals(clas) || ((modifiers = method.getModifiers()) & 5) == 0) continue;
            Class<?>[] paramTypes = method.getParameterTypes();
            int j = paramTypes.length;
            Type[] args = new Type[j];
            while (--j >= 0) {
                args[j] = Type.make(paramTypes[j]);
            }
            Method meth = this.addMethod("<init>", modifiers);
            meth.arg_types = args;
            meth.return_type = Type.void_type;
        }
    }

    public Method[] getMatchingMethods(String name, Type[] paramTypes, int flags) {
        int nMatches = 0;
        Vector<Method> matches = new Vector<Method>(10);
        for (Method method = this.methods; method != null; method = method.getNext()) {
            Type[] mtypes;
            if (!name.equals(method.getName()) || (flags & 8) != (method.access_flags & 8) || (flags & 1) > (method.access_flags & 1) || (mtypes = method.arg_types).length != paramTypes.length) continue;
            ++nMatches;
            matches.addElement(method);
        }
        Object[] result = new Method[nMatches];
        matches.copyInto(result);
        return result;
    }

    public void doFixups() {
        if (this.constants == null) {
            this.constants = new ConstantPool();
        }
        if (this.thisClassIndex == 0) {
            this.thisClassIndex = this.constants.addClass((ObjectType)this).index;
        }
        if (this.superClass == this) {
            this.setSuper((ClassType)null);
        }
        if (this.superClassIndex < 0) {
            int n = this.superClassIndex = this.superClass == null ? 0 : this.constants.addClass((ObjectType)this.superClass).index;
        }
        if (this.interfaces != null && this.interfaceIndexes == null) {
            int n = this.interfaces.length;
            this.interfaceIndexes = new int[n];
            for (int i = 0; i < n; ++i) {
                this.interfaceIndexes[i] = this.constants.addClass((ObjectType)this.interfaces[i]).index;
            }
        }
        Field field = this.fields;
        while (field != null) {
            field.assign_constants(this);
            field = field.next;
        }
        Method method = this.methods;
        while (method != null) {
            method.assignConstants();
            method = method.next;
        }
        Attribute.assignConstants(this, this);
    }

    public void writeToStream(OutputStream stream) throws IOException {
        DataOutputStream dstr = new DataOutputStream(stream);
        this.doFixups();
        dstr.writeInt(-889275714);
        dstr.writeShort(this.getClassfileMinorVersion());
        dstr.writeShort(this.getClassfileMajorVersion());
        if (this.constants == null) {
            dstr.writeShort(1);
        } else {
            this.constants.write(dstr);
        }
        dstr.writeShort(this.access_flags);
        dstr.writeShort(this.thisClassIndex);
        dstr.writeShort(this.superClassIndex);
        if (this.interfaceIndexes == null) {
            dstr.writeShort(0);
        } else {
            int interfaces_count = this.interfaceIndexes.length;
            dstr.writeShort(interfaces_count);
            for (int i = 0; i < interfaces_count; ++i) {
                dstr.writeShort(this.interfaceIndexes[i]);
            }
        }
        dstr.writeShort(this.fields_count);
        Field field = this.fields;
        while (field != null) {
            field.write(dstr, this);
            field = field.next;
        }
        dstr.writeShort(this.methods_count);
        Method method = this.methods;
        while (method != null) {
            method.write(dstr, this);
            method = method.next;
        }
        Attribute.writeAll(this, dstr);
        this.flags |= 3;
    }

    public void writeToFile(String filename) throws IOException {
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(filename));
        this.writeToStream(stream);
        ((OutputStream)stream).close();
    }

    public void writeToFile() throws IOException {
        this.writeToFile(this.this_name.replace('.', File.separatorChar) + ".class");
    }

    public byte[] writeToArray() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(500);
        try {
            this.writeToStream(stream);
        }
        catch (IOException ex) {
            throw new InternalError(ex.toString());
        }
        return stream.toByteArray();
    }

    public static byte[] to_utf8(String str) {
        if (str == null) {
            return null;
        }
        int str_len = str.length();
        int utf_len = 0;
        for (int i = 0; i < str_len; ++i) {
            char c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                ++utf_len;
                continue;
            }
            if (c <= '\u07ff') {
                utf_len += 2;
                continue;
            }
            utf_len += 3;
        }
        byte[] buffer = new byte[utf_len];
        int j = 0;
        for (int i = 0; i < str_len; ++i) {
            char c = str.charAt(i);
            if (c > '\u0000' && c <= '\u007f') {
                buffer[j++] = (byte)c;
                continue;
            }
            if (c <= '\u07ff') {
                buffer[j++] = (byte)(0xC0 | c >> 6 & 0x1F);
                buffer[j++] = (byte)(0x80 | c >> 0 & 0x3F);
                continue;
            }
            buffer[j++] = (byte)(0xE0 | c >> 12 & 0xF);
            buffer[j++] = (byte)(0x80 | c >> 6 & 0x3F);
            buffer[j++] = (byte)(0x80 | c >> 0 & 0x3F);
        }
        return buffer;
    }

    public final boolean implementsInterface(ClassType iface) {
        if (this == iface) {
            return true;
        }
        ClassType baseClass = this.getSuperclass();
        if (baseClass != null && baseClass.implementsInterface(iface)) {
            return true;
        }
        ClassType[] interfaces = this.getInterfaces();
        if (interfaces != null) {
            int i = interfaces.length;
            while (--i >= 0) {
                if (!interfaces[i].implementsInterface(iface)) continue;
                return true;
            }
        }
        return false;
    }

    public final boolean isSubclass(String cname) {
        ClassType ctype = this;
        do {
            if (!cname.equals(ctype.getName())) continue;
            return true;
        } while ((ctype = ctype.getSuperclass()) != null);
        return false;
    }

    public final boolean isSubclass(ClassType other) {
        if (other.isInterface()) {
            return this.implementsInterface(other);
        }
        if (this == tostring_type && other == string_type || this == string_type && other == tostring_type) {
            return true;
        }
        for (ClassType baseClass = this; baseClass != null; baseClass = baseClass.getSuperclass()) {
            if (baseClass != other) continue;
            return true;
        }
        return false;
    }

    public int compare(Type other) {
        if (other == nullType) {
            return 1;
        }
        if (!(other instanceof ClassType)) {
            return ClassType.swappedCompareResult(other.compare(this));
        }
        String name = this.getName();
        if (name != null && name.equals(other.getName())) {
            return 0;
        }
        ClassType cother = (ClassType)other;
        if (this.isSubclass(cother)) {
            return -1;
        }
        if (cother.isSubclass(this)) {
            return 1;
        }
        if (this == tostring_type) {
            return cother == Type.pointer_type ? -1 : 1;
        }
        if (cother == tostring_type) {
            return this == Type.pointer_type ? 1 : -1;
        }
        if (this.isInterface() || cother.isInterface()) {
            return -2;
        }
        return -3;
    }

    public String toString() {
        return "ClassType " + this.getName();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.getName());
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.setName(in.readUTF());
        this.flags |= 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object readResolve() throws ObjectStreamException {
        Hashtable map2;
        String name = this.getName();
        Hashtable hashtable = map2 = mapNameToType;
        synchronized (hashtable) {
            Type found = (Type)map2.get(name);
            if (found != null) {
                return found;
            }
            map2.put(name, this);
        }
        return this;
    }

    public void cleanupAfterCompilation() {
        for (Method meth = this.methods; meth != null; meth = meth.getNext()) {
            meth.cleanupAfterCompilation();
        }
        this.constants = null;
        this.attributes = null;
        this.sourceDbgExt = null;
    }
}

