#!/bin/sh
#  Author: Jamie Strandboge <jamie@ubuntu.com>
#  Copyright (C) 2015 Canonical Ltd.
#
#  This script is distributed under the terms and conditions of the GNU General
#  Public License, Version 3 or later. See http://www.gnu.org/copyleft/gpl.html
#  for details.

set -e

script=`realpath "$0"`
topdir=`dirname "$script"`
aa_dir="$topdir/../data/apparmor"
sc_dir="$topdir/../data/seccomp"

cd "$aa_dir"
find . \( -type f -o -type l \) -print | sed 's#^\./##' | sort | while read f ; do
    echo "Checking `basename $sc_dir`/$f"
    if [ ! -f "$sc_dir/$f" ]; then
        echo "Missing `basename $sc_dir`/$f"
        exit 1
    fi
done

cd "$sc_dir"
find . \( -type f -o -type l \) -print | sed 's#^\./##' | sort | while read f ; do
    echo "Checking `basename $aa_dir`/$f"
    if [ ! -f "$aa_dir/$f" ]; then
        echo "Missing `basename $aa_dir`/$f"
        exit 1
    fi
done
