########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Monday 19 June 2006 16:00:08 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Pmv/VisionInterface/CoarseMolSurface_net.py,v 1.2 2008/05/12 20:01:32 annao Exp $
#
# $Id: CoarseMolSurface_net.py,v 1.2 2008/05/12 20:01:32 annao Exp $
#

from traceback import print_exc

## loading libraries ##
from Pmv.VisionInterface.PmvNodes import pmvlib
masterNet.getEditor().addLibraryInstance(pmvlib,"Pmv.VisionInterface.PmvNodes", "pmvlib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

from DejaVu.VisionInterface.DejaVuNodes import vizlib
masterNet.getEditor().addLibraryInstance(vizlib,"DejaVu.VisionInterface.DejaVuNodes", "vizlib")

from Volume.VisionInterface.VolumeNodes import vollib
masterNet.getEditor().addLibraryInstance(vollib,"Volume.VisionInterface.VolumeNodes", "vollib")

try:
    ## saving node Pmv ##
    from Pmv.VisionInterface.PmvNodes import PmvNode
    Pmv_0 = PmvNode(vf=masterNet.editor.vf, constrkw = {'vf': 'masterNet.editor.vf'}, name='Pmv', library=pmvlib)
    masterNet.addNode(Pmv_0,22,13)
except:
    print "WARNING: failed to restore PmvNode named Pmv in network masterNet"
    print_exc()
    Pmv_0=None

try:
    ## saving node Get Selection ##
    from Pmv.VisionInterface.PmvNodes import PmvGetSelection
    Get_Selection_1 = PmvGetSelection(constrkw = {}, name='Get Selection', library=pmvlib)
    masterNet.addNode(Get_Selection_1,22,58)
except:
    print "WARNING: failed to restore PmvGetSelection named Get Selection in network masterNet"
    print_exc()
    Get_Selection_1=None

try:
    ## saving node UT Blur ##
    from Volume.VisionInterface.VolumeNodes import UTBlurring
    UT_Blur_2 = UTBlurring(constrkw = {}, name='UT Blur', library=vollib)
    masterNet.addNode(UT_Blur_2,4,142)
    apply(UT_Blur_2.inputPortByName['Xdim'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
    apply(UT_Blur_2.inputPortByName['Ydim'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
    apply(UT_Blur_2.inputPortByName['Zdim'].configure, (), {'color': 'yellow', 'cast': True, 'shape': 'circle'})
    UT_Blur_2.inputPortByName['Xdim'].widget.set(32, run=False)
    UT_Blur_2.inputPortByName['Xdim'].unbindWidget()
    UT_Blur_2.inputPortByName['Ydim'].widget.set(32, run=False)
    UT_Blur_2.inputPortByName['Ydim'].unbindWidget()
    UT_Blur_2.inputPortByName['Zdim'].widget.set(32, run=False)
    UT_Blur_2.inputPortByName['Zdim'].unbindWidget()
    UT_Blur_2.inputPortByName['blobbyness'].widget.set(-0.2, run=False)
    apply(UT_Blur_2.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore UTBlurring named UT Blur in network masterNet"
    print_exc()
    UT_Blur_2=None

try:
    ## saving node UT-Isocontour ##
    from Volume.VisionInterface.VolumeNodes import Isocontour
    UT_Isocontour_3 = Isocontour(constrkw = {}, name='UT-Isocontour', library=vollib)
    masterNet.addNode(UT_Isocontour_3,16,330)
    UT_Isocontour_3.inputPortByName['isovalue'].widget.set(16.85935, run=False)
except:
    print "WARNING: failed to restore Isocontour named UT-Isocontour in network masterNet"
    print_exc()
    UT_Isocontour_3=None

try:
    ## saving node IndexedPolygons ##
    from DejaVu.VisionInterface.GeometryNodes import IndexedPolygonsNE
    IndexedPolygons_4 = IndexedPolygonsNE(constrkw = {}, name='IndexedPolygons', library=vizlib)
    masterNet.addNode(IndexedPolygons_4,17,370)
    IndexedPolygons_4.inputPortByName['name'].widget.set("", run=False)
except:
    print "WARNING: failed to restore IndexedPolygonsNE named IndexedPolygons in network masterNet"
    print_exc()
    IndexedPolygons_4=None

try:
    ## saving node Pmv Viewer ##
    from Pmv.VisionInterface.PmvNodes import PmvViewer
    Pmv_Viewer_5 = PmvViewer(viewer=masterNet.editor.vf.GUI.VIEWER, constrkw = {'viewer': 'masterNet.editor.vf.GUI.VIEWER'}, name='Pmv Viewer', library=pmvlib)
    masterNet.addNode(Pmv_Viewer_5,18,546)


    ## Clipping Planes for root
    if Pmv_Viewer_5.vi.rootObject:
        Pmv_Viewer_5.vi.rootObject.clipP = []
        Pmv_Viewer_5.vi.rootObject.clipPI = []
        pass  ## needed in case there no modif
    ## End Clipping Planes for root

except:
    print "WARNING: failed to restore PmvViewer named Pmv Viewer in network masterNet"
    print_exc()
    Pmv_Viewer_5=None

try:
    ## saving node Dial ##
    from Vision.StandardNodes import DialNE
    Dial_6 = DialNE(constrkw = {}, name='Dial', library=stdlib)
    masterNet.addNode(Dial_6,210,8)
    apply(Dial_6.inputPortByName['mini'].configure, (), {'datatype': 'int', 'cast': True, 'shape': 'circle', 'color': 'yellow'})
    apply(Dial_6.inputPortByName['maxi'].configure, (), {'datatype': 'int', 'cast': True, 'shape': 'circle', 'color': 'yellow'})
    apply(Dial_6.inputPortByName['dial'].widget.configure, (), {'continuous': None, 'type': 'int'})
    Dial_6.inputPortByName['dial'].widget.set(32, run=False)
except:
    print "WARNING: failed to restore DialNE named Dial in network masterNet"
    print_exc()
    Dial_6=None

try:
    ## saving node ConnectedComponents ##
    from DejaVu.VisionInterface.DejaVuNodes import ConnectedComponents
    ConnectedComponents_7 = ConnectedComponents(constrkw={}, name='ConnectedComponents', library=vizlib)
    masterNet.addNode(ConnectedComponents_7,90,430)
    ConnectedComponents_7.inputPortByName['onegeom'].widget.set(1, run=False)
    #apply(ConnectedComponents_7.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ConnectedComponents named ConnectedComponents in network masterNet"
    print_exc()
    ConnectedComponents_7=None

masterNet.freeze()

## saving connections for network CoarseMolSurface ##
if Pmv_0 is not None and Get_Selection_1 is not None:
    try:
        masterNet.connectNodes(
            Pmv_0, Get_Selection_1, "PMV", "Pmv", blocking=True)
    except:
        print "WARNING: failed to restore connection between Pmv_0 and Get_Selection_1 in network masterNet"
if UT_Blur_2 is not None and UT_Isocontour_3 is not None:
    try:
        masterNet.connectNodes(
            UT_Blur_2, UT_Isocontour_3, "maskGrid", "grid3D", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Blur_2 and UT_Isocontour_3 in network masterNet"
if UT_Isocontour_3 is not None and IndexedPolygons_4 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_3, IndexedPolygons_4, "coords", "coords", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_3 and IndexedPolygons_4 in network masterNet"
if UT_Isocontour_3 is not None and IndexedPolygons_4 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_3, IndexedPolygons_4, "indices", "indices", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_3 and IndexedPolygons_4 in network masterNet"
if UT_Isocontour_3 is not None and IndexedPolygons_4 is not None:
    try:
        masterNet.connectNodes(
            UT_Isocontour_3, IndexedPolygons_4, "normals", "vnormals", blocking=True)
    except:
        print "WARNING: failed to restore connection between UT_Isocontour_3 and IndexedPolygons_4 in network masterNet"
if IndexedPolygons_4 is not None and Pmv_Viewer_5 is not None:
    try:
        masterNet.connectNodes(
            IndexedPolygons_4, Pmv_Viewer_5, "indexedPolygons", "geometries", blocking=True)
    except:
        print "WARNING: failed to restore connection between IndexedPolygons_4 and Pmv_Viewer_5 in network masterNet"
if Get_Selection_1 is not None and UT_Blur_2 is not None:
    try:
        masterNet.connectNodes(
            Get_Selection_1, UT_Blur_2, "nodes", "molFrag", blocking=True)
    except:
        print "WARNING: failed to restore connection between Get_Selection_1 and UT_Blur_2 in network masterNet"
if Dial_6 is not None and UT_Blur_2 is not None:
    try:
        masterNet.connectNodes(
            Dial_6, UT_Blur_2, "value", "Xdim", blocking=True)
    except:
        print "WARNING: failed to restore connection between Dial_6 and UT_Blur_2 in network masterNet"
if Dial_6 is not None and UT_Blur_2 is not None:
    try:
        masterNet.connectNodes(
            Dial_6, UT_Blur_2, "value", "Ydim", blocking=True)
    except:
        print "WARNING: failed to restore connection between Dial_6 and UT_Blur_2 in network masterNet"
if Dial_6 is not None and UT_Blur_2 is not None:
    try:
        masterNet.connectNodes(
            Dial_6, UT_Blur_2, "value", "Zdim", blocking=True)
    except:
        print "WARNING: failed to restore connection between Dial_6 and UT_Blur_2 in network masterNet"
masterNet.unfreeze()
if Dial_6:
    Dial_6.run()
#try:
#    masterNet.run()
#except:
#    pass
